/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.view.GetViewAction;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.View;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class CreateViewAction
extends ActionType<GetViewAction.Response> {
    private static final int MAX_NAME_LENGTH = 64;
    private static final int MAX_DESCRIPTION_LENGTH = 256;
    private static final int MAX_TARGET_COUNT = 25;
    private static final int MAX_TARGET_INDEX_PATTERN_LENGTH = 64;
    public static final CreateViewAction INSTANCE = new CreateViewAction();
    public static final String NAME = "cluster:admin/views/create";

    private CreateViewAction() {
        super(NAME, GetViewAction.Response::new);
    }

    public static class TransportAction
    extends TransportClusterManagerNodeAction<Request, GetViewAction.Response> {
        private final ViewService viewService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ViewService viewService) {
            super(CreateViewAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.viewService = viewService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected GetViewAction.Response read(StreamInput in) throws IOException {
            return new GetViewAction.Response(in);
        }

        @Override
        protected void clusterManagerOperation(Request request, ClusterState state, ActionListener<GetViewAction.Response> listener) throws Exception {
            this.viewService.createView(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    @ExperimentalApi
    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private final String name;
        private final String description;
        private final List<Target> targets;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("create_view_request", args -> new Request((String)args[0], (String)args[1], (List)args[2]));

        public Request(String name, String description, List<Target> targets) {
            this.name = name;
            this.description = Objects.requireNonNullElse(description, "");
            this.targets = targets;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.description = in.readString();
            this.targets = in.readList(Target::new);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public List<Target> getTargets() {
            return new ArrayList<Target>(this.targets);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.name.equals(that.name) && this.description.equals(that.description) && this.targets.equals(that.targets);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description, this.targets);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty(this.name)) {
                validationException = ValidateActions.addValidationError("name cannot be empty or null", validationException);
            }
            if (this.name != null && this.name.length() > 64) {
                validationException = ValidateActions.addValidationError("name must be less than 64 characters in length", validationException);
            }
            if (this.description != null && this.description.length() > 256) {
                validationException = ValidateActions.addValidationError("description must be less than 256 characters in length", validationException);
            }
            if (CollectionUtils.isEmpty(this.targets)) {
                validationException = ValidateActions.addValidationError("targets cannot be empty", validationException);
            } else {
                if (this.targets.size() > 25) {
                    validationException = ValidateActions.addValidationError("view cannot have more than 25 targets", validationException);
                }
                for (Target target : this.targets) {
                    List validationMessages = Optional.ofNullable(target.validate()).map(ValidationException::validationErrors).orElse(List.of());
                    for (String validationMessage : validationMessages) {
                        validationException = ValidateActions.addValidationError(validationMessage, validationException);
                    }
                }
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeString(this.description);
            out.writeList(this.targets);
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), View.NAME_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), View.DESCRIPTION_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Target.fromXContent(p), View.TARGETS_FIELD);
        }

        @ExperimentalApi
        public static class Target
        implements Writeable {
            public final String indexPattern;
            private static final ConstructingObjectParser<Target, Void> PARSER = new ConstructingObjectParser("target", args -> new Target((String)args[0]));

            public Target(String indexPattern) {
                this.indexPattern = indexPattern;
            }

            public Target(StreamInput in) throws IOException {
                this.indexPattern = in.readString();
            }

            public String getIndexPattern() {
                return this.indexPattern;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Target that = (Target)o;
                return this.indexPattern.equals(that.indexPattern);
            }

            public int hashCode() {
                return Objects.hash(this.indexPattern);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.indexPattern);
            }

            public ActionRequestValidationException validate() {
                ActionRequestValidationException validationException = null;
                if (Strings.isNullOrEmpty(this.indexPattern)) {
                    validationException = ValidateActions.addValidationError("index pattern cannot be empty or null", validationException);
                }
                if (this.indexPattern != null && this.indexPattern.length() > 64) {
                    validationException = ValidateActions.addValidationError("target index pattern must be less than 64 characters in length", validationException);
                }
                return validationException;
            }

            public static Target fromXContent(XContentParser parser) throws IOException {
                return PARSER.parse(parser, null);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), View.Target.INDEX_PATTERN_FIELD);
            }
        }
    }
}

