/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.explain;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.get.GetResult;

@PublicApi(since="1.0.0")
public class ExplainResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField _INDEX = new ParseField("_index", new String[0]);
    private static final ParseField _ID = new ParseField("_id", new String[0]);
    private static final ParseField MATCHED = new ParseField("matched", new String[0]);
    private static final ParseField EXPLANATION = new ParseField("explanation", new String[0]);
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    private static final ParseField DETAILS = new ParseField("details", new String[0]);
    private static final ParseField GET = new ParseField("get", new String[0]);
    private String index;
    private String id;
    private boolean exists;
    private Explanation explanation;
    private GetResult getResult;
    private static final ConstructingObjectParser<ExplainResponse, Boolean> PARSER = new ConstructingObjectParser<ExplainResponse, Boolean>("explain", true, (arg, exists) -> new ExplainResponse((String)arg[0], (String)arg[1], (boolean)exists, (Explanation)arg[2], (GetResult)arg[3]));

    public ExplainResponse(String index, String id, boolean exists) {
        this.index = index;
        this.id = id;
        this.exists = exists;
    }

    public ExplainResponse(String index, String id, boolean exists, Explanation explanation) {
        this(index, id, exists);
        this.explanation = explanation;
    }

    public ExplainResponse(String index, String id, boolean exists, Explanation explanation, GetResult getResult) {
        this(index, id, exists, explanation);
        this.getResult = getResult;
    }

    public ExplainResponse(StreamInput in) throws IOException {
        super(in);
        this.index = in.readString();
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readString();
        }
        this.id = in.readString();
        this.exists = in.readBoolean();
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.readBoolean()) {
            this.getResult = new GetResult(in);
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public boolean isMatch() {
        return this.explanation != null && this.explanation.isMatch();
    }

    public boolean hasExplanation() {
        return this.explanation != null;
    }

    public boolean isExists() {
        return this.exists;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.exists ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeBoolean(this.exists);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    public static ExplainResponse fromXContent(XContentParser parser, boolean exists) {
        return PARSER.apply(parser, exists);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_INDEX.getPreferredName(), this.index);
        builder.field(_ID.getPreferredName(), this.id);
        builder.field(MATCHED.getPreferredName(), this.isMatch());
        if (this.hasExplanation()) {
            builder.startObject(EXPLANATION.getPreferredName());
            this.buildExplanation(builder, this.explanation);
            builder.endObject();
        }
        if (this.getResult != null) {
            builder.startObject(GET.getPreferredName());
            this.getResult.toXContentEmbedded(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.field(VALUE.getPreferredName(), explanation.getValue());
        builder.field(DESCRIPTION.getPreferredName(), explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray(DETAILS.getPreferredName());
            for (Explanation exp : innerExps) {
                builder.startObject();
                this.buildExplanation(builder, exp);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainResponse other = (ExplainResponse)obj;
        return this.index.equals(other.index) && this.id.equals(other.id) && Objects.equals(this.explanation, other.explanation) && this.getResult.isExists() == other.getResult.isExists() && Objects.equals(this.getResult.sourceAsMap(), other.getResult.sourceAsMap()) && Objects.equals(this.getResult.getFields(), other.getResult.getFields());
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id, this.explanation, this.getResult.isExists(), this.getResult.sourceAsMap(), this.getResult.getFields());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), _INDEX);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), _ID);
        ConstructingObjectParser<Explanation, Explanation> explanationParser = new ConstructingObjectParser<Explanation, Explanation>("explanation", true, arg -> {
            if (((Float)arg[0]).floatValue() > 0.0f) {
                return Explanation.match((Number)Float.valueOf(((Float)arg[0]).floatValue()), (String)arg[1], (Collection)arg[2]);
            }
            return Explanation.noMatch((String)arg[1], (Collection)arg[2]);
        });
        explanationParser.declareFloat(ConstructingObjectParser.constructorArg(), VALUE);
        explanationParser.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        explanationParser.declareObjectArray(ConstructingObjectParser.constructorArg(), explanationParser, DETAILS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), explanationParser, EXPLANATION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> GetResult.fromXContentEmbedded(p), GET);
    }
}

