/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.VersionType;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestService;
import org.opensearch.ingest.Pipeline;

@PublicApi(since="1.0.0")
public class SimulatePipelineRequest
extends ActionRequest
implements ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SimulatePipelineRequest.class);
    private String id;
    private boolean verbose;
    private BytesReference source;
    private MediaType mediaType;
    static final String SIMULATED_PIPELINE_ID = "_simulate_pipeline";

    public SimulatePipelineRequest(BytesReference source, MediaType mediaType) {
        this.source = Objects.requireNonNull(source);
        this.mediaType = Objects.requireNonNull(mediaType);
    }

    SimulatePipelineRequest() {
    }

    SimulatePipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.verbose = in.readBoolean();
        this.source = in.readBytesReference();
        this.mediaType = in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readMediaType() : (MediaType)in.readEnum(XContentType.class);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public MediaType getXContentType() {
        return this.mediaType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBoolean(this.verbose);
        out.writeBytesReference(this.source);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.mediaType.writeTo(out);
        } else {
            out.writeEnum((XContentType)this.mediaType);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.rawValue(this.source.streamInput(), this.mediaType);
        return builder;
    }

    static Parsed parseWithPipelineId(String pipelineId, Map<String, Object> config, boolean verbose, IngestService ingestService) {
        if (pipelineId == null) {
            throw new IllegalArgumentException("param [pipeline] is null");
        }
        Pipeline pipeline = ingestService.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline [" + pipelineId + "] does not exist");
        }
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    static Parsed parse(Map<String, Object> config, boolean verbose, IngestService ingestService) throws Exception {
        Map<String, Object> pipelineConfig = ConfigurationUtils.readMap(null, null, config, "pipeline");
        Pipeline pipeline = Pipeline.create(SIMULATED_PIPELINE_ID, pipelineConfig, ingestService.getProcessorFactories(), ingestService.getScriptService());
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    private static List<IngestDocument> parseDocs(Map<String, Object> config) {
        List docs = ConfigurationUtils.readList(null, null, config, "docs");
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("must specify at least one document in [docs]");
        }
        ArrayList<IngestDocument> ingestDocumentList = new ArrayList<IngestDocument>();
        for (Object object : docs) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("malformed [docs] section, should include an inner object");
            }
            Map dataMap = (Map)object;
            Map<String, Object> document = ConfigurationUtils.readMap(null, null, dataMap, "_source");
            String index = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.INDEX.getFieldName(), "_index");
            String id = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ID.getFieldName(), "_id");
            String routing = ConfigurationUtils.readOptionalStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ROUTING.getFieldName());
            Long version = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION.getFieldName())) {
                Object versionFieldValue = ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.VERSION.getFieldName());
                if (versionFieldValue instanceof Integer || versionFieldValue instanceof Long) {
                    version = ((Number)versionFieldValue).longValue();
                } else {
                    throw new IllegalArgumentException("Failed to parse parameter [_version], only int or long is accepted");
                }
            }
            VersionType versionType = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION_TYPE.getFieldName())) {
                versionType = VersionType.fromString(ConfigurationUtils.readStringProperty(null, null, dataMap, IngestDocument.Metadata.VERSION_TYPE.getFieldName()));
            }
            IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, document);
            if (dataMap.containsKey(IngestDocument.Metadata.IF_SEQ_NO.getFieldName())) {
                Object ifSeqNoFieldValue = ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.IF_SEQ_NO.getFieldName());
                if (ifSeqNoFieldValue instanceof Integer || ifSeqNoFieldValue instanceof Long) {
                    ingestDocument.setFieldValue(IngestDocument.Metadata.IF_SEQ_NO.getFieldName(), ((Number)ifSeqNoFieldValue).longValue());
                } else {
                    throw new IllegalArgumentException("Failed to parse parameter [_if_seq_no], only int or long is accepted");
                }
            }
            if (dataMap.containsKey(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName())) {
                Object ifPrimaryTermFieldValue = ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName());
                if (ifPrimaryTermFieldValue instanceof Integer || ifPrimaryTermFieldValue instanceof Long) {
                    ingestDocument.setFieldValue(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName(), ((Number)ifPrimaryTermFieldValue).longValue());
                } else {
                    throw new IllegalArgumentException("Failed to parse parameter [_if_primary_term], only int or long is accepted");
                }
            }
            ingestDocumentList.add(ingestDocument);
        }
        return ingestDocumentList;
    }

    static class Parsed {
        private final List<IngestDocument> documents;
        private final Pipeline pipeline;
        private final boolean verbose;

        Parsed(Pipeline pipeline, List<IngestDocument> documents, boolean verbose) {
            this.pipeline = pipeline;
            this.documents = Collections.unmodifiableList(documents);
            this.verbose = verbose;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public List<IngestDocument> getDocuments() {
            return this.documents;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    public static final class Fields {
        static final String PIPELINE = "pipeline";
        static final String DOCS = "docs";
        static final String SOURCE = "_source";
    }
}

