/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.opensearch.action.search.ParsedScrollId;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollAsyncAction;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.AtomicArray;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.ShardFetchRequest;
import org.opensearch.search.internal.InternalScrollSearchRequest;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ScrollQuerySearchResult;
import org.opensearch.transport.Transport;

final class SearchScrollQueryThenFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQuerySearchResult> {
    private final SearchTask task;
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final AtomicArray<QuerySearchResult> queryResults;

    SearchScrollQueryThenFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQuerySearchResult result) {
        this.queryResults.setOnce(shardId, result.queryResult());
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQuerySearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollQuery(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return new SearchPhase(this, SearchPhaseName.FETCH.getName()){
            final /* synthetic */ SearchScrollQueryThenFetchAsyncAction this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            public void run() {
                final SearchPhaseController.ReducedQueryPhase reducedQueryPhase = this.this$0.searchPhaseController.reducedScrollQueryPhase(this.this$0.queryResults.asList());
                ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
                if (scoreDocs.length == 0) {
                    this.this$0.sendResponse(reducedQueryPhase, this.this$0.fetchResults);
                    return;
                }
                List<Integer>[] docIdsToLoad = this.this$0.searchPhaseController.fillDocIdsToLoad(this.this$0.queryResults.length(), scoreDocs);
                ScoreDoc[] lastEmittedDocPerShard = this.this$0.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, this.this$0.queryResults.length());
                final CountDown counter = new CountDown(docIdsToLoad.length);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    int index = i;
                    List<Integer> docIds = docIdsToLoad[index];
                    if (docIds != null) {
                        final QuerySearchResult querySearchResult = this.this$0.queryResults.get(index);
                        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[index];
                        ShardFetchRequest shardFetchRequest = new ShardFetchRequest(querySearchResult.getContextId(), docIds, lastEmittedDoc);
                        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
                        DiscoveryNode node = (DiscoveryNode)clusterNodeLookup.apply(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                        assert (node != null) : "target node is null in secondary phase";
                        Transport.Connection connection = this.this$0.getConnection(searchShardTarget.getClusterAlias(), node);
                        this.this$0.searchTransportService.sendExecuteFetchScroll(connection, shardFetchRequest, this.this$0.task, new SearchActionListener<FetchSearchResult>(this, querySearchResult.getSearchShardTarget(), index){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(searchShardTarget, shardIndex);
                            }

                            @Override
                            protected void innerOnResponse(FetchSearchResult response) {
                                this.this$1.this$0.fetchResults.setOnce(response.getShardIndex(), response);
                                if (counter.countDown()) {
                                    this.this$1.this$0.sendResponse(reducedQueryPhase, this.this$1.this$0.fetchResults);
                                }
                            }

                            @Override
                            public void onFailure(Exception t) {
                                this.this$1.this$0.onShardFailure(this.this$1.getName(), counter, querySearchResult.getContextId(), t, querySearchResult.getSearchShardTarget(), () -> this.this$1.this$0.sendResponsePhase(reducedQueryPhase, this.this$1.this$0.fetchResults));
                            }
                        });
                        continue;
                    }
                    if (!counter.countDown()) continue;
                    this.this$0.sendResponse(reducedQueryPhase, this.this$0.fetchResults);
                }
            }
        };
    }
}

