/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import java.io.IOException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;

@ExperimentalApi
public class StreamSearchChannelListener<Response extends TransportResponse, Request extends TransportRequest>
implements ActionListener<Response> {
    private final TransportChannel channel;
    private final Request request;
    private final String actionName;

    public StreamSearchChannelListener(TransportChannel channel, String actionName, Request request) {
        this.channel = channel;
        this.request = request;
        this.actionName = actionName;
    }

    public void onStreamResponse(Response response, boolean isLastBatch) {
        assert (response != null);
        this.channel.sendResponseBatch((TransportResponse)response);
        if (isLastBatch) {
            this.channel.completeStream();
        }
    }

    @Override
    public final void onResponse(Response response) {
        this.onStreamResponse(response, true);
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (IOException exc) {
            this.channel.completeStream();
            throw new RuntimeException(exc);
        }
    }
}

