/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.nodes;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends ActionRequest {
    private String[] nodesIds;
    private DiscoveryNode[] concreteNodes;
    private final TimeValue DEFAULT_TIMEOUT_SECS = TimeValue.timeValueSeconds(30L);
    private TimeValue timeout;

    protected BaseNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.nodesIds = in.readStringArray();
        this.concreteNodes = in.readOptionalArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.timeout = in.readOptionalTimeValue();
    }

    protected BaseNodesRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.nodesIds = null;
        this.concreteNodes = concreteNodes;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public final Request nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, this.DEFAULT_TIMEOUT_SECS, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public DiscoveryNode[] concreteNodes() {
        return this.concreteNodes;
    }

    public void setConcreteNodes(DiscoveryNode[] concreteNodes) {
        this.concreteNodes = concreteNodes;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.nodesIds);
        out.writeOptionalArray(this.concreteNodes);
        out.writeOptionalTimeValue(this.timeout);
    }
}

