/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.client.core.BroadcastResponse;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;

public class DataStreamsStatsResponse
extends BroadcastResponse {
    private final int dataStreamCount;
    private final int backingIndices;
    private final ByteSizeValue totalStoreSize;
    private final Map<String, DataStreamStats> dataStreams;
    private static final ParseField DATA_STREAM_COUNT = new ParseField("data_stream_count", new String[0]);
    private static final ParseField BACKING_INDICES = new ParseField("backing_indices", new String[0]);
    private static final ParseField TOTAL_STORE_SIZE_BYTES = new ParseField("total_store_size_bytes", new String[0]);
    private static final ParseField DATA_STREAMS = new ParseField("data_streams", new String[0]);
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    private static final ParseField STORE_SIZE_BYTES = new ParseField("store_size_bytes", new String[0]);
    private static final ParseField MAXIMUM_TIMESTAMP = new ParseField("maximum_timestamp", new String[0]);
    private static final ConstructingObjectParser<DataStreamsStatsResponse, Void> PARSER = new ConstructingObjectParser("data_streams_stats", true, arg -> {
        BroadcastResponse.Shards shards = (BroadcastResponse.Shards)arg[0];
        Integer dataStreamCount = (Integer)arg[1];
        Integer backingIndices = (Integer)arg[2];
        ByteSizeValue totalStoreSize = (ByteSizeValue)arg[3];
        HashMap<String, DataStreamStats> dataStreams = new HashMap<String, DataStreamStats>();
        for (DataStreamStats dataStreamStats : (List)arg[4]) {
            dataStreams.put(dataStreamStats.dataStream, dataStreamStats);
        }
        return new DataStreamsStatsResponse(shards, dataStreamCount, backingIndices, totalStoreSize, dataStreams);
    });
    private static final ConstructingObjectParser<DataStreamStats, Void> ENTRY_PARSER = new ConstructingObjectParser("data_streams_stats.entry", true, arg -> {
        String dataStream = (String)arg[0];
        Integer backingIndices = (Integer)arg[1];
        ByteSizeValue storeSize = (ByteSizeValue)arg[2];
        Long maximumTimestamp = (Long)arg[3];
        return new DataStreamStats(dataStream, backingIndices, storeSize, maximumTimestamp);
    });

    protected DataStreamsStatsResponse(BroadcastResponse.Shards shards, int dataStreamCount, int backingIndices, ByteSizeValue totalStoreSize, Map<String, DataStreamStats> dataStreams) {
        super(shards);
        this.dataStreamCount = dataStreamCount;
        this.backingIndices = backingIndices;
        this.totalStoreSize = totalStoreSize;
        this.dataStreams = dataStreams;
    }

    public static DataStreamsStatsResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    public int getDataStreamCount() {
        return this.dataStreamCount;
    }

    public int getBackingIndices() {
        return this.backingIndices;
    }

    public ByteSizeValue getTotalStoreSize() {
        return this.totalStoreSize;
    }

    public Map<String, DataStreamStats> getDataStreams() {
        return this.dataStreams;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataStreamsStatsResponse that = (DataStreamsStatsResponse)obj;
        return this.dataStreamCount == that.dataStreamCount && this.backingIndices == that.backingIndices && Objects.equals(this.totalStoreSize, that.totalStoreSize) && Objects.equals(this.dataStreams, that.dataStreams);
    }

    public int hashCode() {
        return Objects.hash(this.dataStreamCount, this.backingIndices, this.totalStoreSize, this.dataStreams);
    }

    public String toString() {
        return "DataStreamsStatsResponse{dataStreamCount=" + this.dataStreamCount + ", backingIndices=" + this.backingIndices + ", totalStoreSize=" + String.valueOf(this.totalStoreSize) + ", dataStreams=" + String.valueOf(this.dataStreams) + "}";
    }

    static {
        DataStreamsStatsResponse.declareShardsField(PARSER);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), DATA_STREAM_COUNT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), BACKING_INDICES);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> new ByteSizeValue(p.longValue()), TOTAL_STORE_SIZE_BYTES, ObjectParser.ValueType.VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ENTRY_PARSER, DATA_STREAMS);
        ENTRY_PARSER.declareString(ConstructingObjectParser.constructorArg(), DATA_STREAM);
        ENTRY_PARSER.declareInt(ConstructingObjectParser.constructorArg(), BACKING_INDICES);
        ENTRY_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> new ByteSizeValue(p.longValue()), STORE_SIZE_BYTES, ObjectParser.ValueType.VALUE);
        ENTRY_PARSER.declareLong(ConstructingObjectParser.constructorArg(), MAXIMUM_TIMESTAMP);
    }

    public static class DataStreamStats {
        private final String dataStream;
        private final int backingIndices;
        private final ByteSizeValue storeSize;
        private final long maximumTimestamp;

        public DataStreamStats(String dataStream, int backingIndices, ByteSizeValue storeSize, long maximumTimestamp) {
            this.dataStream = dataStream;
            this.backingIndices = backingIndices;
            this.storeSize = storeSize;
            this.maximumTimestamp = maximumTimestamp;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public int getBackingIndices() {
            return this.backingIndices;
        }

        public ByteSizeValue getStoreSize() {
            return this.storeSize;
        }

        public long getMaximumTimestamp() {
            return this.maximumTimestamp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DataStreamStats that = (DataStreamStats)obj;
            return this.backingIndices == that.backingIndices && this.maximumTimestamp == that.maximumTimestamp && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.storeSize, that.storeSize);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream, this.backingIndices, this.storeSize, this.maximumTimestamp);
        }

        public String toString() {
            return "DataStreamStats{dataStream='" + this.dataStream + "', backingIndices=" + this.backingIndices + ", storeSize=" + String.valueOf(this.storeSize) + ", maximumTimestamp=" + this.maximumTimestamp + "}";
        }
    }
}

