/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.Objects;
import java.util.Optional;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public final class ClusterManagerMetrics {
    public static final String FOLLOWER_NODE_ID_TAG = "follower_node_id";
    public static final String REASON_TAG = "reason";
    private static final String LATENCY_METRIC_UNIT_MS = "ms";
    private static final String COUNTER_METRICS_UNIT = "1";
    public final Histogram clusterStateAppliersHistogram;
    public final Histogram clusterStateListenersHistogram;
    public final Histogram rerouteHistogram;
    public final Histogram clusterStateComputeHistogram;
    public final Histogram clusterStatePublishHistogram;
    public final Counter leaderCheckFailureCounter;
    public final Counter followerChecksFailureCounter;
    public final Counter asyncFetchFailureCounter;
    public final Counter asyncFetchSuccessCounter;
    public final Counter nodeLeftCounter;

    public ClusterManagerMetrics(MetricsRegistry metricsRegistry) {
        this.clusterStateAppliersHistogram = metricsRegistry.createHistogram("cluster.state.appliers.latency", "Histogram for tracking the latency of cluster state appliers", LATENCY_METRIC_UNIT_MS);
        this.clusterStateListenersHistogram = metricsRegistry.createHistogram("cluster.state.listeners.latency", "Histogram for tracking the latency of cluster state listeners", LATENCY_METRIC_UNIT_MS);
        this.rerouteHistogram = metricsRegistry.createHistogram("allocation.reroute.latency", "Histogram for recording latency of shard re-routing", LATENCY_METRIC_UNIT_MS);
        this.clusterStateComputeHistogram = metricsRegistry.createHistogram("cluster.state.new.compute.latency", "Histogram for recording time taken to compute new cluster state", LATENCY_METRIC_UNIT_MS);
        this.clusterStatePublishHistogram = metricsRegistry.createHistogram("cluster.state.publish.success.latency", "Histogram for recording time taken to publish a new cluster state", LATENCY_METRIC_UNIT_MS);
        this.followerChecksFailureCounter = metricsRegistry.createCounter("followers.checker.failure.count", "Counter for number of failed follower checks", COUNTER_METRICS_UNIT);
        this.leaderCheckFailureCounter = metricsRegistry.createCounter("leader.checker.failure.count", "Counter for number of failed leader checks", COUNTER_METRICS_UNIT);
        this.asyncFetchFailureCounter = metricsRegistry.createCounter("async.fetch.failure.count", "Counter for number of failed async fetches", COUNTER_METRICS_UNIT);
        this.asyncFetchSuccessCounter = metricsRegistry.createCounter("async.fetch.success.count", "Counter for number of successful async fetches", COUNTER_METRICS_UNIT);
        this.nodeLeftCounter = metricsRegistry.createCounter("node.left.count", "Counter for node left operation", COUNTER_METRICS_UNIT);
    }

    public void recordLatency(Histogram histogram, Double value) {
        histogram.record(value);
    }

    public void recordLatency(Histogram histogram, Double value, Optional<Tags> tags) {
        if (Objects.isNull(tags) || tags.isEmpty()) {
            histogram.record(value);
            return;
        }
        histogram.record(value, tags.get());
    }

    public void incrementCounter(Counter counter, Double value) {
        this.incrementCounter(counter, value, Optional.empty());
    }

    public void incrementCounter(Counter counter, Double value, Optional<Tags> tags) {
        if (Objects.isNull(tags) || tags.isEmpty()) {
            counter.add(value);
            return;
        }
        counter.add(value, tags.get());
    }
}

