/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.action.shard;

import java.util.function.Function;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RerouteService;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class LocalShardStateAction
extends ShardStateAction {
    @Inject
    public LocalShardStateAction(ClusterService clusterService, TransportService transportService, AllocationService allocationService, RerouteService rerouteService, ThreadPool threadPool) {
        super(clusterService, transportService, allocationService, rerouteService, threadPool);
    }

    @Override
    public void shardStarted(ShardRouting shardRouting, long primaryTerm, String message, ActionListener<Void> listener, ClusterState currentState) {
        Function<ClusterState, ClusterState> clusterStateUpdater = clusterState -> {
            RoutingTable routingTable = clusterState.getRoutingTable();
            IndexRoutingTable indexRoutingTable = routingTable.index(shardRouting.index());
            ClusterState.Builder clusterStateBuilder = ClusterState.builder(clusterState);
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(routingTable);
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder(shardRouting.index());
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexShardRoutingTable.shardId().equals(shardRouting.shardId())) {
                    IndexShardRoutingTable.Builder indexShardRoutingTableBuilder = new IndexShardRoutingTable.Builder(indexShardRoutingTable);
                    indexShardRoutingTableBuilder.removeShard(shardRouting);
                    indexShardRoutingTableBuilder.addShard(shardRouting.moveToStarted());
                    indexRoutingTableBuilder.addIndexShard(indexShardRoutingTableBuilder.build());
                    continue;
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingTable);
            }
            routingTableBuilder.add(indexRoutingTableBuilder);
            clusterStateBuilder.routingTable(routingTableBuilder.build());
            return clusterStateBuilder.build();
        };
        this.clusterService.getClusterApplierService().updateClusterState("shard-started " + String.valueOf(shardRouting.shardId()), clusterStateUpdater, (s, e) -> {});
    }

    @Override
    public void localShardFailed(ShardRouting shardRouting, String message, Exception failure, ActionListener<Void> listener, ClusterState currentState) {
    }
}

