/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.logging.OpenSearchLogMessage;
import org.opensearch.core.common.Strings;

public class DeprecatedMessage
extends OpenSearchLogMessage {
    public static final String X_OPAQUE_ID_FIELD_NAME = "x-opaque-id";
    static final int MAX_DEDUPE_CACHE_ENTRIES = 16384;
    private static final Set<String> keyDedupeCache = ConcurrentHashMap.newKeySet();
    private final String keyWithXOpaqueId;

    public DeprecatedMessage(String key, String xOpaqueId, String messagePattern, Object ... args) {
        super(DeprecatedMessage.fieldMap(key, xOpaqueId), messagePattern, args);
        this.keyWithXOpaqueId = key + xOpaqueId;
    }

    public static void resetDeprecatedMessageForTests() {
        keyDedupeCache.clear();
    }

    private static Map<String, Object> fieldMap(String key, String xOpaqueId) {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        if (!Strings.isNullOrEmpty(key)) {
            builder.put("key", key);
        }
        if (!Strings.isNullOrEmpty(xOpaqueId)) {
            builder.put(X_OPAQUE_ID_FIELD_NAME, xOpaqueId);
        }
        return builder.immutableMap();
    }

    public boolean isAlreadyLogged() {
        if (keyDedupeCache.contains(this.keyWithXOpaqueId)) {
            return true;
        }
        if (keyDedupeCache.size() >= 16384) {
            return true;
        }
        return !keyDedupeCache.add(this.keyWithXOpaqueId);
    }
}

