/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class MinimumScoreCollector
extends FilterCollector {
    private final float minimumScore;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        super(collector);
        this.minimumScore = minimumScore;
    }

    public Collector getCollector() {
        return this.in;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return ScoreCachingWrappingScorer.wrap(new FilterLeafCollector(super.getLeafCollector(context)){
            Scorable scorer;

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                this.in.setScorer(scorer);
            }

            @Override
            public void collect(int doc) throws IOException {
                if (this.scorer.score() >= MinimumScoreCollector.this.minimumScore) {
                    this.in.collect(doc);
                }
            }
        });
    }

    @Override
    public void setWeight(Weight weight) {
    }

    @Override
    public ScoreMode scoreMode() {
        return this.in.scoreMode() == ScoreMode.TOP_SCORES ? ScoreMode.TOP_SCORES : ScoreMode.COMPLETE;
    }
}

