/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.lucene.index.DerivedSourceLeafReader;
import org.opensearch.core.common.bytes.BytesReference;

public class DerivedSourceDirectoryReader
extends FilterDirectoryReader {
    private final CheckedBiFunction<LeafReader, Integer, BytesReference, IOException> sourceProvider;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;

    private DerivedSourceDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, CheckedBiFunction<LeafReader, Integer, BytesReference, IOException> sourceProvider) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.sourceProvider = sourceProvider;
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return new DerivedSourceDirectoryReader(this.in, this.wrapper, this.sourceProvider);
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static DerivedSourceDirectoryReader wrap(DirectoryReader in, final CheckedBiFunction<LeafReader, Integer, BytesReference, IOException> sourceProvider) throws IOException {
        return new DerivedSourceDirectoryReader(in, new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return new DerivedSourceLeafReader(reader, docID -> (BytesReference)sourceProvider.apply(reader, docID));
            }
        }, sourceProvider);
    }
}

