/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.StringHelper;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.function.CombineFunction;
import org.opensearch.common.lucene.search.function.Functions;
import org.opensearch.common.lucene.search.function.LeafScoreFunction;
import org.opensearch.common.lucene.search.function.ScoreFunction;
import org.opensearch.common.util.BitMixer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.SortedBinaryDocValues;

public class RandomScoreFunction
extends ScoreFunction {
    private final int originalSeed;
    private final int saltedSeed;
    private final IndexFieldData<?> fieldData;
    private final String functionName;

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData) {
        this(seed, salt, uidFieldData, null);
    }

    public RandomScoreFunction(int seed, int salt, IndexFieldData<?> uidFieldData, @Nullable String functionName) {
        super(CombineFunction.MULTIPLY);
        this.originalSeed = seed;
        this.saltedSeed = BitMixer.mix(seed, salt);
        this.fieldData = uidFieldData;
        this.functionName = functionName;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
        SortedBinaryDocValues values;
        if (this.fieldData != null) {
            Object leafData = this.fieldData.load(ctx);
            values = leafData.getBytesValues();
            if (values == null) {
                throw new NullPointerException("failed to get fielddata");
            }
        } else {
            values = null;
        }
        return new LeafScoreFunction(this){
            final /* synthetic */ RandomScoreFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                int hash = values == null ? BitMixer.mix(ctx.docBase + docId, this.this$0.saltedSeed) : (values.advanceExact(docId) ? StringHelper.murmurhash3_x86_32(values.nextValue(), this.this$0.saltedSeed) : this.this$0.saltedSeed);
                return (float)(hash & 0xFFFFFF) / 1.6777216E7f;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String field = this.this$0.fieldData == null ? null : this.this$0.fieldData.getFieldName();
                return Explanation.match((Number)Float.valueOf((float)this.score(docId, subQueryScore.getValue().floatValue())), "random score function (seed: " + this.this$0.originalSeed + ", field: " + field + Functions.nameOrEmptyArg(this.this$0.functionName) + ")", new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        RandomScoreFunction randomScoreFunction = (RandomScoreFunction)other;
        return this.originalSeed == randomScoreFunction.originalSeed && this.saltedSeed == randomScoreFunction.saltedSeed;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.originalSeed, this.saltedSeed);
    }
}

