/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.time;

import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.time.JavaDateMathParser;
import org.opensearch.common.time.OpenSearchDateTimeFormatter;
import org.opensearch.common.time.OpenSearchDateTimePrinter;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.core.common.Strings;

class JavaDateFormatter
implements DateFormatter {
    private static final Map<TemporalField, Long> ROUND_UP_GENERIC_BASE_FIELDS = new HashMap<TemporalField, Long>(4);
    private final String format;
    private final String printFormat;
    private final OpenSearchDateTimePrinter printer;
    private final List<OpenSearchDateTimeFormatter> parsers;
    private final JavaDateFormatter roundupParser;
    private final Boolean canCacheLastParsedFormatter;
    private volatile OpenSearchDateTimeFormatter lastParsedformatter;
    private static final BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> ROUND_UP_BASE_FIELDS = (builder, parser) -> {
        String parserString = parser.toString();
        if (parserString.contains(ChronoField.DAY_OF_YEAR.toString())) {
            builder.parseDefaulting(ChronoField.DAY_OF_YEAR, 1L);
        } else {
            builder.parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L);
            builder.parseDefaulting(ChronoField.DAY_OF_MONTH, 1L);
        }
        ROUND_UP_GENERIC_BASE_FIELDS.forEach(builder::parseDefaulting);
    };

    JavaDateFormatter(String format, String printFormat, OpenSearchDateTimePrinter printer, Boolean canCacheLastParsedFormatter, OpenSearchDateTimeFormatter ... parsers) {
        this(format, printFormat, printer, ROUND_UP_BASE_FIELDS, canCacheLastParsedFormatter, parsers);
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        this(format, format, (OpenSearchDateTimePrinter)JavaDateFormatter.wrapFormatter(printer), false, JavaDateFormatter.wrapAllFormatters(parsers));
    }

    JavaDateFormatter(String format, OpenSearchDateTimePrinter printer, OpenSearchDateTimeFormatter ... parsers) {
        this(format, format, printer, false, parsers);
    }

    JavaDateFormatter(String format, String printFormat, OpenSearchDateTimePrinter printer, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer, Boolean canCacheLastParsedFormatter, OpenSearchDateTimeFormatter ... parsers) {
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        this.lastParsedformatter = null;
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        long distinctZones = Arrays.stream(parsers).map(OpenSearchDateTimeFormatter::getZone).distinct().count();
        if (distinctZones > 1L) {
            throw new IllegalArgumentException("formatters must have the same time zone");
        }
        long distinctLocales = Arrays.stream(parsers).map(OpenSearchDateTimeFormatter::getLocale).distinct().count();
        if (distinctLocales > 1L) {
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        this.printer = printer;
        this.format = format;
        this.printFormat = printFormat;
        this.canCacheLastParsedFormatter = canCacheLastParsedFormatter;
        this.parsers = parsers.length == 0 ? Collections.singletonList((OpenSearchDateTimeFormatter)printer) : Arrays.asList(parsers);
        List<DateTimeFormatter> roundUp = this.createRoundUpParser(format, roundupParserConsumer);
        this.roundupParser = new RoundUpFormatter(format, JavaDateFormatter.wrapAllFormatters(roundUp));
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer, DateTimeFormatter ... parsers) {
        this(format, format, (OpenSearchDateTimePrinter)JavaDateFormatter.wrapFormatter(printer), roundupParserConsumer, false, JavaDateFormatter.wrapAllFormatters(parsers));
    }

    private List<DateTimeFormatter> createRoundUpParser(String format, BiConsumer<DateTimeFormatterBuilder, DateTimeFormatter> roundupParserConsumer) {
        if (!format.contains("||")) {
            ArrayList<DateTimeFormatter> roundUpParsers = new ArrayList<DateTimeFormatter>();
            for (OpenSearchDateTimeFormatter customparser : this.parsers) {
                DateTimeFormatter parser = customparser.getFormatter();
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                builder.append(parser);
                roundupParserConsumer.accept(builder, parser);
                roundUpParsers.add(builder.toFormatter(this.locale()));
            }
            return roundUpParsers;
        }
        return null;
    }

    public static DateFormatter combined(String input, List<DateFormatter> formatters, DateFormatter printFormatter, Boolean canCacheLastParsedFormatter) {
        assert (formatters.size() > 0);
        assert (printFormatter != null);
        ArrayList<OpenSearchDateTimeFormatter> parsers = new ArrayList<OpenSearchDateTimeFormatter>(formatters.size());
        ArrayList<OpenSearchDateTimeFormatter> roundUpParsers = new ArrayList<OpenSearchDateTimeFormatter>(formatters.size());
        assert (printFormatter instanceof JavaDateFormatter);
        JavaDateFormatter javaPrintFormatter = (JavaDateFormatter)printFormatter;
        OpenSearchDateTimePrinter printer = javaPrintFormatter.getPrinter();
        for (DateFormatter formatter : formatters) {
            assert (formatter instanceof JavaDateFormatter);
            JavaDateFormatter javaDateFormatter = (JavaDateFormatter)formatter;
            parsers.addAll(javaDateFormatter.getParsers());
            roundUpParsers.addAll(javaDateFormatter.getRoundupParser().getParsers());
        }
        return new JavaDateFormatter(input, javaPrintFormatter.format, printer, roundUpParsers, parsers, canCacheLastParsedFormatter & FeatureFlags.isEnabled(FeatureFlags.DATETIME_FORMATTER_CACHING_SETTING));
    }

    private JavaDateFormatter(String format, String printFormat, OpenSearchDateTimePrinter printer, List<OpenSearchDateTimeFormatter> roundUpParsers, List<OpenSearchDateTimeFormatter> parsers, Boolean canCacheLastParsedFormatter) {
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_GENERIC_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        this.lastParsedformatter = null;
        this.format = format;
        this.printFormat = printFormat;
        this.printer = printer;
        this.roundupParser = roundUpParsers != null ? new RoundUpFormatter(format, roundUpParsers) : null;
        this.parsers = parsers;
        this.canCacheLastParsedFormatter = canCacheLastParsedFormatter;
    }

    private JavaDateFormatter(String format, DateTimeFormatter printer, List<DateTimeFormatter> roundUpParsers, List<DateTimeFormatter> parsers) {
        this(format, format, (OpenSearchDateTimePrinter)JavaDateFormatter.wrapFormatter(printer), JavaDateFormatter.wrapAllFormatters(roundUpParsers), JavaDateFormatter.wrapAllFormatters(parsers), false);
    }

    private JavaDateFormatter(String format, OpenSearchDateTimePrinter printer, List<OpenSearchDateTimeFormatter> roundUpParsers, List<OpenSearchDateTimeFormatter> parsers) {
        this(format, format, printer, roundUpParsers, parsers, false);
    }

    JavaDateFormatter getRoundupParser() {
        return this.roundupParser;
    }

    OpenSearchDateTimePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        try {
            return this.doParse(input);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("failed to parse date field [" + input + "] with format [" + this.format + "]", e);
        }
    }

    private TemporalAccessor doParse(String input) {
        if (this.parsers.size() > 1) {
            ParsePosition pos;
            Object object = null;
            if (this.canCacheLastParsedFormatter.booleanValue() && this.lastParsedformatter != null && this.parsingSucceeded(object = this.lastParsedformatter.parseObject(input, pos = new ParsePosition(0)), input, pos)) {
                return (TemporalAccessor)object;
            }
            for (OpenSearchDateTimeFormatter formatter : this.parsers) {
                ParsePosition pos2;
                object = formatter.parseObject(input, pos2 = new ParsePosition(0));
                if (!this.parsingSucceeded(object, input, pos2)) continue;
                this.lastParsedformatter = formatter;
                return (TemporalAccessor)object;
            }
            throw new DateTimeParseException("Failed to parse with all enclosed parsers", input, 0);
        }
        return this.parsers.get(0).parse(input);
    }

    private boolean parsingSucceeded(Object object, String input, ParsePosition pos) {
        return object != null && pos.getIndex() == input.length();
    }

    private static OpenSearchDateTimeFormatter wrapFormatter(DateTimeFormatter formatter) {
        return new OpenSearchDateTimeFormatter(formatter);
    }

    private static OpenSearchDateTimeFormatter[] wrapAllFormatters(DateTimeFormatter ... formatters) {
        return (OpenSearchDateTimeFormatter[])Arrays.stream(formatters).map(JavaDateFormatter::wrapFormatter).toArray(OpenSearchDateTimeFormatter[]::new);
    }

    private static List<OpenSearchDateTimeFormatter> wrapAllFormatters(List<DateTimeFormatter> formatters) {
        return formatters.stream().map(JavaDateFormatter::wrapFormatter).collect(Collectors.toList());
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.zone())) {
            return this;
        }
        ArrayList<OpenSearchDateTimeFormatter> parsers = new ArrayList<OpenSearchDateTimeFormatter>(this.parsers.stream().map(p -> p.withZone(zoneId)).collect(Collectors.toList()));
        List<OpenSearchDateTimeFormatter> roundUpParsers = this.roundupParser.getParsers().stream().map(p -> p.withZone(zoneId)).collect(Collectors.toList());
        return new JavaDateFormatter(this.format, this.printFormat, this.printer.withZone(zoneId), roundUpParsers, parsers, this.canCacheLastParsedFormatter);
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.locale())) {
            return this;
        }
        ArrayList<OpenSearchDateTimeFormatter> parsers = new ArrayList<OpenSearchDateTimeFormatter>(this.parsers.stream().map(p -> p.withLocale(locale)).collect(Collectors.toList()));
        List<OpenSearchDateTimeFormatter> roundUpParsers = this.roundupParser.getParsers().stream().map(p -> p.withLocale(locale)).collect(Collectors.toList());
        return new JavaDateFormatter(this.format, this.printFormat, this.printer.withLocale(locale), roundUpParsers, parsers, this.canCacheLastParsedFormatter);
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(DateFormatters.from(accessor));
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public String printPattern() {
        return this.printFormat;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this, this.getRoundupParser());
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }

    Collection<OpenSearchDateTimeFormatter> getParsers() {
        return this.parsers;
    }

    static class RoundUpFormatter
    extends JavaDateFormatter {
        RoundUpFormatter(String format, List<OpenSearchDateTimeFormatter> roundUpParsers) {
            super(format, (OpenSearchDateTimePrinter)RoundUpFormatter.firstFrom(roundUpParsers), null, roundUpParsers);
        }

        private static OpenSearchDateTimeFormatter firstFrom(List<OpenSearchDateTimeFormatter> roundUpParsers) {
            return roundUpParsers.get(0);
        }

        @Override
        JavaDateFormatter getRoundupParser() {
            throw new UnsupportedOperationException("RoundUpFormatter does not have another roundUpFormatter");
        }
    }
}

