/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import org.opensearch.common.Numbers;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.BitMixer;
import org.opensearch.common.util.LongArray;

@InternalApi
public class ReorganizingLongHash
implements Releasable {
    private static final long MAX_CAPACITY = 0x100000000L;
    private static final long DEFAULT_INITIAL_CAPACITY = 32L;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private final float loadFactor;
    private final BigArrays bigArrays;
    private long capacity;
    private long mask;
    private long grow;
    private long size;
    private LongArray table;
    private LongArray keys;
    private static final long MASK_ORDINAL = 0xFFFFFFFFL;
    private static final long MASK_FINGERPRINT = 0xFFFF00000000L;
    private static final long MASK_PSL = 0x7FFF000000000000L;
    private static final long INCR_PSL = 0x1000000000000L;

    public ReorganizingLongHash(BigArrays bigArrays) {
        this(32L, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReorganizingLongHash(long initialCapacity, float loadFactor, BigArrays bigArrays) {
        assert (initialCapacity > 0L) : "initial capacity must be greater than 0";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "load factor must be between 0 and 1";
        this.bigArrays = bigArrays;
        this.loadFactor = loadFactor;
        this.capacity = Numbers.nextPowerOfTwo((long)((float)initialCapacity / loadFactor));
        assert (this.capacity <= 0x100000000L) : "required capacity too large";
        this.mask = this.capacity - 1L;
        this.grow = (long)((float)this.capacity * loadFactor);
        this.size = 0L;
        try {
            this.table = bigArrays.newLongArray(this.capacity, false);
            this.table.fill(0L, this.capacity, -1L);
            this.keys = bigArrays.newLongArray(initialCapacity, false);
            if (this.table != null && this.keys != null) return;
        }
        catch (Throwable throwable) {
            if (this.table != null && this.keys != null) throw throwable;
            Releasables.closeWhileHandlingException(this.table, this.keys);
            throw throwable;
        }
        Releasables.closeWhileHandlingException(this.table, this.keys);
    }

    public long add(long key) {
        long ordinal = this.find(key);
        if (ordinal != -1L) {
            return -1L - ordinal;
        }
        if (this.size >= this.grow) {
            this.grow();
        }
        return this.insert(key);
    }

    public long get(long ordinal) {
        return this.keys.get(ordinal);
    }

    public long find(long key) {
        long hash = this.hash(key);
        long fingerprint = hash & 0xFFFF00000000L;
        long idx = hash & this.mask;
        long value;
        while ((value = this.table.get(idx)) != -1L) {
            long ordinal;
            if ((value & 0xFFFF00000000L) == fingerprint && this.keys.get(ordinal = value & 0xFFFFFFFFL) == key) {
                return ordinal;
            }
            idx = idx + 1L & this.mask;
        }
        return -1L;
    }

    public long size() {
        return this.size;
    }

    private long insert(long key) {
        long hash = this.hash(key);
        long fingerprint = hash & 0xFFFF00000000L;
        long idx = hash & this.mask;
        long value = fingerprint | this.size;
        if ((value = this.table.set(idx, value)) == -1L) {
            return this.append(key);
        }
        while (true) {
            idx = idx + 1L & this.mask;
            value += 0x1000000000000L;
            long existingValue = this.table.get(idx);
            if (existingValue == -1L) {
                this.table.set(idx, value);
                return this.append(key);
            }
            if ((existingValue & 0x7FFF000000000000L) > (value & 0x7FFF000000000000L)) continue;
            value = this.table.set(idx, value);
        }
    }

    private long append(long key) {
        this.keys = this.bigArrays.grow(this.keys, this.size + 1L);
        this.keys.set(this.size, key);
        return this.size++;
    }

    long hash(long key) {
        return BitMixer.mix64(key);
    }

    LongArray getTable() {
        return this.table;
    }

    private void grow() {
        assert (this.capacity < 0x100000000L) : "hash table already at the max capacity";
        long oldSize = this.size;
        this.capacity <<= 1;
        this.mask = this.capacity - 1L;
        this.size = 0L;
        this.grow = (long)((float)this.capacity * this.loadFactor);
        this.table = this.bigArrays.resize(this.table, this.capacity);
        this.table.fill(0L, this.capacity, -1L);
        for (long ordinal = 0L; ordinal < oldSize; ++ordinal) {
            this.insert(this.keys.get(ordinal));
        }
    }

    @Override
    public void close() {
        Releasables.close(this.table, this.keys);
    }
}

