/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.util;

import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import org.opensearch.common.collect.Iterators;
import org.opensearch.core.common.Strings;

public class CollectionUtils {
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static <T> void sortAndDedup(List<T> array, Comparator<T> comparator) {
        if (array.size() <= 1) {
            return;
        }
        array.sort(comparator);
        ListIterator<T> deduped = array.listIterator();
        T cmp = deduped.next();
        Iterator<T> oldArray = array.iterator();
        oldArray.next();
        do {
            T old;
            if (comparator.compare(cmp, old = oldArray.next()) == 0 || (cmp = deduped.next()) == old) continue;
            deduped.set(old);
        } while (oldArray.hasNext());
        array.subList(deduped.nextIndex(), array.size()).clear();
    }

    public static int[] toArray(Collection<Integer> ints) {
        Objects.requireNonNull(ints);
        return ints.stream().mapToInt(s -> s).toArray();
    }

    public static void ensureNoSelfReferences(Object value, String messageHint) {
        Iterable<?> it = CollectionUtils.convert(value);
        if (it != null) {
            CollectionUtils.ensureNoSelfReferences(it, value, Collections.newSetFromMap(new IdentityHashMap()), messageHint);
        }
    }

    private static Iterable<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return () -> Iterators.concat(map.keySet().iterator(), map.values().iterator());
        }
        if (value instanceof Iterable && !(value instanceof Path)) {
            return (Iterable)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    private static void ensureNoSelfReferences(Iterable<?> value, Object originalReference, Set<Object> ancestors, String messageHint) {
        if (value != null) {
            if (!ancestors.add(originalReference)) {
                String suffix = Strings.isNullOrEmpty(messageHint) ? "" : String.format(Locale.ROOT, " (%s)", messageHint);
                throw new IllegalArgumentException("Iterable object is self-referencing itself" + suffix);
            }
            for (Object o : value) {
                CollectionUtils.ensureNoSelfReferences(CollectionUtils.convert(o), o, ancestors, messageHint);
            }
            ancestors.remove(originalReference);
        }
    }

    public static <R, T> Map<R, T> copyMap(Map<R, T> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<R, T>(map));
    }

    public static <E> ArrayList<E> iterableAsArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <E> ArrayList<E> arrayAsArrayList(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> ArrayList<E> asArrayList(E first, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(1 + other.length);
        list.add(first);
        list.addAll(Arrays.asList(other));
        return list;
    }

    public static <E> ArrayList<E> asArrayList(E first, E second, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(2 + other.length);
        list.add(first);
        list.add(second);
        list.addAll(Arrays.asList(other));
        return list;
    }

    public static <E> ArrayList<E> newSingletonArrayList(E element) {
        return new ArrayList<E>(Collections.singletonList(element));
    }

    public static <E> List<List<E>> eagerPartition(List<E> list, int size) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        ArrayList result = new ArrayList((int)Math.ceil(list.size() / size));
        ArrayList<E> accumulator = new ArrayList<E>(size);
        int count = 0;
        for (E element : list) {
            if (count == size) {
                result.add(accumulator);
                accumulator = new ArrayList(size);
                count = 0;
            }
            accumulator.add(element);
            ++count;
        }
        if (count > 0) {
            result.add(accumulator);
        }
        return result;
    }

    public static <E> boolean isEmpty(Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

