/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import java.io.IOException;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.coordination.ClusterStatePublisher;
import org.opensearch.cluster.coordination.PendingClusterStateStats;
import org.opensearch.cluster.coordination.PublishClusterStateStats;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterApplier;
import org.opensearch.cluster.service.ClusterStateStats;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.discovery.Discovery;
import org.opensearch.discovery.DiscoveryStats;
import org.opensearch.transport.TransportService;

public class LocalDiscovery
extends AbstractLifecycleComponent
implements Discovery {
    private static final DiscoveryStats EMPTY_STATS = new DiscoveryStats(new PendingClusterStateStats(0, 0, 0), new PublishClusterStateStats(0L, 0L, 0L), new ClusterStateStats());
    private final TransportService transportService;
    private final ClusterApplier clusterApplier;

    public LocalDiscovery(TransportService transportService, ClusterApplier clusterApplier) {
        this.transportService = transportService;
        this.clusterApplier = clusterApplier;
    }

    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, ActionListener<Void> publishListener, ClusterStatePublisher.AckListener ackListener) {
        throw new UnsupportedOperationException("Should not be called in clusterless mode");
    }

    @Override
    protected void doStart() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        ClusterState bootstrapClusterState = ClusterState.builder(ClusterState.EMPTY_STATE).nodes(DiscoveryNodes.builder().localNodeId(localNode.getId()).add(localNode).build()).build();
        this.clusterApplier.setInitialState(bootstrapClusterState);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public DiscoveryStats stats() {
        return EMPTY_STATS;
    }

    @Override
    public void startInitialJoin() {
    }

    @Override
    public void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
    }
}

