/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.transport.TransportResponse;

public class RestExecuteOnExtensionResponse
extends TransportResponse {
    private RestStatus status;
    private String contentType;
    private byte[] content;
    private Map<String, List<String>> headers;
    private List<String> consumedParams;
    private boolean contentConsumed;

    public RestExecuteOnExtensionResponse(RestStatus status, String contentType, byte[] content, Map<String, List<String>> headers, List<String> consumedParams, boolean contentConsumed) {
        this.setStatus(status);
        this.setContentType(contentType);
        this.setContent(content);
        this.setHeaders(headers);
        this.setConsumedParams(consumedParams);
        this.setContentConsumed(contentConsumed);
    }

    public RestExecuteOnExtensionResponse(StreamInput in) throws IOException {
        this.setStatus(in.readEnum(RestStatus.class));
        this.setContentType(in.readString());
        this.setContent(in.readByteArray());
        this.setHeaders(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        this.setConsumedParams(in.readStringList());
        this.setContentConsumed(in.readBoolean());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.status);
        out.writeString(this.contentType);
        out.writeByteArray(this.content);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeStringCollection(this.consumedParams);
        out.writeBoolean(this.contentConsumed);
    }

    public RestStatus getStatus() {
        return this.status;
    }

    public void setStatus(RestStatus status) {
        this.status = status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = Map.copyOf(headers);
    }

    public List<String> getConsumedParams() {
        return this.consumedParams;
    }

    public void setConsumedParams(List<String> consumedParams) {
        this.consumedParams = consumedParams;
    }

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    public void setContentConsumed(boolean contentConsumed) {
        this.contentConsumed = contentConsumed;
    }
}

