/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;

public class RemoteIndexMetadata
extends AbstractClusterMetadataWriteableBlobEntity<IndexMetadata> {
    public static final int INDEX_METADATA_CURRENT_CODEC_VERSION = 2;
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat<IndexMetadata>("index-metadata", "%s", IndexMetadata::fromXContent);
    public static final String INDEX = "index";
    private IndexMetadata indexMetadata;
    private RemoteStoreEnums.PathType pathType;
    private RemoteStoreEnums.PathHashAlgorithm pathHashAlgo;
    private String fixedPrefix;

    public RemoteIndexMetadata(IndexMetadata indexMetadata, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgo, String fixedPrefix) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.indexMetadata = indexMetadata;
        this.pathType = pathType;
        this.pathHashAlgo = pathHashAlgo;
        this.fixedPrefix = fixedPrefix;
    }

    public RemoteIndexMetadata(String blobName, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of(INDEX, this.indexMetadata.getIndexUUID()), "metadata");
    }

    @Override
    public String getType() {
        return INDEX;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.indexMetadata.getVersion()), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(2));
        return blobFileName;
    }

    @Override
    public BlobPath getPrefixedPath(BlobPath blobPath) {
        if (this.pathType == null) {
            return blobPath;
        }
        assert (this.pathHashAlgo != null);
        return this.pathType.path(((RemoteStorePathStrategy.PathInput.Builder)((RemoteStorePathStrategy.PathInput.Builder)((RemoteStorePathStrategy.PathInput.Builder)RemoteStorePathStrategy.PathInput.builder().fixedPrefix(this.fixedPrefix)).basePath(blobPath)).indexUUID(this.indexMetadata.getIndexUUID())).build(), this.pathHashAlgo);
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedIndexMetadata(this.indexMetadata.getIndex().getName(), this.indexMetadata.getIndexUUID(), this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return INDEX_METADATA_FORMAT.serialize(this.indexMetadata, this.generateBlobFileName(), this.getCompressor(), RemoteClusterStateUtils.FORMAT_PARAMS).streamInput();
    }

    @Override
    public IndexMetadata deserialize(InputStream inputStream) throws IOException {
        return INDEX_METADATA_FORMAT.deserialize(this.blobName, this.getNamedXContentRegistry(), Streams.readFully(inputStream));
    }
}

