/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.autoforcemerge;

import java.util.function.Consumer;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;

public class ForceMergeManagerSettings {
    private Integer segmentCount;
    private TimeValue forcemergeDelay;
    private TimeValue schedulerInterval;
    private TimeValue translogAge;
    private Double cpuThreshold;
    private Double diskThreshold;
    private Double jvmThreshold;
    private Integer concurrencyMultiplier;
    private Boolean autoForceMergeFeatureEnabled;
    private final Consumer<TimeValue> modifySchedulerInterval;
    public static final Setting<Boolean> AUTO_FORCE_MERGE_SETTING = Setting.boolSetting("cluster.auto_force_merge.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SEGMENT_COUNT_FOR_AUTO_FORCE_MERGE = Setting.intSetting("node.auto_force_merge.segment.count", 1, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MERGE_DELAY_BETWEEN_SHARDS_FOR_AUTO_FORCE_MERGE = Setting.timeSetting("node.auto_force_merge.merge_delay", TimeValue.timeValueSeconds(15L), TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(60L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> AUTO_FORCE_MERGE_SCHEDULER_INTERVAL = Setting.timeSetting("node.auto_force_merge.scheduler.interval", TimeValue.timeValueMinutes(30L), TimeValue.timeValueSeconds(1L), TimeValue.timeValueHours(24L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> TRANSLOG_AGE_AUTO_FORCE_MERGE = Setting.timeSetting("node.auto_force_merge.translog.age", TimeValue.timeValueMinutes(30L), TimeValue.timeValueSeconds(1L), TimeValue.timeValueHours(24L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> CPU_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE = Setting.doubleSetting("node.auto_force_merge.cpu.threshold", 75.0, 10.0, 100.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> DISK_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE = Setting.doubleSetting("node.auto_force_merge.disk.threshold", 85.0, 10.0, 100.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> JVM_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE = Setting.doubleSetting("node.auto_force_merge.jvm.threshold", 75.0, 10.0, 100.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CONCURRENCY_MULTIPLIER = Setting.intSetting("node.auto_force_merge.threads.concurrency_multiplier", 2, 2, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public ForceMergeManagerSettings(ClusterService clusterService, Consumer<TimeValue> modifySchedulerInterval) {
        Settings settings = clusterService.getSettings();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.modifySchedulerInterval = modifySchedulerInterval;
        this.autoForceMergeFeatureEnabled = AUTO_FORCE_MERGE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_FORCE_MERGE_SETTING, this::setAutoForceMergeFeatureEnabled);
        this.schedulerInterval = AUTO_FORCE_MERGE_SCHEDULER_INTERVAL.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_FORCE_MERGE_SCHEDULER_INTERVAL, this::setSchedulerInterval);
        this.forcemergeDelay = MERGE_DELAY_BETWEEN_SHARDS_FOR_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MERGE_DELAY_BETWEEN_SHARDS_FOR_AUTO_FORCE_MERGE, this::setForcemergeDelay);
        this.translogAge = TRANSLOG_AGE_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(TRANSLOG_AGE_AUTO_FORCE_MERGE, this::setTranslogAge);
        this.segmentCount = SEGMENT_COUNT_FOR_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SEGMENT_COUNT_FOR_AUTO_FORCE_MERGE, this::setSegmentCount);
        this.cpuThreshold = CPU_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CPU_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE, this::setCpuThreshold);
        this.diskThreshold = DISK_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(DISK_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE, this::setDiskThreshold);
        this.jvmThreshold = JVM_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(JVM_THRESHOLD_PERCENTAGE_FOR_AUTO_FORCE_MERGE, this::setJvmThreshold);
        this.concurrencyMultiplier = CONCURRENCY_MULTIPLIER.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CONCURRENCY_MULTIPLIER, this::setConcurrencyMultiplier);
    }

    public void setAutoForceMergeFeatureEnabled(Boolean autoForceMergeFeatureEnabled) {
        this.autoForceMergeFeatureEnabled = autoForceMergeFeatureEnabled;
    }

    public Boolean isAutoForceMergeFeatureEnabled() {
        return this.autoForceMergeFeatureEnabled;
    }

    public void setSegmentCount(Integer segmentCount) {
        this.segmentCount = segmentCount;
    }

    public Integer getSegmentCount() {
        return this.segmentCount;
    }

    public TimeValue getTranslogAge() {
        return this.translogAge;
    }

    public void setTranslogAge(TimeValue translogAge) {
        this.translogAge = translogAge;
    }

    public void setForcemergeDelay(TimeValue forcemergeDelay) {
        this.forcemergeDelay = forcemergeDelay;
    }

    public TimeValue getForcemergeDelay() {
        return this.forcemergeDelay;
    }

    public void setSchedulerInterval(TimeValue schedulerInterval) {
        this.schedulerInterval = schedulerInterval;
        this.modifySchedulerInterval.accept(schedulerInterval);
    }

    public TimeValue getSchedulerInterval() {
        return this.schedulerInterval;
    }

    public void setCpuThreshold(Double cpuThreshold) {
        this.cpuThreshold = cpuThreshold;
    }

    public Double getCpuThreshold() {
        return this.cpuThreshold;
    }

    public void setDiskThreshold(Double diskThreshold) {
        this.diskThreshold = diskThreshold;
    }

    public Double getDiskThreshold() {
        return this.diskThreshold;
    }

    public void setJvmThreshold(Double jvmThreshold) {
        this.jvmThreshold = jvmThreshold;
    }

    public Double getJvmThreshold() {
        return this.jvmThreshold;
    }

    public void setConcurrencyMultiplier(Integer concurrencyMultiplier) {
        this.concurrencyMultiplier = concurrencyMultiplier;
    }

    public Integer getConcurrencyMultiplier() {
        return this.concurrencyMultiplier;
    }
}

