/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.codec.fuzzy.FuzzySet;
import org.opensearch.index.codec.fuzzy.FuzzySetFactory;

public final class FuzzyFilterPostingsFormat
extends PostingsFormat {
    private static final Logger logger = LogManager.getLogger(FuzzyFilterPostingsFormat.class);
    public static final String FUZZY_FILTER_CODEC_NAME = "FuzzyFilterCodec99";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final String FUZZY_FILTER_FILE_EXTENSION = "fzd";
    private final PostingsFormat delegatePostingsFormat;
    private final FuzzySetFactory fuzzySetFactory;

    public FuzzyFilterPostingsFormat(PostingsFormat delegatePostingsFormat, FuzzySetFactory fuzzySetFactory) {
        super(FUZZY_FILTER_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.fuzzySetFactory = fuzzySetFactory;
    }

    public FuzzyFilterPostingsFormat() {
        this(null, null);
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        FieldsConsumer fieldsConsumer = this.delegatePostingsFormat.fieldsConsumer(state);
        return new FuzzyFilteredFieldsConsumer(fieldsConsumer, state);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FuzzyFilteredFieldsProducer(state);
    }

    @Override
    public String toString() {
        return "FuzzyFilterPostingsFormat(" + String.valueOf(this.delegatePostingsFormat) + ")";
    }

    class FuzzyFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, FuzzySet> fuzzySets = new HashMap<FieldInfo, FuzzySet>();
        private SegmentWriteState state;
        private List<Closeable> closeables = new ArrayList<Closeable>();
        private boolean closed;

        public FuzzyFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        @Override
        public void write(Fields fields, NormsProducer norms) throws IOException {
            this.delegateFieldsConsumer.write(fields, norms);
            for (String field : fields) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
                FuzzySet fuzzySet = FuzzyFilterPostingsFormat.this.fuzzySetFactory.createFuzzySet(this.state.segmentInfo.maxDoc(), fieldInfo.name, () -> this.iterator(terms));
                if (fuzzySet == null) break;
                assert (!this.fuzzySets.containsKey(fieldInfo));
                this.closeables.add(fuzzySet);
                this.fuzzySets.put(fieldInfo, fuzzySet);
            }
        }

        private Iterator<BytesRef> iterator(Terms terms) throws IOException {
            final TermsEnum termIterator = terms.iterator();
            return new Iterator<BytesRef>(this){
                private BytesRef currentTerm;
                private PostingsEnum postingsEnum;

                @Override
                public boolean hasNext() {
                    try {
                        do {
                            this.currentTerm = termIterator.next();
                            if (this.currentTerm == null) {
                                return false;
                            }
                            this.postingsEnum = termIterator.postings(this.postingsEnum, 0);
                        } while (this.postingsEnum.nextDoc() == Integer.MAX_VALUE);
                        return true;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Cannot read terms: " + String.valueOf(termIterator.attributes()));
                    }
                }

                @Override
                public BytesRef next() {
                    return this.currentTerm;
                }
            };
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, FuzzySet>> nonSaturatedSets = new ArrayList<Map.Entry<FieldInfo, FuzzySet>>();
            for (Map.Entry<FieldInfo, FuzzySet> entry : this.fuzzySets.entrySet()) {
                FuzzySet fuzzySet = entry.getValue();
                if (fuzzySet.isSaturated()) continue;
                nonSaturatedSets.add(entry);
            }
            String fuzzyFilterFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, FuzzyFilterPostingsFormat.FUZZY_FILTER_FILE_EXTENSION);
            try (IndexOutput fuzzyFilterFileOutput = this.state.directory.createOutput(fuzzyFilterFileName, this.state.context);){
                logger.trace("Writing fuzzy filter postings with version: {} for segment: {}", (Object)0, (Object)this.state.segmentInfo.toString());
                CodecUtil.writeIndexHeader(fuzzyFilterFileOutput, FuzzyFilterPostingsFormat.FUZZY_FILTER_CODEC_NAME, 0, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                fuzzyFilterFileOutput.writeString(FuzzyFilterPostingsFormat.this.delegatePostingsFormat.getName());
                fuzzyFilterFileOutput.writeInt(nonSaturatedSets.size());
                for (Map.Entry entry : nonSaturatedSets) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    FuzzySet fuzzySet = (FuzzySet)entry.getValue();
                    this.saveAppropriatelySizedFuzzySet(fuzzyFilterFileOutput, fuzzySet, fieldInfo);
                }
                CodecUtil.writeFooter(fuzzyFilterFileOutput);
            }
            this.fuzzySets.clear();
            IOUtils.closeWhileHandlingException(this.closeables);
        }

        private void saveAppropriatelySizedFuzzySet(IndexOutput fileOutput, FuzzySet fuzzySet, FieldInfo fieldInfo) throws IOException {
            fileOutput.writeInt(fieldInfo.number);
            fileOutput.writeString(fuzzySet.setType().getSetName());
            fuzzySet.writeTo(fileOutput);
        }
    }

    static class FuzzyFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, FuzzySet> fuzzySetsByFieldName = new HashMap();
        private List<Closeable> closeables = new ArrayList<Closeable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FuzzyFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String fuzzyFilterFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, FuzzyFilterPostingsFormat.FUZZY_FILTER_FILE_EXTENSION);
            IndexInput filterIn = null;
            boolean success = false;
            try {
                filterIn = state.directory.openInput(fuzzyFilterFileName, state.context);
                CodecUtil.checkIndexHeader(filterIn, FuzzyFilterPostingsFormat.FUZZY_FILTER_CODEC_NAME, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName(filterIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numFilters = filterIn.readInt();
                for (int i = 0; i < numFilters; ++i) {
                    int fieldNum = filterIn.readInt();
                    FuzzySet set = FuzzySetFactory.deserializeFuzzySet(filterIn);
                    this.closeables.add(set);
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                    this.fuzzySetsByFieldName.put(fieldInfo.name, set);
                }
                CodecUtil.retrieveChecksum(filterIn);
                CodecUtil.checksumEntireFile(filterIn);
                success = true;
                this.closeables.add(filterIn);
                if (success) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(filterIn, this.delegateFieldsProducer);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(filterIn, this.delegateFieldsProducer);
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeWhileHandlingException(this.closeables);
            this.delegateFieldsProducer.close();
        }

        @Override
        public Terms terms(String field) throws IOException {
            FuzzySet filter = this.fuzzySetsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new FuzzyFilteredTerms(result, filter);
        }

        @Override
        public int size() {
            return this.delegateFieldsProducer.size();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(fields=" + this.fuzzySetsByFieldName.size() + ",delegate=" + String.valueOf(this.delegateFieldsProducer) + ")";
        }

        static class FuzzyFilteredTerms
        extends Terms {
            private Terms delegateTerms;
            private FuzzySet filter;

            public FuzzyFilteredTerms(Terms terms, FuzzySet filter) {
                this.delegateTerms = terms;
                this.filter = filter;
            }

            @Override
            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.delegateTerms.intersect(compiled, startTerm);
            }

            @Override
            public TermsEnum iterator() throws IOException {
                return new FilterAppliedTermsEnum(this.delegateTerms, this.filter);
            }

            @Override
            public long size() throws IOException {
                return this.delegateTerms.size();
            }

            @Override
            public long getSumTotalTermFreq() throws IOException {
                return this.delegateTerms.getSumTotalTermFreq();
            }

            @Override
            public long getSumDocFreq() throws IOException {
                return this.delegateTerms.getSumDocFreq();
            }

            @Override
            public int getDocCount() throws IOException {
                return this.delegateTerms.getDocCount();
            }

            @Override
            public boolean hasFreqs() {
                return this.delegateTerms.hasFreqs();
            }

            @Override
            public boolean hasOffsets() {
                return this.delegateTerms.hasOffsets();
            }

            @Override
            public boolean hasPositions() {
                return this.delegateTerms.hasPositions();
            }

            @Override
            public boolean hasPayloads() {
                return this.delegateTerms.hasPayloads();
            }

            @Override
            public BytesRef getMin() throws IOException {
                return this.delegateTerms.getMin();
            }

            @Override
            public BytesRef getMax() throws IOException {
                return this.delegateTerms.getMax();
            }
        }

        static final class FilterAppliedTermsEnum
        extends BaseTermsEnum {
            private Terms delegateTerms;
            private TermsEnum delegateTermsEnum;
            private final FuzzySet filter;

            public FilterAppliedTermsEnum(Terms delegateTerms, FuzzySet filter) throws IOException {
                this.delegateTerms = delegateTerms;
                this.filter = filter;
            }

            void reset(Terms delegateTerms) throws IOException {
                this.delegateTerms = delegateTerms;
                this.delegateTermsEnum = null;
            }

            private TermsEnum delegate() throws IOException {
                if (this.delegateTermsEnum == null) {
                    this.delegateTermsEnum = this.delegateTerms.iterator();
                }
                return this.delegateTermsEnum;
            }

            @Override
            public BytesRef next() throws IOException {
                return this.delegate().next();
            }

            @Override
            public boolean seekExact(BytesRef text) throws IOException {
                if (this.filter.contains(text) == FuzzySet.Result.NO) {
                    return false;
                }
                return this.delegate().seekExact(text);
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                return this.delegate().seekCeil(text);
            }

            @Override
            public void seekExact(long ord) throws IOException {
                this.delegate().seekExact(ord);
            }

            @Override
            public BytesRef term() throws IOException {
                return this.delegate().term();
            }

            @Override
            public long ord() throws IOException {
                return this.delegate().ord();
            }

            @Override
            public int docFreq() throws IOException {
                return this.delegate().docFreq();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return this.delegate().totalTermFreq();
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                return this.delegate().postings(reuse, flags);
            }

            @Override
            public ImpactsEnum impacts(int flags) throws IOException {
                return this.delegate().impacts(flags);
            }

            public String toString() {
                return this.getClass().getSimpleName() + "(filter=" + this.filter.toString() + ")";
            }
        }
    }
}

