/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.fuzzy;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongArray;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.codec.fuzzy.IndexInputImmutableLongArray;

class LongArrayBackedBitSet
implements Accountable,
Closeable {
    private long underlyingArrayLength = 0L;
    private LongArray longArray;

    LongArrayBackedBitSet(long capacity) {
        this.underlyingArrayLength = (capacity >> 6) + 1L;
        this.longArray = BigArrays.NON_RECYCLING_INSTANCE.withCircuitBreaking().newLongArray(this.underlyingArrayLength);
    }

    LongArrayBackedBitSet(IndexInput in) throws IOException {
        this.underlyingArrayLength = in.readLong();
        long streamLength = this.underlyingArrayLength << 3;
        this.longArray = new IndexInputImmutableLongArray(this.underlyingArrayLength, in.randomAccessSlice(in.getFilePointer(), streamLength));
        in.skipBytes(streamLength);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeLong(this.underlyingArrayLength);
        int idx = 0;
        while ((long)idx < this.underlyingArrayLength) {
            out.writeLong(this.longArray.get(idx));
            ++idx;
        }
    }

    public long cardinality() {
        long tot = 0L;
        int i = 0;
        while ((long)i < this.underlyingArrayLength) {
            tot += (long)Long.bitCount(this.longArray.get(i));
            ++i;
        }
        return tot;
    }

    public boolean get(long index) {
        long bitmask;
        long i = index >> 6;
        long val = this.longArray.get(i);
        return (val & (bitmask = 1L << (int)index)) != 0L;
    }

    public void set(long index) {
        long wordNum = index >> 6;
        long bitmask = 1L << (int)index;
        long val = this.longArray.get(wordNum);
        this.longArray.set(wordNum, val | bitmask);
    }

    @Override
    public long ramBytesUsed() {
        return 128L + this.longArray.ramBytesUsed();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.longArray);
    }
}

