/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValuesType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.DimensionDataType;

public class ReadDimension
implements Dimension {
    public static final String READ = "read";
    private final String field;
    private final DocValuesType docValuesType;
    private final DimensionDataType dimensionDataType;

    public ReadDimension(String field) {
        this.field = field;
        this.docValuesType = DocValuesType.SORTED_NUMERIC;
        this.dimensionDataType = DimensionDataType.LONG;
    }

    public ReadDimension(String field, DocValuesType docValuesType) {
        this.field = field;
        this.docValuesType = docValuesType;
        this.dimensionDataType = DimensionDataType.LONG;
    }

    public ReadDimension(String field, DocValuesType docValuesType, DimensionDataType dimensionDataType) {
        this.field = field;
        this.docValuesType = docValuesType;
        this.dimensionDataType = dimensionDataType;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public int getNumSubDimensions() {
        return 1;
    }

    @Override
    public void setDimensionValues(Long val, Consumer<Long> dimSetter) {
        dimSetter.accept(val);
    }

    @Override
    public List<String> getSubDimensionNames() {
        return List.of(this.field);
    }

    @Override
    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.field);
        builder.field("type", READ);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadDimension dimension = (ReadDimension)o;
        return Objects.equals(this.field, dimension.getField());
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }

    @Override
    public DimensionDataType getDimensionDataType() {
        return this.dimensionDataType;
    }
}

