/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Numbers;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.opensearch.index.fielddata.AbstractSortedNumericDocValues;
import org.opensearch.index.fielddata.DocValueBits;
import org.opensearch.index.fielddata.GeoPointValues;
import org.opensearch.index.fielddata.GeoShapeValue;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SingletonMultiGeoPointValues;
import org.opensearch.index.fielddata.SingletonSortedBinaryDocValues;
import org.opensearch.index.fielddata.SingletonSortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortableLongBitsNumericDocValues;
import org.opensearch.index.fielddata.SortableLongBitsSortedNumericDocValues;
import org.opensearch.index.fielddata.SortableLongBitsToNumericDoubleValues;
import org.opensearch.index.fielddata.SortableLongBitsToSortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortingBinaryDocValues;
import org.opensearch.index.fielddata.UnsignedLongToNumericDoubleValues;
import org.opensearch.index.fielddata.UnsignedLongToSortedNumericDoubleValues;

public final class FieldData
extends Enum<FieldData> {
    private static final /* synthetic */ FieldData[] $VALUES;

    public static FieldData[] values() {
        return (FieldData[])$VALUES.clone();
    }

    public static FieldData valueOf(String name) {
        return Enum.valueOf(FieldData.class, name);
    }

    public static SortedBinaryDocValues emptySortedBinary() {
        return FieldData.singleton(DocValues.emptyBinary());
    }

    public static NumericDoubleValues emptyNumericDouble() {
        return new NumericDoubleValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }

            @Override
            public double doubleValue() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                return Integer.MAX_VALUE;
            }
        };
    }

    public static SortedNumericDoubleValues emptySortedNumericDoubles() {
        return FieldData.singleton(FieldData.emptyNumericDouble());
    }

    public static GeoPointValues emptyGeoPoint() {
        return new GeoPointValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }

            @Override
            public GeoPoint geoPointValue() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static MultiGeoPointValues emptyMultiGeoPoints() {
        return FieldData.singleton(FieldData.emptyGeoPoint());
    }

    public static GeoShapeValue emptyGeoShape() {
        return new GeoShapeValue.EmptyGeoShapeValue();
    }

    public static DocValueBits docsWithValue(final SortedBinaryDocValues values) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedSetDocValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final MultiGeoPointValues pointValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return pointValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final GeoShapeValue shapeValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return shapeValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericDoubleValues doubleValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doubleValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericDocValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static SortedNumericDocValues toSortableLongBits(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            NumericDocValues longBits = singleton instanceof SortableLongBitsToNumericDoubleValues ? ((SortableLongBitsToNumericDoubleValues)singleton).getLongValues() : new SortableLongBitsNumericDocValues(singleton);
            return DocValues.singleton(longBits);
        }
        if (values instanceof SortableLongBitsToSortedNumericDoubleValues) {
            return ((SortableLongBitsToSortedNumericDoubleValues)values).getLongValues();
        }
        return new SortableLongBitsSortedNumericDocValues(values);
    }

    public static SortedNumericDoubleValues sortableLongBitsToDoubles(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            NumericDoubleValues doubles = singleton instanceof SortableLongBitsNumericDocValues ? ((SortableLongBitsNumericDocValues)singleton).getDoubleValues() : new SortableLongBitsToNumericDoubleValues(singleton);
            return FieldData.singleton(doubles);
        }
        if (values instanceof SortableLongBitsSortedNumericDocValues) {
            return ((SortableLongBitsSortedNumericDocValues)values).getDoubleValues();
        }
        return new SortableLongBitsToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues unsignedLongToDoubles(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            NumericDoubleValues doubles = singleton instanceof SortableLongBitsNumericDocValues ? ((SortableLongBitsNumericDocValues)singleton).getDoubleValues() : new UnsignedLongToNumericDoubleValues(singleton);
            return FieldData.singleton(doubles);
        }
        if (values instanceof SortableLongBitsSortedNumericDocValues) {
            return ((SortableLongBitsSortedNumericDocValues)values).getDoubleValues();
        }
        return new UnsignedLongToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues castToDouble(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(new DoubleCastedValues(singleton));
        }
        return new SortedDoubleCastedValues(values);
    }

    public static SortedNumericDocValues castToLong(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return DocValues.singleton(new LongCastedValues(singleton));
        }
        return new SortedLongCastedValues(values);
    }

    public static SortedNumericDoubleValues singleton(NumericDoubleValues values) {
        return new SingletonSortedNumericDoubleValues(values);
    }

    public static NumericDoubleValues unwrapSingleton(SortedNumericDoubleValues values) {
        if (values instanceof SingletonSortedNumericDoubleValues) {
            return ((SingletonSortedNumericDoubleValues)values).getNumericDoubleValues();
        }
        return null;
    }

    public static MultiGeoPointValues singleton(GeoPointValues values) {
        return new SingletonMultiGeoPointValues(values);
    }

    public static GeoPointValues unwrapSingleton(MultiGeoPointValues values) {
        if (values instanceof SingletonMultiGeoPointValues) {
            return ((SingletonMultiGeoPointValues)values).getGeoPointValues();
        }
        return null;
    }

    public static SortedBinaryDocValues singleton(BinaryDocValues values) {
        return new SingletonSortedBinaryDocValues(values);
    }

    public static BinaryDocValues unwrapSingleton(SortedBinaryDocValues values) {
        if (values instanceof SingletonSortedBinaryDocValues) {
            return ((SingletonSortedBinaryDocValues)values).getBinaryDocValues();
        }
        return null;
    }

    public static boolean isMultiValued(SortedSetDocValues values) {
        return DocValues.unwrapSingleton(values) == null;
    }

    public static SortedBinaryDocValues toString(final SortedNumericDocValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toUnsignedString(final SortedNumericDocValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toUnsignedString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedNumericDoubleValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Double.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedSetDocValues values) {
        return new SortedBinaryDocValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (!values.advanceExact(doc)) {
                    return false;
                }
                boolean advanced = values.advanceExact(doc);
                assert (advanced);
                return true;
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public BytesRef nextValue() throws IOException {
                return values.lookupOrd(values.nextOrd());
            }
        };
    }

    public static SortedBinaryDocValues toString(final MultiGeoPointValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(values.nextValue().toString());
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final GeoShapeValue geoShapeValue) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return geoShapeValue.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                list.add(geoShapeValue.nextValue().toString());
            }
        });
    }

    private static SortedBinaryDocValues toString(final ToStringValues toStringValues) {
        return new SortingBinaryDocValues(){
            final List<CharSequence> list = new ArrayList<CharSequence>();

            @Override
            public boolean advanceExact(int docID) throws IOException {
                if (!toStringValues.advanceExact(docID)) {
                    return false;
                }
                this.list.clear();
                toStringValues.get(this.list);
                this.count = this.list.size();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    CharSequence s = this.list.get(i);
                    this.values[i].copyChars(s);
                }
                this.sort();
                return true;
            }
        };
    }

    public static NumericDocValues replaceMissing(final NumericDocValues values, final long missing) {
        return new AbstractNumericDocValues(){
            private long value;

            @Override
            public int docID() {
                return values.docID();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? values.longValue() : missing;
                return true;
            }

            @Override
            public long longValue() throws IOException {
                return this.value;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    public static NumericDocValues replaceMissing(final NumericDocValues values, final BigInteger missing) {
        return new AbstractNumericDocValues(){
            private BigInteger value;

            @Override
            public int docID() {
                return values.docID();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? Numbers.toUnsignedBigInteger(values.longValue()) : missing;
                return true;
            }

            @Override
            public long longValue() throws IOException {
                return this.value.longValue();
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    public static NumericDoubleValues replaceMissing(final NumericDoubleValues values, final double missing) {
        return new NumericDoubleValues(){
            private double value;

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? values.doubleValue() : missing;
                return true;
            }

            @Override
            public double doubleValue() throws IOException {
                return this.value;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    private static /* synthetic */ FieldData[] $values() {
        return new FieldData[0];
    }

    static {
        $VALUES = FieldData.$values();
    }

    private static class DoubleCastedValues
    extends NumericDoubleValues {
        private final NumericDocValues values;

        DoubleCastedValues(NumericDocValues values) {
            this.values = values;
        }

        @Override
        public double doubleValue() throws IOException {
            return this.values.longValue();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }

        @Override
        public int advance(int target) throws IOException {
            return this.values.advance(target);
        }
    }

    private static class SortedDoubleCastedValues
    extends SortedNumericDoubleValues {
        private final SortedNumericDocValues values;

        SortedDoubleCastedValues(SortedNumericDocValues in) {
            this.values = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return this.values.nextValue();
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.values.advance(target);
        }
    }

    private static class LongCastedValues
    extends AbstractNumericDocValues {
        private final NumericDoubleValues values;
        private int docID = -1;

        LongCastedValues(NumericDoubleValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.values.advanceExact(target);
        }

        @Override
        public long longValue() throws IOException {
            return (long)this.values.doubleValue();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) throws IOException {
            this.docID = this.values.advance(target);
            return this.docID;
        }
    }

    private static class SortedLongCastedValues
    extends AbstractSortedNumericDocValues {
        private final SortedNumericDoubleValues values;

        SortedLongCastedValues(SortedNumericDoubleValues in) {
            this.values = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }

        @Override
        public long nextValue() throws IOException {
            return (long)this.values.nextValue();
        }
    }

    private static interface ToStringValues {
        public boolean advanceExact(int var1) throws IOException;

        public void get(List<CharSequence> var1) throws IOException;
    }
}

