/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.opensearch.common.Numbers;
import org.opensearch.index.fielddata.NumericDoubleValues;

final class UnsignedLongToNumericDoubleValues
extends NumericDoubleValues {
    private final NumericDocValues values;

    UnsignedLongToNumericDoubleValues(NumericDocValues values) {
        this.values = values;
    }

    @Override
    public double doubleValue() throws IOException {
        return Numbers.unsignedLongToDouble(this.values.longValue());
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        return this.values.advanceExact(doc);
    }

    public NumericDocValues getLongValues() {
        return this.values;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }
}

