/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.TriFunction;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;

final class BinaryRangeUtil {
    private BinaryRangeUtil() {
    }

    static BytesRef encodeIPRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        BytesStreamOutput out = new BytesStreamOutput(5 + 32 * ranges.size());
        out.writeVInt(ranges.size());
        for (RangeFieldMapper.Range range : ranges) {
            InetAddress fromValue = (InetAddress)range.from;
            byte[] encodedFromValue = InetAddressPoint.encode(fromValue);
            out.writeBytes(encodedFromValue, 0, encodedFromValue.length);
            InetAddress toValue = (InetAddress)range.to;
            byte[] encodedToValue = InetAddressPoint.encode(toValue);
            out.writeBytes(encodedToValue, 0, encodedToValue.length);
        }
        return out.bytes().toBytesRef();
    }

    static List<RangeFieldMapper.Range> decodeIPRanges(BytesRef encodedRanges) throws IOException {
        return BinaryRangeUtil.decodeRanges(encodedRanges, RangeType.IP, BinaryRangeUtil::decodeIP);
    }

    private static InetAddress decodeIP(byte[] bytes, int offset, int length) {
        byte[] slice = Arrays.copyOfRange(bytes, offset, offset + length);
        return InetAddressPoint.decode(slice);
    }

    static BytesRef encodeLongRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingLong(range -> ((Number)range.from).longValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingLong(range -> ((Number)range.to).longValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        BytesStreamOutput out = new BytesStreamOutput(5 + 18 * sortedRanges.size());
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeLong(((Number)range2.from).longValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeLong(((Number)range2.to).longValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return out.bytes().toBytesRef();
    }

    static List<RangeFieldMapper.Range> decodeLongRanges(BytesRef encodedRanges) throws IOException {
        return BinaryRangeUtil.decodeRanges(encodedRanges, RangeType.LONG, BinaryRangeUtil::decodeLong);
    }

    static BytesRef encodeDoubleRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingDouble(range -> ((Number)range.from).doubleValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingDouble(range -> ((Number)range.to).doubleValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        BytesStreamOutput out = new BytesStreamOutput(5 + 16 * sortedRanges.size());
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeDouble(((Number)range2.from).doubleValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeDouble(((Number)range2.to).doubleValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return out.bytes().toBytesRef();
    }

    static List<RangeFieldMapper.Range> decodeDoubleRanges(BytesRef encodedRanges) throws IOException {
        return BinaryRangeUtil.decodeRanges(encodedRanges, RangeType.DOUBLE, BinaryRangeUtil::decodeDouble);
    }

    static List<RangeFieldMapper.Range> decodeFloatRanges(BytesRef encodedRanges) throws IOException {
        return BinaryRangeUtil.decodeRanges(encodedRanges, RangeType.FLOAT, BinaryRangeUtil::decodeFloat);
    }

    static List<RangeFieldMapper.Range> decodeRanges(BytesRef encodedRanges, RangeType rangeType, TriFunction<byte[], Integer, Integer, Object> decodeBytes) throws IOException {
        RangeType.LengthType lengthType = rangeType.lengthType;
        BytesStreamInput in = new BytesStreamInput(encodedRanges.bytes, encodedRanges.offset, encodedRanges.length);
        int numRanges = in.readVInt();
        ArrayList<RangeFieldMapper.Range> ranges = new ArrayList<RangeFieldMapper.Range>(numRanges);
        byte[] bytes = encodedRanges.bytes;
        int offset = in.getPosition();
        for (int i = 0; i < numRanges; ++i) {
            int length = lengthType.readLength(bytes, offset);
            Object from = decodeBytes.apply(bytes, offset, length);
            offset += length;
            length = lengthType.readLength(bytes, offset);
            Object to = decodeBytes.apply(bytes, offset, length);
            offset += length;
            RangeFieldMapper.Range decodedRange = new RangeFieldMapper.Range(rangeType, from, to, true, true);
            ranges.add(decodedRange);
        }
        return ranges;
    }

    static BytesRef encodeFloatRanges(Set<RangeFieldMapper.Range> ranges) throws IOException {
        ArrayList<RangeFieldMapper.Range> sortedRanges = new ArrayList<RangeFieldMapper.Range>(ranges);
        Comparator<RangeFieldMapper.Range> fromComparator = Comparator.comparingDouble(range -> ((Number)range.from).floatValue());
        Comparator<RangeFieldMapper.Range> toComparator = Comparator.comparingDouble(range -> ((Number)range.to).floatValue());
        sortedRanges.sort(fromComparator.thenComparing(toComparator));
        BytesStreamOutput out = new BytesStreamOutput(5 + 8 * sortedRanges.size());
        out.writeVInt(sortedRanges.size());
        for (RangeFieldMapper.Range range2 : sortedRanges) {
            byte[] encodedFrom = BinaryRangeUtil.encodeFloat(((Number)range2.from).floatValue());
            out.writeBytes(encodedFrom, encodedFrom.length);
            byte[] encodedTo = BinaryRangeUtil.encodeFloat(((Number)range2.to).floatValue());
            out.writeBytes(encodedTo, encodedTo.length);
        }
        return out.bytes().toBytesRef();
    }

    static byte[] encodeDouble(double number) {
        byte[] encoded = new byte[8];
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(number), encoded, 0);
        return encoded;
    }

    static double decodeDouble(byte[] bytes, int offset, int length) {
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(bytes, offset));
    }

    static byte[] encodeFloat(float number) {
        byte[] encoded = new byte[4];
        NumericUtils.intToSortableBytes(NumericUtils.floatToSortableInt(number), encoded, 0);
        return encoded;
    }

    static float decodeFloat(byte[] bytes, int offset, int length) {
        return NumericUtils.sortableIntToFloat(NumericUtils.sortableBytesToInt(bytes, offset));
    }

    static byte[] encodeLong(long number) {
        int sign = 1;
        if (number < 0L) {
            number = -1L - number;
            sign = 0;
        }
        return BinaryRangeUtil.encode(number, sign);
    }

    static long decodeLong(byte[] bytes, int offset, int length) {
        boolean isNegative = (bytes[offset] & 0x80) == 0;
        long decoded = isNegative ? (long)(0xFFFFFFF8 | bytes[offset]) : (long)(bytes[offset] & 7);
        for (int i = 1; i < length; ++i) {
            decoded <<= 8;
            decoded += (long)Byte.toUnsignedInt(bytes[offset + i]);
        }
        return decoded;
    }

    private static byte[] encode(long l, int sign) {
        int numBits;
        assert (l >= 0L);
        int numAdditionalBytes = (numBits + 7 - 3) / 8;
        byte[] encoded = new byte[1 + numAdditionalBytes];
        int i = encoded.length;
        for (numBits = 64 - Long.numberOfLeadingZeros(l); numBits > 0; numBits -= 8) {
            int index = --i;
            assert (index > 0 || numBits <= 3);
            encoded[index] = (byte)l;
            l >>>= 8;
        }
        assert (Byte.toUnsignedInt(encoded[0]) <= 7);
        assert (encoded.length == 1 || encoded[0] != 0 || Byte.toUnsignedInt(encoded[1]) > 7);
        if (sign == 0) {
            for (int j = 0; j < encoded.length; ++j) {
                encoded[j] = (byte)(~Byte.toUnsignedInt(encoded[j]));
            }
            encoded[0] = (byte)(encoded[0] & 7);
        }
        encoded[0] = (byte)(encoded[0] | sign << 7);
        encoded[0] = sign > 0 ? (byte)(encoded[0] | numAdditionalBytes << 3) : (byte)(encoded[0] | 15 - numAdditionalBytes << 3);
        return encoded;
    }
}

