/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.IndexSortConfig;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DocumentParser;
import org.opensearch.index.mapper.FieldTypeLookup;
import org.opensearch.index.mapper.IdFieldMapper;
import org.opensearch.index.mapper.IndexFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.MappingLookup;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.RootObjectMapper;
import org.opensearch.index.mapper.RoutingFieldMapper;
import org.opensearch.index.mapper.SourceFieldMapper;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.search.internal.SearchContext;

@PublicApi(since="1.0.0")
public class DocumentMapper
implements ToXContentFragment {
    private final MapperService mapperService;
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final MappingLookup fieldMappers;
    private final MetadataFieldMapper[] deleteTombstoneMetadataFieldMappers;
    private final MetadataFieldMapper[] noopTombstoneMetadataFieldMappers;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        IndexSettings indexSettings = mapperService.getIndexSettings();
        this.mapping = mapping;
        this.documentParser = new DocumentParser(indexSettings, mapperService.documentMapperParser(), this);
        IndexAnalyzers indexAnalyzers = mapperService.getIndexAnalyzers();
        this.fieldMappers = MappingLookup.fromMapping(this.mapping, indexAnalyzers.getDefaultIndexAnalyzer());
        try {
            this.mappingSource = new CompressedXContent(this, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new OpenSearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
        List<String> deleteTombstoneMetadataFields = Arrays.asList("_version", "_id", "_seq_no", "_primary_term", "_tombstone");
        this.deleteTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> deleteTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
        List<String> noopTombstoneMetadataFields = Arrays.asList("_version", "_seq_no", "_primary_term", "_tombstone");
        this.noopTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> noopTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public Map<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public boolean hasNestedObjects() {
        return this.mappers().hasNested();
    }

    public MappingLookup mappers() {
        return this.fieldMappers;
    }

    FieldTypeLookup fieldTypes() {
        return this.mappers().fieldTypes();
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.mappers().objectMappers();
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mapping.metadataMappers);
    }

    public ParsedDocument createDeleteTombstoneDoc(String index, String id) throws MapperParsingException {
        SourceToParse emptySource = new SourceToParse(index, id, new BytesArray("{}"), MediaTypeRegistry.JSON);
        return this.documentParser.parseDocument(emptySource, this.deleteTombstoneMetadataFieldMappers).toTombstone();
    }

    public ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        String id = "";
        SourceToParse sourceToParse = new SourceToParse(index, "", new BytesArray("{}"), MediaTypeRegistry.JSON);
        ParsedDocument parsedDoc = this.documentParser.parseDocument(sourceToParse, this.noopTombstoneMetadataFieldMappers).toTombstone();
        BytesRef byteRef = new BytesRef(reason);
        parsedDoc.rootDoc().add(new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        if (sc instanceof NestedQueryBuilder.NestedInnerHitSubContext) {
            ObjectMapper objectMapper = ((NestedQueryBuilder.NestedInnerHitSubContext)sc).getChildObjectMapper();
            assert (this.objectMappers().containsKey(objectMapper.fullPath()));
            assert (this.containSubDocIdWithObjectMapper(nestedDocId, objectMapper, sc, context));
            return objectMapper;
        }
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            if (!this.containSubDocIdWithObjectMapper(nestedDocId, objectMapper, sc, context)) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    private boolean containSubDocIdWithObjectMapper(int nestedDocId, ObjectMapper objectMapper, SearchContext sc, LeafReaderContext context) throws IOException {
        if (!objectMapper.nested().isNested()) {
            return false;
        }
        Query filter = objectMapper.nestedTypeFilter();
        if (filter == null) {
            return false;
        }
        BitSet nestedDocIds = sc.bitsetFilterCache().getBitSetProducer(filter).getBitSet(context);
        return nestedDocIds != null && nestedDocIds.get(nestedDocId);
    }

    public DocumentMapper merge(Mapping mapping, MapperService.MergeReason reason) {
        Mapping merged = this.mapping.merge(mapping, reason);
        return new DocumentMapper(this.mapperService, merged);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping.validate(this.fieldMappers);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.hasNestedObjects()) {
            if (settings.getIndexVersionCreated().before(Version.V_3_2_0)) {
                throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
            }
            List<String> sortFields = settings.getValue(IndexSortConfig.INDEX_SORT_FIELD_SETTING);
            for (String sortField : sortFields) {
                Mapper mapper = this.fieldMappers.getMapper(sortField);
                if (mapper == null || !mapper.name().contains(".")) continue;
                String parentPath = mapper.name().substring(0, mapper.name().lastIndexOf(46));
                ObjectMapper nestedParent = this.objectMappers().get(parentPath);
                if (nestedParent == null || !nestedParent.nested().isNested()) continue;
                throw new IllegalArgumentException("index sorting on nested fields is not supported: found nested sort field [" + sortField + "] in [" + settings.getIndex().getName() + "]");
            }
        }
        if (checkLimits) {
            this.fieldMappers.checkLimits(settings);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public String toString() {
        return "DocumentMapper{mapperService=" + String.valueOf(this.mapperService) + ", type='" + this.type + "', typeText=" + String.valueOf(this.typeText) + ", mappingSource=" + String.valueOf(this.mappingSource) + ", mapping=" + String.valueOf(this.mapping) + ", documentParser=" + String.valueOf(this.documentParser) + ", fieldMappers=" + String.valueOf(this.fieldMappers) + ", objectMappers=" + String.valueOf(this.objectMappers()) + ", hasNestedObjects=" + this.hasNestedObjects() + ", deleteTombstoneMetadataFieldMappers=" + Arrays.toString(this.deleteTombstoneMetadataFieldMappers) + ", noopTombstoneMetadataFieldMappers=" + Arrays.toString(this.noopTombstoneMetadataFieldMappers) + "}";
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private final RootObjectMapper rootObjectMapper;
        private Map<String, Object> meta;
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.getIndexSettings().getSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = builder.build(this.builderContext);
            DocumentMapper existingMapper = mapperService.documentMapper();
            Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperService.mapperRegistry.getMetadataMapperParsers();
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : metadataMapperParsers.entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(mapperService.fieldType(name), mapperService.documentMapperParser().parserContext());
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder mapper) {
            MetadataFieldMapper metadataMapper = mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(mapperService.getIndexSettings().getIndexVersionCreated(), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[0]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

