/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReaderUtil;
import org.opensearch.common.Randomness;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.search.lookup.SourceLookup;

public class FieldTypeInference {
    private final IndexReader indexReader;
    private final String indexName;
    private final MapperService mapperService;
    private int sampleSize;
    private static final int DEFAULT_SAMPLE_SIZE = 150;
    private static final int MAX_SAMPLE_SIZE_ALLOWED = 1000;

    public FieldTypeInference(String indexName, MapperService mapperService, IndexReader indexReader) {
        this.indexName = indexName;
        this.mapperService = mapperService;
        this.indexReader = indexReader;
        this.sampleSize = 150;
    }

    public void setSampleSize(int sampleSize) {
        if (sampleSize > 1000) {
            throw new IllegalArgumentException("sample_size should be less than 1000");
        }
        this.sampleSize = sampleSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public Mapper infer(ValueFetcher valueFetcher) throws IOException {
        RandomSourceValuesGenerator valuesGenerator = new RandomSourceValuesGenerator(this.sampleSize, this.indexReader, valueFetcher);
        Mapper inferredMapper = null;
        while (inferredMapper == null && valuesGenerator.hasNext()) {
            Object values = valuesGenerator.next();
            if (values == null || values.isEmpty()) continue;
            inferredMapper = this.inferTypeFromObject(values.get(0));
        }
        return inferredMapper;
    }

    private Mapper inferTypeFromObject(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        DocumentMapper mapper = this.mapperService.documentMapper();
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("field", o).endObject();
        BytesReference bytesReference = BytesReference.bytes(builder);
        SourceToParse sourceToParse = new SourceToParse(this.indexName, "_id", bytesReference, JsonXContent.jsonXContent.mediaType());
        ParsedDocument parsedDocument = mapper.parse(sourceToParse);
        Mapping mapping = parsedDocument.dynamicMappingsUpdate();
        return mapping.root.getMapper("field");
    }

    private static class RandomSourceValuesGenerator
    implements Iterator<List<Object>> {
        private final ValueFetcher valueFetcher;
        private final IndexReader indexReader;
        private final SourceLookup sourceLookup;
        private final int[] docs;
        private int iter;
        private int leaf;
        private final int MAX_ATTEMPTS_TO_GENERATE_RANDOM_SAMPLES = 10000;

        public RandomSourceValuesGenerator(int sampleSize, IndexReader indexReader, ValueFetcher valueFetcher) {
            this.valueFetcher = valueFetcher;
            this.indexReader = indexReader;
            sampleSize = Math.min(sampleSize, indexReader.numDocs());
            this.docs = RandomSourceValuesGenerator.getSortedRandomNum(sampleSize, indexReader.numDocs(), Math.max(sampleSize, 10000));
            this.iter = 0;
            this.leaf = -1;
            this.sourceLookup = new SourceLookup();
            if (this.hasNext()) {
                this.setNextLeaf();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iter < this.docs.length && this.leaf < this.indexReader.leaves().size();
        }

        @Override
        public List<Object> next() {
            int docID = this.docs[this.iter] - this.indexReader.leaves().get((int)this.leaf).docBase;
            if (docID >= this.indexReader.leaves().get(this.leaf).reader().numDocs()) {
                this.setNextLeaf();
            }
            this.sourceLookup.setSegmentAndDocument(this.indexReader.leaves().get(this.leaf), this.docs[this.iter] - this.indexReader.leaves().get((int)this.leaf).docBase);
            try {
                ++this.iter;
                return this.valueFetcher.fetchValues(this.sourceLookup);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void setNextLeaf() {
            int readerIndex = ReaderUtil.subIndex(this.docs[this.iter], this.indexReader.leaves());
            this.leaf = readerIndex != this.leaf ? readerIndex : ++this.leaf;
            if (this.leaf < this.indexReader.leaves().size()) {
                this.valueFetcher.setNextReader(this.indexReader.leaves().get(this.leaf));
            }
        }

        private static int[] getSortedRandomNum(int sampleSize, int upperBound, int attempts) {
            TreeSet generatedNumbers = new TreeSet();
            Random random = Randomness.get();
            int itr = 0;
            if (upperBound <= 10 * sampleSize) {
                ArrayList<Integer> numberList = new ArrayList<Integer>();
                for (int i = 0; i < upperBound; ++i) {
                    numberList.add(i);
                }
                Collections.shuffle(numberList, random);
                generatedNumbers.addAll(numberList.subList(0, sampleSize));
            } else {
                while (generatedNumbers.size() < sampleSize && itr++ < attempts) {
                    int randomNumber = random.nextInt(upperBound);
                    generatedNumbers.add(randomNumber);
                }
            }
            return generatedNumbers.stream().mapToInt(Integer::valueOf).toArray();
        }
    }
}

