/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.RankFeatureFieldMapper;
import org.opensearch.index.mapper.RankFeatureMetaFieldMapper;
import org.opensearch.index.mapper.RankFeaturesFieldMapper;
import org.opensearch.index.mapper.ScaledFloatFieldMapper;
import org.opensearch.index.mapper.SearchAsYouTypeFieldMapper;
import org.opensearch.index.mapper.TokenCountFieldMapper;
import org.opensearch.index.query.RankFeatureQueryBuilder;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;

public class MapperExtrasModulePlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, ParametrizedFieldMapper.TypeParser> mappers = new LinkedHashMap<String, ParametrizedFieldMapper.TypeParser>();
        mappers.put("scaled_float", ScaledFloatFieldMapper.PARSER);
        mappers.put("token_count", TokenCountFieldMapper.PARSER);
        mappers.put("rank_feature", RankFeatureFieldMapper.PARSER);
        mappers.put("rank_features", RankFeaturesFieldMapper.PARSER);
        mappers.put("search_as_you_type", SearchAsYouTypeFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    @Override
    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", RankFeatureMetaFieldMapper.PARSER);
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<RankFeatureQueryBuilder>("rank_feature", RankFeatureQueryBuilder::new, p -> RankFeatureQueryBuilder.PARSER.parse(p, null)));
    }
}

