/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.common.Explicit;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;

@PublicApi(since="1.0.0")
public abstract class MetadataFieldMapper
extends ParametrizedFieldMapper {
    public static ParametrizedFieldMapper.Parameter<Explicit<Boolean>> updateableBoolParam(String name, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
        Explicit<Boolean> defaultExplicit = new Explicit<Boolean>(defaultValue, false);
        return new ParametrizedFieldMapper.Parameter<Explicit<Boolean>>(name, true, () -> defaultExplicit, (n, c, o) -> new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(o), true), initializer).setSerializer((b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
    }

    protected MetadataFieldMapper(MappedFieldType mappedFieldType) {
        super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return null;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder mergeBuilder = (Builder)this.getMergeBuilder();
        if (mergeBuilder == null || !mergeBuilder.isConfigured()) {
            return builder;
        }
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new MapperParsingException("Field [" + this.name() + "] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
    }

    public void preParse(ParseContext context) throws IOException {
    }

    public void postParse(ParseContext context) throws IOException {
    }

    @PublicApi(since="1.0.0")
    public static abstract class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Builder(String name) {
            super(name);
        }

        boolean isConfigured() {
            for (ParametrizedFieldMapper.Parameter<?> param : this.getParameters()) {
                if (!param.isConfigured()) continue;
                return true;
            }
            return false;
        }

        @Override
        public abstract MetadataFieldMapper build(Mapper.BuilderContext var1);
    }

    public static class ConfigurableTypeParser
    implements TypeParser {
        final Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> defaultMapperParser;
        final Function<Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public ConfigurableTypeParser(Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> defaultMapperParser, Function<Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.defaultMapperParser = defaultMapperParser;
            this.builderFunction = builderFunction;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType defaultFieldType, Mapper.TypeParser.ParserContext parserContext) {
            return this.defaultMapperParser.apply(parserContext);
        }
    }

    public static class FixedTypeParser
    implements TypeParser {
        final Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> mapperParser;

        public FixedTypeParser(Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> mapperParser) {
            this.mapperParser = mapperParser;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException(name + " is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType defaultFieldType, Mapper.TypeParser.ParserContext parserContext) {
            return this.mapperParser.apply(parserContext);
        }
    }

    @PublicApi(since="1.0.0")
    public static interface TypeParser
    extends Mapper.TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, Mapper.TypeParser.ParserContext var3) throws MapperParsingException;

        public MetadataFieldMapper getDefault(MappedFieldType var1, Mapper.TypeParser.ParserContext var2);
    }
}

