/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SemanticVersion;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TermBasedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class SemanticVersionFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "version";
    public static final FieldType FIELD_TYPE = new FieldType();
    public static final String NORMALIZED_FIELD_SUFFIX = "._normalized";
    private final Map<String, String> meta;
    public static final ParametrizedFieldMapper.TypeParser PARSER;

    protected SemanticVersionFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Map<String, String> meta) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.meta = meta;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        SemanticVersion version = SemanticVersion.parse(value);
        String versionString = version.toString();
        String normalizedValue = version.getNormalizedComparableString();
        BytesRef bytes = new BytesRef(versionString);
        BytesRef normalizedValueBytes = new BytesRef(normalizedValue);
        if (this.fieldType().isStored()) {
            context.doc().add(new StoredField(this.fieldType().name(), versionString));
        }
        if (this.fieldType().isSearchable()) {
            context.doc().add(new KeywordField(this.fieldType().name(), bytes, this.fieldType.stored() ? Field.Store.YES : Field.Store.NO));
        }
        if (this.fieldType().hasDocValues() || this.fieldType().isSearchable()) {
            context.doc().add(new KeywordField(this.fieldType().name() + NORMALIZED_FIELD_SUFFIX, normalizedValueBytes, Field.Store.NO));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name() + NORMALIZED_FIELD_SUFFIX, normalizedValueBytes));
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        Builder builder = new Builder(this.name());
        builder.init(this);
        return builder;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        FIELD_TYPE.freeze();
        PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> Builder.toType((FieldMapper)m).isSearchable, true).alwaysSerialize();
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> Builder.toType((FieldMapper)m).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> Builder.toType((FieldMapper)m).isStored, false);

        private static SemanticVersionFieldType toType(FieldMapper m) {
            return (SemanticVersionFieldType)((ParametrizedFieldMapper)m).mappedFieldType;
        }

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList();
            parameters.add(this.indexed);
            parameters.add(this.hasDocValues);
            parameters.add(this.stored);
            parameters.add(this.meta);
            return parameters;
        }

        @Override
        public SemanticVersionFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldType = new FieldType();
            fieldType.setTokenized(false);
            fieldType.setStored(this.stored.getValue());
            fieldType.setIndexOptions(this.indexed.getValue() != false ? IndexOptions.DOCS : IndexOptions.NONE);
            fieldType.setDocValuesType(this.hasDocValues.getValue() != false ? DocValuesType.SORTED_SET : DocValuesType.NONE);
            fieldType.freeze();
            return new SemanticVersionFieldMapper(this.name, fieldType, new SemanticVersionFieldType(this.buildFullName(context), this.meta.getValue(), this.indexed.getValue(), this.hasDocValues.getValue(), this.stored.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this.meta.getValue());
        }
    }

    public static class SemanticVersionFieldType
    extends TermBasedFieldType {
        private final Map<String, String> meta;
        private final String normalizedFieldName;
        private final boolean isSearchable;
        private final boolean hasDocValues;
        private final boolean isStored;

        public SemanticVersionFieldType(String name, Map<String, String> meta, boolean isSearchable, boolean hasDocValues, boolean isStored) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.meta = meta;
            this.normalizedFieldName = name + SemanticVersionFieldMapper.NORMALIZED_FIELD_SUFFIX;
            this.isSearchable = isSearchable;
            this.hasDocValues = hasDocValues;
            this.isStored = isStored;
        }

        @Override
        public String typeName() {
            return SemanticVersionFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query dvQuery;
            if (value == null) {
                throw new IllegalArgumentException("Cannot search for null value");
            }
            BytesRef bytes = value instanceof BytesRef ? (BytesRef)value : new BytesRef(value.toString());
            TermQuery indexQuery = this.isSearchable ? new TermQuery(new Term(this.name(), bytes)) : null;
            Query query = dvQuery = this.hasDocValues ? SortedSetDocValuesField.newSlowExactQuery(this.normalizedFieldName, bytes) : null;
            if (indexQuery != null && dvQuery != null) {
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (indexQuery != null) {
                return indexQuery;
            }
            if (dvQuery != null) {
                return dvQuery;
            }
            throw new IllegalArgumentException("Field [" + this.name() + "] is neither indexed nor has doc_values enabled");
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            try {
                Query dvQuery;
                BytesRef lower = null;
                BytesRef upper = null;
                if (lowerTerm != null) {
                    String lowerStr = lowerTerm instanceof BytesRef ? ((BytesRef)lowerTerm).utf8ToString() : lowerTerm.toString();
                    SemanticVersion lowerVersion = SemanticVersion.parse(lowerStr);
                    lower = new BytesRef(lowerVersion.getNormalizedComparableString());
                }
                if (upperTerm != null) {
                    String upperStr = upperTerm instanceof BytesRef ? ((BytesRef)upperTerm).utf8ToString() : upperTerm.toString();
                    SemanticVersion upperVersion = SemanticVersion.parse(upperStr);
                    upper = new BytesRef(upperVersion.getNormalizedComparableString());
                }
                TermRangeQuery indexQuery = this.isSearchable ? new TermRangeQuery(this.normalizedFieldName, lower, upper, includeLower, includeUpper) : null;
                Query query = dvQuery = this.hasDocValues ? SortedSetDocValuesField.newSlowRangeQuery(this.normalizedFieldName, lower, upper, includeLower, includeUpper) : null;
                if (indexQuery != null && dvQuery != null) {
                    return new IndexOrDocValuesQuery(indexQuery, dvQuery);
                }
                if (indexQuery != null) {
                    return indexQuery;
                }
                if (dvQuery != null) {
                    return dvQuery;
                }
                throw new IllegalArgumentException("Field [" + this.name() + "] is neither indexed nor has doc_values enabled");
            }
            catch (Exception e) {
                throw new QueryShardException(context, "Failed to create range query for field [" + this.name() + "]. Lower term: [" + (lowerTerm != null ? lowerTerm.toString() : "null") + "], Upper term: [" + (upperTerm != null ? upperTerm.toString() : "null") + "]", new Object[0]);
            }
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            Query dvQuery;
            ArrayList<BytesRef> bytesList = new ArrayList<BytesRef>();
            for (Object value : values) {
                bytesList.add(value instanceof BytesRef ? (BytesRef)value : new BytesRef(value.toString()));
            }
            TermInSetQuery indexQuery = this.isSearchable ? new TermInSetQuery(this.name(), bytesList) : null;
            Query query = dvQuery = this.hasDocValues ? SortedSetDocValuesField.newSlowSetQuery(this.normalizedFieldName, bytesList) : null;
            if (indexQuery != null && dvQuery != null) {
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            if (indexQuery != null) {
                return indexQuery;
            }
            if (dvQuery != null) {
                return dvQuery;
            }
            throw new IllegalArgumentException("Field [" + this.name() + "] is neither indexed nor has doc_values enabled");
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (method == null) {
                method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
            }
            if (this.isSearchable) {
                return new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, method);
            }
            throw new IllegalArgumentException("Regexp queries require the field to be indexed");
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (caseInsensitive) {
                value = value.toLowerCase(Locale.ROOT);
            }
            if (this.isSearchable) {
                return new WildcardQuery(new Term(this.name(), this.indexedValueForSearch(value)), 10000);
            }
            throw new IllegalArgumentException("Wildcard queries require the field to be indexed");
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (method == null) {
                method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
            }
            if (this.isSearchable) {
                return new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value)), method);
            }
            throw new IllegalArgumentException("Prefix queries require the field to be indexed");
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (method == null) {
                method = MultiTermQuery.CONSTANT_SCORE_REWRITE;
            }
            if (this.isSearchable) {
                return new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(), prefixLength, maxExpansions, transpositions, method);
            }
            throw new IllegalArgumentException("Fuzzy queries require the field to be indexed");
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, format){

                @Override
                protected String parseSourceValue(Object value) {
                    return value.toString();
                }
            };
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            if (!this.hasDocValues) {
                throw new IllegalArgumentException("Field [" + this.name() + "] does not have doc_values enabled");
            }
            return new SortedSetOrdinalsIndexFieldData.Builder(this.normalizedFieldName, CoreValuesSourceType.BYTES);
        }

        @Override
        public Map<String, String> meta() {
            return this.meta;
        }
    }
}

