/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.mapper.FieldValueFetcher;
import org.opensearch.index.mapper.MappedFieldType;

public class SortedSetDocValuesFetcher
extends FieldValueFetcher {
    public SortedSetDocValuesFetcher(MappedFieldType mappedFieldType, String simpleName) {
        super(simpleName);
        this.mappedFieldType = mappedFieldType;
    }

    @Override
    public List<Object> fetch(LeafReader reader, int docId) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            SortedSetDocValues sortedSetDocValues = reader.getSortedSetDocValues(this.mappedFieldType.name());
            if (sortedSetDocValues == null || !sortedSetDocValues.advanceExact(docId)) {
                return values;
            }
            int valueCount = sortedSetDocValues.docValueCount();
            for (int ord = 0; ord < valueCount; ++ord) {
                BytesRef value = sortedSetDocValues.lookupOrd(sortedSetDocValues.nextOrd());
                values.add(BytesRef.deepCopyOf(value));
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read doc values for document " + docId + " in field " + this.mappedFieldType.name(), e);
        }
        return values;
    }

    @Override
    public Object convert(Object value) {
        return this.mappedFieldType.valueForDisplay(value);
    }
}

