/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.OpenSearchException;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.lucene.search.AutomatonQueries;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.index.mapper.TermBasedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.SearchService;

public abstract class StringFieldType
extends TermBasedFieldType {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\\\.)|([?*]+)");

    public StringFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, isStored, hasDocValues, textSearchInfo, meta);
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[fuzzy] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        if (method == null) {
            method = FuzzyQuery.defaultRewriteMethod(maxExpansions);
        }
        return new FuzzyQuery(new Term(this.name(), this.indexedValueForSearch(value)), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions, method);
    }

    @Override
    public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[prefix] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false. For optimised prefix queries on text fields please enable [index_prefixes].", new Object[0]);
        }
        this.failIfNotIndexed();
        if (method == null) {
            method = MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE;
        }
        if (caseInsensitive) {
            return AutomatonQueries.caseInsensitivePrefixQuery(new Term(this.name(), this.indexedValueForSearch(value)), method);
        }
        return new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value)), method);
    }

    public static final String normalizeWildcardPattern(String fieldname, String value, Analyzer normalizer) {
        BytesRef normalized;
        String chunk;
        if (normalizer == null) {
            return value;
        }
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(value);
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.start() > 0) {
                chunk = value.substring(last, wildcardMatcher.start());
                normalized = normalizer.normalize(fieldname, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef(wildcardMatcher.group()));
            last = wildcardMatcher.end();
        }
        if (last < value.length()) {
            chunk = value.substring(last);
            normalized = normalizer.normalize(fieldname, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef().utf8ToString();
    }

    @Override
    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        return this.wildcardQuery(value, method, caseInsensitive, false, context);
    }

    @Override
    public Query normalizedWildcardQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        return this.wildcardQuery(value, method, false, true, context);
    }

    public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, boolean normalizeIfAnalyzed, QueryShardContext context) {
        Term term;
        this.failIfNotIndexed();
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[wildcard] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        if (this.getTextSearchInfo().getSearchAnalyzer() != null && normalizeIfAnalyzed) {
            value = StringFieldType.normalizeWildcardPattern(this.name(), value, this.getTextSearchInfo().getSearchAnalyzer());
            term = new Term(this.name(), value);
        } else {
            term = new Term(this.name(), this.indexedValueForSearch(value));
        }
        if (caseInsensitive) {
            return AutomatonQueries.caseInsensitiveWildcardQuery(term, method);
        }
        if (method == null) {
            method = MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE;
        }
        return new WildcardQuery(term, 10000, method);
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[regexp] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        if (method == null) {
            method = MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE;
        }
        return new RegexpQuery(new Term(this.name(), this.indexedValueForSearch(value)), syntaxFlags, matchFlags, RegexpQuery.DEFAULT_PROVIDER, maxDeterminizedStates, method);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        this.failIfNotIndexed();
        return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }
}

