/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.AutomatonQueries;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.DerivedFieldGenerator;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FieldValueType;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SortedSetDocValuesFetcher;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;

public class WildcardFieldMapper
extends ParametrizedFieldMapper {
    private final String nullValue;
    private final int ignoreAbove;
    private final String normalizerName;
    private final boolean hasDocValues;
    private final IndexAnalyzers indexAnalyzers;
    public static final int NGRAM_SIZE = 3;
    public static final String CONTENT_TYPE = "wildcard";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private static final FieldType FIELD_TYPE = new FieldType();

    protected WildcardFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.nullValue = builder.nullValue.getValue();
        this.ignoreAbove = builder.ignoreAbove.getValue();
        this.normalizerName = builder.normalizer.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.indexAnalyzers = builder.indexAnalyzers;
    }

    public int ignoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser;
        String value = context.externalValueSet() ? context.externalValue().toString() : ((parser = context.parser()).currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull());
        if (value == null || value.length() > this.ignoreAbove) {
            return;
        }
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = KeywordFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        BytesRef binaryValue = new BytesRef(value);
        WildcardFieldTokenizer tokenizer = new WildcardFieldTokenizer();
        tokenizer.setReader(new StringReader(value));
        context.doc().add(new Field(this.fieldType().name(), tokenizer, (IndexableFieldType)FIELD_TYPE));
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        } else if (!this.fieldType().hasDocValues()) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public WildcardFieldType fieldType() {
        return (WildcardFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers).init(this);
    }

    private static WildcardFieldMapper toType(FieldMapper in) {
        return (WildcardFieldMapper)in;
    }

    @Override
    protected void canDeriveSourceInternal() {
        if (this.ignoreAbove != Integer.MAX_VALUE || !Objects.equals(this.normalizerName, "default")) {
            throw new UnsupportedOperationException("Unable to derive source for [" + this.name() + "] with ignore_above and/or normalizer set");
        }
        this.checkDocValuesForDerivedSource();
    }

    @Override
    protected DerivedFieldGenerator derivedFieldGenerator() {
        return new DerivedFieldGenerator(this, this.mappedFieldType, new SortedSetDocValuesFetcher(this, this.mappedFieldType, this.simpleName()){

            @Override
            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                BytesRef binaryValue = (BytesRef)value;
                return binaryValue.utf8ToString();
            }
        }, null){

            @Override
            public FieldValueType getDerivedFieldPreference() {
                return FieldValueType.DOC_VALUES;
            }
        };
    }

    static {
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.freeze();
    }

    public static final class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> nullValue = ParametrizedFieldMapper.Parameter.stringParam("null_value", false, m -> WildcardFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Integer> ignoreAbove = ParametrizedFieldMapper.Parameter.intParam("ignore_above", true, m -> WildcardFieldMapper.toType((FieldMapper)m).ignoreAbove, Integer.MAX_VALUE);
        private final ParametrizedFieldMapper.Parameter<String> normalizer = ParametrizedFieldMapper.Parameter.stringParam("normalizer", false, m -> WildcardFieldMapper.toType((FieldMapper)m).normalizerName, "default");
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> WildcardFieldMapper.toType((FieldMapper)m).hasDocValues, false).alwaysSerialize();
        private final IndexAnalyzers indexAnalyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
        }

        public Builder(String name) {
            this(name, null);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.nullValue, this.ignoreAbove, this.normalizer, this.hasDocValues, this.meta);
        }

        @Override
        public WildcardFieldMapper build(Mapper.BuilderContext context) {
            String normalizerName = this.normalizer.getValue();
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            if (!"default".equals(normalizerName)) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
            }
            return new WildcardFieldMapper(this.name, new WildcardFieldType(context.path().pathAsText(this.name), normalizer, this), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class WildcardFieldType
    extends StringFieldType {
        private static final Set<Character> WILDCARD_SPECIAL = Set.of(Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'));
        private static final Set<Character> REGEXP_SPECIAL = Set.of(Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('?'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('/'), Character.valueOf('\\'));
        private final int ignoreAbove;
        private final String nullValue;

        public WildcardFieldType(String name) {
            this(name, Collections.emptyMap());
        }

        public WildcardFieldType(String name, Map<String, String> meta) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
        }

        public WildcardFieldType(String name, NamedAnalyzer normalizer, Builder builder) {
            super(name, true, false, builder.hasDocValues.getValue(), TextSearchInfo.SIMPLE_MATCH_ONLY, builder.meta.getValue());
            this.setIndexAnalyzer(normalizer);
            this.ignoreAbove = builder.ignoreAbove.getValue();
            this.nullValue = builder.nullValue.getValue();
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.hasDocValues()) {
                return new DocValueFetcher(DocValueFormat.RAW, searchLookup.doc().getForField(this));
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return keywordValue;
                    }
                    try {
                        return KeywordFieldMapper.normalizeValue(normalizer, this.name(), keywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public String typeName() {
            return WildcardFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            throw new IllegalArgumentException("Can only use fuzzy queries on keyword and text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            return this.wildcardQuery(value + "*", method, caseInsensitive, context);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            void var11_13;
            Predicate<String> matchPredicate;
            NamedAnalyzer normalizer = this.normalizer();
            if (normalizer != null) {
                value = WildcardFieldType.normalizeWildcardPattern(this.name(), value, normalizer);
            }
            String finalValue = caseInsensitive ? value.toLowerCase(Locale.ROOT) : value;
            Automaton automaton = WildcardQuery.toAutomaton(new Term(this.name(), finalValue), 10000);
            CompiledAutomaton compiledAutomaton = new CompiledAutomaton(automaton);
            if (compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.SINGLE) {
                matchPredicate = s -> {
                    if (caseInsensitive) {
                        s = s.toLowerCase(Locale.ROOT);
                    }
                    return s.equals(WildcardFieldType.performEscape(finalValue, false));
                };
            } else {
                if (compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                    return this.existsQuery(context);
                }
                if (compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.NONE) {
                    return new MatchNoDocsQuery("Wildcard expression matches nothing");
                }
                matchPredicate = s -> {
                    if (caseInsensitive) {
                        s = s.toLowerCase(Locale.ROOT);
                    }
                    BytesRef valueBytes = BytesRefs.toBytesRef(s);
                    return compiledAutomaton.runAutomaton.run(valueBytes.bytes, valueBytes.offset, valueBytes.length);
                };
            }
            Set<String> requiredNGrams = WildcardFieldType.getRequiredNGrams(finalValue, false);
            if (requiredNGrams.isEmpty()) {
                if (WildcardFieldType.findNonWildcardSequence(value, 0) == value.length() && value.length() != 0 && !value.contains("?")) return this.existsQuery(context);
                Query query = this.existsQuery(context);
                return new WildcardMatchingQuery(this.name(), (Query)var11_13, matchPredicate, value, context, this);
            } else {
                BooleanQuery booleanQuery = WildcardFieldType.matchAllTermsQuery(this.name(), requiredNGrams, caseInsensitive);
            }
            return new WildcardMatchingQuery(this.name(), (Query)var11_13, matchPredicate, value, context, this);
        }

        static Set<String> getRequiredNGrams(String value, boolean regexpMode) {
            HashSet<String> terms = new HashSet<String>();
            if (value.isEmpty()) {
                return terms;
            }
            int pos = 0;
            String rawSequence = null;
            String currentSequence = null;
            char[] buffer = new char[3];
            if (!value.startsWith("?") && !value.startsWith("*")) {
                rawSequence = WildcardFieldType.getNonWildcardSequence(value, 0);
                currentSequence = WildcardFieldType.performEscape(rawSequence, regexpMode);
                Arrays.fill(buffer, '\u0000');
                int startIdx = Math.max(3 - currentSequence.length(), 1);
                for (int j = 0; j < currentSequence.length() && j < 2; ++j) {
                    buffer[startIdx + j] = currentSequence.charAt(j);
                }
                terms.add(new String(buffer));
            } else {
                pos = WildcardFieldType.findNonWildcardSequence(value, pos);
                rawSequence = WildcardFieldType.getNonWildcardSequence(value, pos);
            }
            while (pos < value.length()) {
                int i;
                boolean isEndOfValue = pos + rawSequence.length() == value.length();
                currentSequence = WildcardFieldType.performEscape(rawSequence, regexpMode);
                for (i = 0; i < currentSequence.length() - 3 + 1; ++i) {
                    terms.add(currentSequence.substring(i, i + 3));
                }
                if (isEndOfValue) {
                    int rightStartIdx;
                    Arrays.fill(buffer, '\u0000');
                    if (pos == 0 && currentSequence.length() == 1) {
                        for (i = 0; i < currentSequence.length(); ++i) {
                            buffer[i + 1] = currentSequence.charAt(i);
                        }
                        terms.add(new String(buffer));
                        Arrays.fill(buffer, '\u0000');
                    }
                    rightStartIdx = (rightStartIdx = 3 - currentSequence.length() - 2) < 0 ? 1 : rightStartIdx;
                    for (int j = 0; j < currentSequence.length() && j < 2; ++j) {
                        buffer[rightStartIdx - j] = currentSequence.charAt(currentSequence.length() - j - 1);
                    }
                    terms.add(new String(buffer));
                }
                pos = WildcardFieldType.findNonWildcardSequence(value, pos + rawSequence.length());
                rawSequence = WildcardFieldType.getNonWildcardSequence(value, pos);
            }
            return terms;
        }

        private static String getNonWildcardSequence(String value, int startFrom) {
            for (int i = startFrom; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != '?' && c != '*' || i != 0 && value.charAt(i - 1) == '\\') continue;
                return value.substring(startFrom, i);
            }
            return value.substring(startFrom);
        }

        private static int findNonWildcardSequence(String value, int startFrom) {
            for (int i = startFrom; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '?' || c == '*') continue;
                return i;
            }
            return value.length();
        }

        private static String performEscape(String str, boolean regexpMode) {
            StringBuilder sb = new StringBuilder();
            Set<Character> targetChars = regexpMode ? REGEXP_SPECIAL : WILDCARD_SPECIAL;
            for (int i = 0; i < str.length(); ++i) {
                char c;
                if (str.charAt(i) == '\\' && i + 1 < str.length() && targetChars.contains(Character.valueOf(c = str.charAt(i + 1)))) {
                    ++i;
                }
                sb.append(str.charAt(i));
            }
            return sb.toString();
        }

        private static String quoteWildcard(String str) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                if (WILDCARD_SPECIAL.contains(Character.valueOf(str.charAt(i)))) {
                    sb.append('\\');
                }
                sb.append(str.charAt(i));
            }
            return sb.toString();
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            NamedAnalyzer normalizer = this.normalizer();
            String finalValue = normalizer != null ? (value = normalizer.normalize(this.name(), value).utf8ToString()) : value;
            boolean caseInsensitive = matchFlags == 256;
            RegExp regExp = new RegExp(finalValue, syntaxFlags, matchFlags);
            Automaton automaton = Operations.determinize(regExp.toAutomaton(), 10000);
            CompiledAutomaton compiledAutomaton = new CompiledAutomaton(automaton);
            if (compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                return this.existsQuery(context);
            }
            if (compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.NONE) {
                return new MatchNoDocsQuery("Regular expression matches nothing");
            }
            Predicate<String> regexpPredicate = compiledAutomaton.type == CompiledAutomaton.AUTOMATON_TYPE.SINGLE ? s -> {
                if (caseInsensitive) {
                    s = s.toLowerCase(Locale.ROOT);
                }
                return s.equals(WildcardFieldType.performEscape(finalValue, true));
            } : s -> {
                BytesRef valueBytes = BytesRefs.toBytesRef(s);
                return compiledAutomaton.runAutomaton.run(valueBytes.bytes, valueBytes.offset, valueBytes.length);
            };
            Query approximation = WildcardFieldType.regexpToQuery(this.name(), regExp, caseInsensitive);
            if (approximation instanceof MatchAllDocsQuery) {
                approximation = this.existsQuery(context);
            }
            return new WildcardMatchingQuery(this.name(), approximation, regexpPredicate, "/" + finalValue + "/", context, this);
        }

        private static Query regexpToQuery(String fieldName, RegExp regExp, boolean caseInsensitive) {
            BooleanQuery query;
            if (Objects.requireNonNull(regExp.kind) == RegExp.Kind.REGEXP_UNION) {
                ArrayList<Query> clauses = new ArrayList<Query>();
                while (regExp.exp1.kind == RegExp.Kind.REGEXP_UNION) {
                    clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp2, caseInsensitive));
                    regExp = regExp.exp1;
                }
                clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp2, caseInsensitive));
                clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp1, caseInsensitive));
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (int i = clauses.size() - 1; i >= 0; --i) {
                    Query clause = (Query)clauses.get(i);
                    if (clause instanceof MatchAllDocsQuery) {
                        return clause;
                    }
                    builder.add(clause, BooleanClause.Occur.SHOULD);
                }
                query = builder.build();
            } else if (regExp.kind == RegExp.Kind.REGEXP_STRING) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (String string : WildcardFieldType.getRequiredNGrams("*" + regExp.s + "*", true)) {
                    Query subQuery = caseInsensitive ? AutomatonQueries.caseInsensitiveTermQuery(new Term(fieldName, string)) : new TermQuery(new Term(fieldName, string));
                    builder.add(subQuery, BooleanClause.Occur.FILTER);
                }
                query = builder.build();
            } else if (regExp.kind == RegExp.Kind.REGEXP_CONCATENATION) {
                ArrayList<Query> clauses = new ArrayList<Query>();
                while (regExp.exp1.kind == RegExp.Kind.REGEXP_CONCATENATION) {
                    clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp2, caseInsensitive));
                    regExp = regExp.exp1;
                }
                clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp2, caseInsensitive));
                clauses.add(WildcardFieldType.regexpToQuery(fieldName, regExp.exp1, caseInsensitive));
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (int i = clauses.size() - 1; i >= 0; --i) {
                    Query clause = (Query)clauses.get(i);
                    if (clause instanceof MatchAllDocsQuery) continue;
                    builder.add(clause, BooleanClause.Occur.FILTER);
                }
                query = builder.build();
            } else {
                if ((regExp.kind == RegExp.Kind.REGEXP_REPEAT_MIN || regExp.kind == RegExp.Kind.REGEXP_REPEAT_MINMAX) && regExp.min > 0) {
                    return WildcardFieldType.regexpToQuery(fieldName, regExp.exp1, caseInsensitive);
                }
                return new MatchAllDocsQuery();
            }
            if (query.clauses().size() == 1) {
                return query.iterator().next().query();
            }
            if (query.clauses().size() == 0) {
                return new MatchAllDocsQuery();
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
            return this.wildcardQuery(WildcardFieldType.quoteWildcard(BytesRefs.toString(value)), MultiTermQuery.CONSTANT_SCORE_REWRITE, true, context);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.wildcardQuery(WildcardFieldType.quoteWildcard(BytesRefs.toString(value)), MultiTermQuery.CONSTANT_SCORE_REWRITE, false, context);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            HashSet<String> expectedValues = new HashSet<String>();
            StringBuilder pattern = new StringBuilder();
            for (Object value : values) {
                String stringVal = BytesRefs.toString(value);
                builder.add(WildcardFieldType.matchAllTermsQuery(this.name(), WildcardFieldType.getRequiredNGrams(WildcardFieldType.quoteWildcard(stringVal), false), false), BooleanClause.Occur.SHOULD);
                expectedValues.add(stringVal);
                if (pattern.length() > 0) {
                    pattern.append('|');
                }
                pattern.append(stringVal);
            }
            return new WildcardMatchingQuery(this.name(), (Query)builder.build(), expectedValues::contains, pattern.toString(), context, this);
        }

        private static BooleanQuery matchAllTermsQuery(String fieldName, Set<String> terms, boolean caseInsensitive) {
            BooleanQuery.Builder matchAllTermsBuilder = new BooleanQuery.Builder();
            for (String term : terms) {
                Query query = caseInsensitive ? AutomatonQueries.caseInsensitiveTermQuery(new Term(fieldName, term)) : new TermQuery(new Term(fieldName, term));
                matchAllTermsBuilder.add(query, BooleanClause.Occur.FILTER);
            }
            return matchAllTermsBuilder.build();
        }
    }

    static final class WildcardFieldTokenizer
    extends Tokenizer {
        private final CharTermAttribute charTermAttribute = this.addAttribute(CharTermAttribute.class);
        private final char[] buffer = new char[3];
        private int offset = 2;

        WildcardFieldTokenizer() {
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            for (int i = 0; i < 2; ++i) {
                this.buffer[i] = '\u0000';
            }
        }

        @Override
        public boolean incrementToken() throws IOException {
            this.charTermAttribute.setLength(3);
            int c = this.input.read();
            c = c == -1 ? 0 : c;
            this.buffer[this.offset++ % 3] = (char)c;
            boolean has_next = false;
            for (int i = 0; i < 3; ++i) {
                char curChar;
                this.charTermAttribute.buffer()[i] = curChar = this.buffer[(this.offset + i) % 3];
                has_next |= curChar != '\u0000';
            }
            return has_next;
        }
    }

    static class WildcardMatchingQuery
    extends Query {
        private static final long MATCH_COST_ESTIMATE = 1000L;
        private final String fieldName;
        private final Query firstPhaseQuery;
        private final Predicate<String> secondPhaseMatcher;
        private final String patternString;
        private final ValueFetcher valueFetcher;
        private final SearchLookup searchLookup;

        WildcardMatchingQuery(String fieldName, Query firstPhaseQuery, String patternString) {
            this(fieldName, firstPhaseQuery, (String s) -> true, patternString, (QueryShardContext)null, null);
        }

        public WildcardMatchingQuery(String fieldName, Query firstPhaseQuery, Predicate<String> secondPhaseMatcher, String patternString, QueryShardContext context, WildcardFieldType fieldType) {
            this.fieldName = Objects.requireNonNull(fieldName);
            this.firstPhaseQuery = Objects.requireNonNull(firstPhaseQuery);
            this.secondPhaseMatcher = Objects.requireNonNull(secondPhaseMatcher);
            this.patternString = Objects.requireNonNull(patternString);
            if (context != null) {
                this.searchLookup = context.lookup();
                this.valueFetcher = fieldType.valueFetcher(context, context.lookup(), null);
            } else {
                this.searchLookup = null;
                this.valueFetcher = null;
            }
        }

        private WildcardMatchingQuery(String fieldName, Query firstPhaseQuery, Predicate<String> secondPhaseMatcher, String patternString, ValueFetcher valueFetcher, SearchLookup searchLookup) {
            this.fieldName = fieldName;
            this.firstPhaseQuery = firstPhaseQuery;
            this.secondPhaseMatcher = secondPhaseMatcher;
            this.patternString = patternString;
            this.valueFetcher = valueFetcher;
            this.searchLookup = searchLookup;
        }

        @Override
        public String toString(String s) {
            return "WildcardMatchingQuery(" + this.fieldName + ":\"" + this.patternString + "\")";
        }

        @Override
        public void visit(QueryVisitor queryVisitor) {
            this.firstPhaseQuery.visit(queryVisitor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WildcardMatchingQuery that = (WildcardMatchingQuery)o;
            return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.firstPhaseQuery, that.firstPhaseQuery) && Objects.equals(this.patternString, that.patternString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.fieldName, this.firstPhaseQuery, this.patternString);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query rewriteFirstPhase = this.firstPhaseQuery.rewrite(indexSearcher);
            if (rewriteFirstPhase != this.firstPhaseQuery) {
                return new WildcardMatchingQuery(this.fieldName, rewriteFirstPhase, this.secondPhaseMatcher, this.patternString, this.valueFetcher, this.searchLookup);
            }
            return this;
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight firstPhaseWeight = this.firstPhaseQuery.createWeight(searcher, scoreMode, boost);
            return new ConstantScoreWeight(this, this, boost){
                final /* synthetic */ WildcardMatchingQuery this$0;
                {
                    this.this$0 = this$0;
                    super(query, score);
                }

                @Override
                public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                    final ScorerSupplier firstPhaseSupplier = firstPhaseWeight.scorerSupplier(context);
                    if (firstPhaseSupplier == null) {
                        return null;
                    }
                    return new ScorerSupplier(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            Scorer approximateScorer = firstPhaseSupplier.get(leadCost);
                            DocIdSetIterator approximation = approximateScorer.iterator();
                            final LeafSearchLookup leafSearchLookup = this.this$1.this$0.searchLookup.getLeafSearchLookup(context);
                            this.this$1.this$0.valueFetcher.setNextReader(context);
                            TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(this, approximation){
                                final /* synthetic */ WildcardMatchingQuery.1 this$2;
                                {
                                    this.this$2 = this$2;
                                    super(approximation);
                                }

                                @Override
                                public boolean matches() throws IOException {
                                    leafSearchLookup.setDocument(this.approximation.docID());
                                    List<Object> values = this.this$2.this$1.this$0.valueFetcher.fetchValues(leafSearchLookup.source());
                                    for (Object value : values) {
                                        if (!this.this$2.this$1.this$0.secondPhaseMatcher.test(value.toString())) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                @Override
                                public float matchCost() {
                                    return 1000.0f;
                                }
                            };
                            return new ConstantScoreScorer(this.this$1.score(), scoreMode, twoPhaseIterator);
                        }

                        @Override
                        public long cost() {
                            long firstPhaseCost = firstPhaseSupplier.cost();
                            if (firstPhaseCost >= 9223372036854775L) {
                                return Long.MAX_VALUE;
                            }
                            return firstPhaseCost * 1000L;
                        }
                    };
                }

                @Override
                public boolean isCacheable(LeafReaderContext leafReaderContext) {
                    return true;
                }
            };
        }

        Predicate<String> getSecondPhaseMatcher() {
            return this.secondPhaseMatcher;
        }
    }
}

