/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.FilteredIntervalsSource;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.FuzzyQueryBuilder;
import org.opensearch.index.query.IntervalBuilder;
import org.opensearch.index.query.IntervalFilterScript;
import org.opensearch.index.query.IntervalMode;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.RegexpFlag;
import org.opensearch.script.Script;

public abstract class IntervalsSourceProvider
implements NamedWriteable,
ToXContentFragment {
    public abstract IntervalsSource getSource(QueryShardContext var1, MappedFieldType var2) throws IOException;

    public abstract void extractFields(Set<String> var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static IntervalsSourceProvider fromXContent(XContentParser parser) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.FIELD_NAME);
        switch (parser.currentName()) {
            case "match": {
                return Match.fromXContent(parser);
            }
            case "any_of": {
                return Disjunction.fromXContent(parser);
            }
            case "all_of": {
                return Combine.fromXContent(parser);
            }
            case "prefix": {
                return Prefix.fromXContent(parser);
            }
            case "wildcard": {
                return Wildcard.fromXContent(parser);
            }
            case "regexp": {
                return Regexp.fromXContent(parser);
            }
            case "fuzzy": {
                return Fuzzy.fromXContent(parser);
            }
        }
        throw new ParsingException(parser.getTokenLocation(), "Unknown interval type [" + parser.currentName() + "], expecting one of [match, any_of, all_of, prefix, wildcard, regexp]", new Object[0]);
    }

    private static IntervalsSourceProvider parseInnerIntervals(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        IntervalsSourceProvider isp = IntervalsSourceProvider.fromXContent(parser);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        return isp;
    }

    public static class Match
    extends IntervalsSourceProvider {
        public static final String NAME = "match";
        private final String query;
        private final int maxGaps;
        private final IntervalMode mode;
        private final String analyzer;
        private final IntervalFilter filter;
        private final String useField;
        private static final ConstructingObjectParser<Match, Void> PARSER = new ConstructingObjectParser("match", args -> {
            String query = (String)args[0];
            int max_gaps = args[1] == null ? -1 : (Integer)args[1];
            Boolean ordered = (Boolean)args[2];
            String mode = (String)args[3];
            String analyzer = (String)args[4];
            IntervalFilter filter = (IntervalFilter)args[5];
            String useField = (String)args[6];
            IntervalMode intervalMode = ordered != null ? (ordered != false ? IntervalMode.ORDERED : IntervalMode.UNORDERED) : (mode != null ? IntervalMode.fromString(mode) : IntervalMode.UNORDERED);
            return new Match(query, max_gaps, intervalMode, analyzer, filter, useField);
        });

        public Match(String query, int maxGaps, IntervalMode mode, String analyzer, IntervalFilter filter, String useField) {
            this.query = query;
            this.maxGaps = maxGaps;
            this.mode = mode;
            this.analyzer = analyzer;
            this.filter = filter;
            this.useField = useField;
        }

        public Match(StreamInput in) throws IOException {
            this.query = in.readString();
            this.maxGaps = in.readVInt();
            this.mode = IntervalMode.readFromStream(in);
            this.analyzer = in.readOptionalString();
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(QueryShardContext context, MappedFieldType fieldType) throws IOException {
            IntervalsSource source;
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getMapperService().getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = context.fieldMapper(this.useField);
                assert (fieldType != null);
                source = Intervals.fixField(this.useField, fieldType.intervals(this.query, this.maxGaps, this.mode, analyzer, false));
            } else {
                source = fieldType.intervals(this.query, this.maxGaps, this.mode, analyzer, false);
            }
            if (this.filter != null) {
                return this.filter.filter(source, context, fieldType);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            return this.maxGaps == match.maxGaps && this.mode == match.mode && Objects.equals(this.query, match.query) && Objects.equals(this.filter, match.filter) && Objects.equals(this.useField, match.useField) && Objects.equals(this.analyzer, match.analyzer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.query, this.maxGaps, this.mode, this.analyzer, this.filter, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.query);
            out.writeVInt(this.maxGaps);
            this.mode.writeTo(out);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalWriteable(this.filter);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            builder.startObject();
            builder.field("query", this.query);
            builder.field("max_gaps", this.maxGaps);
            builder.field("mode", this.mode);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            return builder.endObject();
        }

        public static Match fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        String getQuery() {
            return this.query;
        }

        int getMaxGaps() {
            return this.maxGaps;
        }

        IntervalMode getMode() {
            return this.mode;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("query", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_gaps", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ordered", new String[0]).withAllDeprecated());
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("mode", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Disjunction
    extends IntervalsSourceProvider {
        public static final String NAME = "any_of";
        private final List<IntervalsSourceProvider> subSources;
        private final IntervalFilter filter;
        private static final ConstructingObjectParser<Disjunction, Void> PARSER = new ConstructingObjectParser("any_of", args -> {
            List subSources = (List)args[0];
            IntervalFilter filter = (IntervalFilter)args[1];
            return new Disjunction(subSources, filter);
        });

        public Disjunction(List<IntervalsSourceProvider> subSources, IntervalFilter filter) {
            this.subSources = subSources;
            this.filter = filter;
        }

        public Disjunction(StreamInput in) throws IOException {
            this.subSources = in.readNamedWriteableList(IntervalsSourceProvider.class);
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
        }

        @Override
        public IntervalsSource getSource(QueryShardContext ctx, MappedFieldType fieldType) throws IOException {
            ArrayList<IntervalsSource> sources = new ArrayList<IntervalsSource>();
            for (IntervalsSourceProvider provider : this.subSources) {
                sources.add(provider.getSource(ctx, fieldType));
            }
            IntervalsSource source = Intervals.or(sources.toArray(new IntervalsSource[0]));
            if (this.filter == null) {
                return source;
            }
            return this.filter.filter(source, ctx, fieldType);
        }

        @Override
        public void extractFields(Set<String> fields) {
            for (IntervalsSourceProvider provider : this.subSources) {
                provider.extractFields(fields);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Disjunction that = (Disjunction)o;
            return Objects.equals(this.subSources, that.subSources) && Objects.equals(this.filter, that.filter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subSources, this.filter);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeNamedWriteableList(this.subSources);
            out.writeOptionalWriteable(this.filter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.startArray("intervals");
            for (IntervalsSourceProvider provider : this.subSources) {
                builder.startObject();
                provider.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            return builder.endObject();
        }

        public static Disjunction fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        List<IntervalsSourceProvider> getSubSources() {
            return this.subSources;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> IntervalsSourceProvider.parseInnerIntervals(p), new ParseField("intervals", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
        }
    }

    public static class Combine
    extends IntervalsSourceProvider {
        public static final String NAME = "all_of";
        private final List<IntervalsSourceProvider> subSources;
        private final IntervalMode mode;
        private final int maxGaps;
        private final IntervalFilter filter;
        static final ConstructingObjectParser<Combine, Void> PARSER = new ConstructingObjectParser("all_of", args -> {
            Boolean ordered = (Boolean)args[0];
            String mode = (String)args[1];
            List subSources = (List)args[2];
            Integer maxGaps = args[3] == null ? -1 : (Integer)args[3];
            IntervalFilter filter = (IntervalFilter)args[4];
            IntervalMode intervalMode = ordered != null ? (ordered != false ? IntervalMode.ORDERED : IntervalMode.UNORDERED) : (mode != null ? IntervalMode.fromString(mode) : IntervalMode.UNORDERED);
            return new Combine(subSources, intervalMode, maxGaps, filter);
        });

        public Combine(List<IntervalsSourceProvider> subSources, IntervalMode mode, int maxGaps, IntervalFilter filter) {
            this.subSources = subSources;
            this.mode = mode;
            this.maxGaps = maxGaps;
            this.filter = filter;
        }

        public Combine(StreamInput in) throws IOException {
            this.mode = IntervalMode.readFromStream(in);
            this.subSources = in.readNamedWriteableList(IntervalsSourceProvider.class);
            this.maxGaps = in.readInt();
            this.filter = in.readOptionalWriteable(IntervalFilter::new);
        }

        @Override
        public IntervalsSource getSource(QueryShardContext ctx, MappedFieldType fieldType) throws IOException {
            ArrayList<IntervalsSource> ss = new ArrayList<IntervalsSource>();
            for (IntervalsSourceProvider provider : this.subSources) {
                ss.add(provider.getSource(ctx, fieldType));
            }
            IntervalsSource source = IntervalBuilder.combineSources(ss, this.maxGaps, this.mode);
            if (this.filter != null) {
                return this.filter.filter(source, ctx, fieldType);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            for (IntervalsSourceProvider provider : this.subSources) {
                provider.extractFields(fields);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Combine combine = (Combine)o;
            return Objects.equals(this.subSources, combine.subSources) && this.mode == combine.mode && this.maxGaps == combine.maxGaps && Objects.equals(this.filter, combine.filter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subSources, this.mode, this.maxGaps, this.filter);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.mode.writeTo(out);
            out.writeNamedWriteableList(this.subSources);
            out.writeInt(this.maxGaps);
            out.writeOptionalWriteable(this.filter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("mode", this.mode);
            builder.field("max_gaps", this.maxGaps);
            builder.startArray("intervals");
            for (IntervalsSourceProvider provider : this.subSources) {
                builder.startObject();
                provider.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.filter != null) {
                builder.field("filter", this.filter);
            }
            return builder.endObject();
        }

        public static Combine fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        List<IntervalsSourceProvider> getSubSources() {
            return this.subSources;
        }

        IntervalMode getMode() {
            return this.mode;
        }

        int getMaxGaps() {
            return this.maxGaps;
        }

        IntervalFilter getFilter() {
            return this.filter;
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("ordered", new String[0]).withAllDeprecated());
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("mode", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> IntervalsSourceProvider.parseInnerIntervals(p), new ParseField("intervals", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_gaps", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> IntervalFilter.fromXContent(p), new ParseField("filter", new String[0]));
        }
    }

    public static class Prefix
    extends IntervalsSourceProvider {
        public static final String NAME = "prefix";
        private final String prefix;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Prefix, Void> PARSER = new ConstructingObjectParser("prefix", args -> {
            String term = (String)args[0];
            String analyzer = (String)args[1];
            String useField = (String)args[2];
            return new Prefix(term, analyzer, useField);
        });

        public Prefix(String prefix, String analyzer, String useField) {
            this.prefix = prefix;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Prefix(StreamInput in) throws IOException {
            this.prefix = in.readString();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(QueryShardContext context, MappedFieldType fieldType) throws IOException {
            IntervalsSource source;
            NamedAnalyzer analyzer = null;
            if (this.analyzer != null) {
                analyzer = context.getMapperService().getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = context.fieldMapper(this.useField);
                assert (fieldType != null);
                source = Intervals.fixField(this.useField, fieldType.intervals(this.prefix, 0, IntervalMode.UNORDERED, analyzer, true));
            } else {
                source = fieldType.intervals(this.prefix, 0, IntervalMode.UNORDERED, analyzer, true);
            }
            return source;
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Prefix prefix = (Prefix)o;
            return Objects.equals(this.prefix, prefix.prefix) && Objects.equals(this.analyzer, prefix.analyzer) && Objects.equals(this.useField, prefix.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.prefix, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.prefix);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field(NAME, this.prefix);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Prefix fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPrefix() {
            return this.prefix;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(NAME, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class Wildcard
    extends IntervalsSourceProvider {
        public static final String NAME = "wildcard";
        private final String pattern;
        private final String analyzer;
        private final String useField;
        private final Integer maxExpansions;
        private static final ConstructingObjectParser<Wildcard, Void> PARSER = new ConstructingObjectParser("wildcard", args -> {
            String term = (String)args[0];
            String analyzer = (String)args[1];
            String useField = (String)args[2];
            Integer maxExpansions = (Integer)args[3];
            return new Wildcard(term, analyzer, useField, maxExpansions);
        });

        public Wildcard(String pattern, String analyzer, String useField, Integer maxExpansions) {
            this.pattern = pattern;
            this.analyzer = analyzer;
            this.useField = useField;
            this.maxExpansions = maxExpansions != null && maxExpansions > 0 ? maxExpansions : null;
        }

        public Wildcard(StreamInput in) throws IOException {
            this.pattern = in.readString();
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
            this.maxExpansions = in.readOptionalVInt();
        }

        @Override
        public IntervalsSource getSource(QueryShardContext context, MappedFieldType fieldType) {
            IntervalsSource source;
            NamedAnalyzer analyzer = fieldType.getTextSearchInfo().getSearchAnalyzer();
            if (this.analyzer != null) {
                analyzer = context.getMapperService().getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = context.fieldMapper(this.useField);
                assert (fieldType != null);
                this.checkPositions(fieldType);
                if (this.analyzer == null) {
                    analyzer = fieldType.getTextSearchInfo().getSearchAnalyzer();
                }
                BytesRef normalizedTerm = analyzer.normalize(this.useField, this.pattern);
                IntervalsSource wildcardSource = this.maxExpansions == null ? Intervals.wildcard(normalizedTerm) : Intervals.wildcard(normalizedTerm, this.maxExpansions);
                source = Intervals.fixField(this.useField, wildcardSource);
            } else {
                this.checkPositions(fieldType);
                BytesRef normalizedTerm = analyzer.normalize(fieldType.name(), this.pattern);
                source = this.maxExpansions == null ? Intervals.wildcard(normalizedTerm) : Intervals.wildcard(normalizedTerm, this.maxExpansions);
            }
            return source;
        }

        private void checkPositions(MappedFieldType type) {
            if (!type.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + type.name() + "] with no positions indexed");
            }
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Wildcard wildcard = (Wildcard)o;
            return Objects.equals(this.pattern, wildcard.pattern) && Objects.equals(this.analyzer, wildcard.analyzer) && Objects.equals(this.useField, wildcard.useField) && Objects.equals(this.maxExpansions, wildcard.maxExpansions);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.analyzer, this.useField, this.maxExpansions);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
            out.writeOptionalVInt(this.maxExpansions);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("pattern", this.pattern);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            if (this.maxExpansions != null) {
                builder.field("max_expansions", this.maxExpansions);
            }
            builder.endObject();
            return builder;
        }

        public static Wildcard fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPattern() {
            return this.pattern;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        Integer getMaxExpansions() {
            return this.maxExpansions;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("pattern", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_expansions", new String[0]));
        }
    }

    public static class Regexp
    extends IntervalsSourceProvider {
        public static final String NAME = "regexp";
        public static final int DEFAULT_FLAGS_VALUE = RegexpFlag.ALL.value();
        private final String pattern;
        private final int flags;
        private final String useField;
        private final Integer maxExpansions;
        private final boolean caseInsensitive;
        private static final ConstructingObjectParser<Regexp, Void> PARSER = new ConstructingObjectParser("regexp", args -> {
            boolean caseInsensitive;
            String pattern = (String)args[0];
            String flags = (String)args[1];
            Integer flagsValue = (Integer)args[2];
            String useField = (String)args[3];
            Integer maxExpansions = (Integer)args[4];
            boolean bl = caseInsensitive = args[5] != null && (Boolean)args[5] != false;
            if (flagsValue != null) {
                return new Regexp(pattern, flagsValue, useField, maxExpansions, caseInsensitive);
            }
            if (flags != null) {
                return new Regexp(pattern, RegexpFlag.resolveValue(flags), useField, maxExpansions, caseInsensitive);
            }
            return new Regexp(pattern, DEFAULT_FLAGS_VALUE, useField, maxExpansions, caseInsensitive);
        });

        public Regexp(String pattern, int flags, String useField, Integer maxExpansions, boolean caseInsensitive) {
            this.pattern = pattern;
            this.flags = flags;
            this.useField = useField;
            this.maxExpansions = maxExpansions != null && maxExpansions > 0 ? maxExpansions : null;
            this.caseInsensitive = caseInsensitive;
        }

        public Regexp(StreamInput in) throws IOException {
            this.pattern = in.readString();
            this.flags = in.readVInt();
            this.useField = in.readOptionalString();
            this.maxExpansions = in.readOptionalVInt();
            this.caseInsensitive = in.readBoolean();
        }

        @Override
        public IntervalsSource getSource(QueryShardContext context, MappedFieldType fieldType) {
            RegExp regexp = new RegExp(this.pattern, this.flags, this.caseInsensitive ? 256 : 0);
            Automaton automaton = Operations.determinize(regexp.toAutomaton(), 10000);
            CompiledAutomaton compiledAutomaton = new CompiledAutomaton(automaton);
            if (this.useField != null) {
                fieldType = context.fieldMapper(this.useField);
                assert (fieldType != null);
                this.checkPositions(fieldType);
                IntervalsSource regexpSource = this.maxExpansions == null ? Intervals.multiterm(compiledAutomaton, regexp.toString()) : Intervals.multiterm(compiledAutomaton, this.maxExpansions, regexp.toString());
                return Intervals.fixField(this.useField, regexpSource);
            }
            this.checkPositions(fieldType);
            return this.maxExpansions == null ? Intervals.multiterm(compiledAutomaton, regexp.toString()) : Intervals.multiterm(compiledAutomaton, this.maxExpansions, regexp.toString());
        }

        private void checkPositions(MappedFieldType type) {
            if (!type.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + type.name() + "] with no positions indexed");
            }
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Regexp regexp = (Regexp)o;
            return Objects.equals(this.pattern, regexp.pattern) && Objects.equals(this.flags, regexp.flags) && Objects.equals(this.useField, regexp.useField) && Objects.equals(this.maxExpansions, regexp.maxExpansions) && Objects.equals(this.caseInsensitive, regexp.caseInsensitive);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.flags, this.useField, this.maxExpansions, this.caseInsensitive);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
            out.writeVInt(this.flags);
            out.writeOptionalString(this.useField);
            out.writeOptionalVInt(this.maxExpansions);
            out.writeBoolean(this.caseInsensitive);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("pattern", this.pattern);
            if (this.flags != DEFAULT_FLAGS_VALUE) {
                builder.field("flags_value", this.flags);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            if (this.maxExpansions != null) {
                builder.field("max_expansions", this.maxExpansions);
            }
            if (this.caseInsensitive) {
                builder.field("case_insensitive", this.caseInsensitive);
            }
            builder.endObject();
            return builder;
        }

        public static Regexp fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getPattern() {
            return this.pattern;
        }

        int getFlags() {
            return this.flags;
        }

        String getUseField() {
            return this.useField;
        }

        Integer getMaxExpansions() {
            return this.maxExpansions;
        }

        boolean isCaseInsensitive() {
            return this.caseInsensitive;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("pattern", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("flags", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("flags_value", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_expansions", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("case_insensitive", new String[0]));
        }
    }

    public static class Fuzzy
    extends IntervalsSourceProvider {
        public static final String NAME = "fuzzy";
        private final String term;
        private final int prefixLength;
        private final boolean transpositions;
        private final Fuzziness fuzziness;
        private final String analyzer;
        private final String useField;
        private static final ConstructingObjectParser<Fuzzy, Void> PARSER = new ConstructingObjectParser("fuzzy", args -> {
            String term = (String)args[0];
            int prefixLength = args[1] == null ? 0 : (Integer)args[1];
            boolean transpositions = args[2] == null ? true : (Boolean)args[2];
            Fuzziness fuzziness = args[3] == null ? FuzzyQueryBuilder.DEFAULT_FUZZINESS : (Fuzziness)args[3];
            String analyzer = (String)args[4];
            String useField = (String)args[5];
            return new Fuzzy(term, prefixLength, transpositions, fuzziness, analyzer, useField);
        });

        public Fuzzy(String term, int prefixLength, boolean transpositions, Fuzziness fuzziness, String analyzer, String useField) {
            this.term = term;
            this.prefixLength = prefixLength;
            this.transpositions = transpositions;
            this.fuzziness = fuzziness;
            this.analyzer = analyzer;
            this.useField = useField;
        }

        public Fuzzy(StreamInput in) throws IOException {
            this.term = in.readString();
            this.prefixLength = in.readVInt();
            this.transpositions = in.readBoolean();
            this.fuzziness = new Fuzziness(in);
            this.analyzer = in.readOptionalString();
            this.useField = in.readOptionalString();
        }

        @Override
        public IntervalsSource getSource(QueryShardContext context, MappedFieldType fieldType) {
            NamedAnalyzer analyzer = fieldType.getTextSearchInfo().getSearchAnalyzer();
            if (this.analyzer != null) {
                analyzer = context.getMapperService().getIndexAnalyzers().get(this.analyzer);
            }
            if (this.useField != null) {
                fieldType = context.fieldMapper(this.useField);
                assert (fieldType != null);
                this.checkPositions(fieldType);
                if (this.analyzer == null) {
                    analyzer = fieldType.getTextSearchInfo().getSearchAnalyzer();
                }
            }
            this.checkPositions(fieldType);
            BytesRef normalizedTerm = analyzer.normalize(fieldType.name(), this.term);
            FuzzyQuery fq = new FuzzyQuery(new Term(fieldType.name(), normalizedTerm), this.fuzziness.asDistance(this.term), this.prefixLength, 128, this.transpositions);
            IntervalsSource source = Intervals.multiterm(fq.getAutomata(), this.term);
            if (this.useField != null) {
                source = Intervals.fixField(this.useField, source);
            }
            return source;
        }

        private void checkPositions(MappedFieldType type) {
            if (!type.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + type.name() + "] with no positions indexed");
            }
        }

        @Override
        public void extractFields(Set<String> fields) {
            if (this.useField != null) {
                fields.add(this.useField);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fuzzy fuzzy = (Fuzzy)o;
            return this.prefixLength == fuzzy.prefixLength && this.transpositions == fuzzy.transpositions && Objects.equals(this.term, fuzzy.term) && Objects.equals(this.fuzziness, fuzzy.fuzziness) && Objects.equals(this.analyzer, fuzzy.analyzer) && Objects.equals(this.useField, fuzzy.useField);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.term, this.prefixLength, this.transpositions, this.fuzziness, this.analyzer, this.useField);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeVInt(this.prefixLength);
            out.writeBoolean(this.transpositions);
            this.fuzziness.writeTo(out);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalString(this.useField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(NAME);
            builder.field("term", this.term);
            builder.field("prefix_length", this.prefixLength);
            builder.field("transpositions", this.transpositions);
            this.fuzziness.toXContent(builder, params);
            if (this.analyzer != null) {
                builder.field("analyzer", this.analyzer);
            }
            if (this.useField != null) {
                builder.field("use_field", this.useField);
            }
            builder.endObject();
            return builder;
        }

        public static Fuzzy fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        String getTerm() {
            return this.term;
        }

        int getPrefixLength() {
            return this.prefixLength;
        }

        boolean isTranspositions() {
            return this.transpositions;
        }

        Fuzziness getFuzziness() {
            return this.fuzziness;
        }

        String getAnalyzer() {
            return this.analyzer;
        }

        String getUseField() {
            return this.useField;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("term", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("prefix_length", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("transpositions", new String[0]));
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Fuzziness.parse(p), Fuzziness.FIELD, ObjectParser.ValueType.VALUE);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("analyzer", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("use_field", new String[0]));
        }
    }

    public static class IntervalFilter
    implements ToXContentObject,
    Writeable {
        public static final String NAME = "filter";
        private final String type;
        private final IntervalsSourceProvider filter;
        private final Script script;

        public IntervalFilter(IntervalsSourceProvider filter, String type) {
            this.filter = filter;
            this.type = type.toLowerCase(Locale.ROOT);
            this.script = null;
        }

        IntervalFilter(Script script) {
            this.script = script;
            this.type = "script";
            this.filter = null;
        }

        public IntervalFilter(StreamInput in) throws IOException {
            this.type = in.readString();
            this.filter = in.readOptionalNamedWriteable(IntervalsSourceProvider.class);
            this.script = in.readBoolean() ? new Script(in) : null;
        }

        public IntervalsSource filter(IntervalsSource input, QueryShardContext context, MappedFieldType fieldType) throws IOException {
            if (this.script != null) {
                IntervalFilterScript ifs = context.compile(this.script, IntervalFilterScript.CONTEXT).newInstance();
                return new ScriptFilterSource(input, this.script.getIdOrCode(), ifs);
            }
            IntervalsSource filterSource = this.filter.getSource(context, fieldType);
            switch (this.type) {
                case "containing": {
                    return Intervals.containing(input, filterSource);
                }
                case "contained_by": {
                    return Intervals.containedBy(input, filterSource);
                }
                case "not_containing": {
                    return Intervals.notContaining(input, filterSource);
                }
                case "not_contained_by": {
                    return Intervals.notContainedBy(input, filterSource);
                }
                case "overlapping": {
                    return Intervals.overlapping(input, filterSource);
                }
                case "not_overlapping": {
                    return Intervals.nonOverlapping(input, filterSource);
                }
                case "before": {
                    return Intervals.before(input, filterSource);
                }
                case "after": {
                    return Intervals.after(input, filterSource);
                }
            }
            throw new IllegalArgumentException("Unknown filter type [" + this.type + "]");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntervalFilter that = (IntervalFilter)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.script, that.script) && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.filter, this.script);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeOptionalNamedWriteable(this.filter);
            if (this.script == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.script.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.filter != null) {
                builder.startObject(this.type);
                this.filter.toXContent(builder, params);
                builder.endObject();
            } else {
                builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
            }
            builder.endObject();
            return builder;
        }

        public static IntervalFilter fromXContent(XContentParser parser) throws IOException {
            if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            String type = parser.currentName();
            if (Script.SCRIPT_PARSE_FIELD.match(type, parser.getDeprecationHandler())) {
                Script script = Script.parse(parser);
                if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
                }
                return new IntervalFilter(script);
            }
            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            IntervalsSourceProvider intervals = IntervalsSourceProvider.fromXContent(parser);
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
            }
            return new IntervalFilter(intervals, type);
        }

        String getType() {
            return this.type;
        }

        IntervalsSourceProvider getFilter() {
            return this.filter;
        }

        Script getScript() {
            return this.script;
        }
    }

    static class ScriptFilterSource
    extends FilteredIntervalsSource {
        final IntervalFilterScript script;
        IntervalFilterScript.Interval interval = new IntervalFilterScript.Interval();

        ScriptFilterSource(IntervalsSource in, String name, IntervalFilterScript script) {
            super("FILTER(" + name + ")", in);
            this.script = script;
        }

        @Override
        protected boolean accept(IntervalIterator it) {
            this.interval.setIterator(it);
            return this.script.execute(this.interval);
        }
    }
}

