/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.IndexInput;

public class RemoteIndexInput
extends IndexInput {
    private final InputStream inputStream;
    private final long size;
    private long filePointer;

    public RemoteIndexInput(String name, InputStream inputStream, long size) {
        super(name);
        this.inputStream = inputStream;
        this.size = size;
        this.filePointer = 0L;
    }

    @Override
    public byte readByte() throws IOException {
        byte[] buffer = new byte[1];
        int numberOfBytesRead = this.inputStream.read(buffer);
        if (numberOfBytesRead != -1) {
            this.filePointer += (long)numberOfBytesRead;
        }
        return buffer[0];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int bytesRead = this.inputStream.read(b, offset, len);
        if (bytesRead == len) {
            this.filePointer += (long)bytesRead;
        } else {
            while (bytesRead > 0 && bytesRead < len) {
                this.filePointer += (long)bytesRead;
                bytesRead = this.inputStream.read(b, offset += bytesRead, len -= bytesRead);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getFilePointer() {
        return this.filePointer;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

