/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.opensearch.core.common.io.stream.BufferedChecksumStreamInput;
import org.opensearch.core.common.io.stream.ByteBufferStreamInput;
import org.opensearch.index.translog.Checkpoint;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogCorruptedException;
import org.opensearch.index.translog.TranslogHeader;
import org.opensearch.index.translog.TranslogSnapshot;

public abstract class BaseTranslogReader
implements Comparable<BaseTranslogReader> {
    protected final long generation;
    protected final FileChannel channel;
    protected final Path path;
    protected final TranslogHeader header;

    public BaseTranslogReader(long generation, FileChannel channel, Path path, TranslogHeader header) {
        assert (Translog.parseIdFromFileName(path) == generation) : "generation mismatch. Path: " + Translog.parseIdFromFileName(path) + " but generation: " + generation;
        this.generation = generation;
        this.path = path;
        this.channel = channel;
        this.header = header;
    }

    public long getGeneration() {
        return this.generation;
    }

    public abstract long sizeInBytes();

    public abstract int totalOperations();

    abstract Checkpoint getCheckpoint();

    public final long getFirstOperationOffset() {
        return this.header.sizeInBytes();
    }

    public final long getPrimaryTerm() {
        return this.header.getPrimaryTerm();
    }

    protected final int readSize(ByteBuffer reusableBuffer, long position) throws IOException {
        assert (reusableBuffer.capacity() >= 4) : "reusable buffer must have capacity >=4 when reading opSize. got [" + reusableBuffer.capacity() + "]";
        reusableBuffer.clear();
        reusableBuffer.limit(4);
        this.readBytes(reusableBuffer, position);
        reusableBuffer.flip();
        int size = reusableBuffer.getInt() + 4;
        long maxSize = this.sizeInBytes() - position;
        if (size < 0 || (long)size > maxSize) {
            throw new TranslogCorruptedException(this.path.toString(), "operation size is corrupted must be [0.." + maxSize + "] but was: " + size);
        }
        return size;
    }

    TranslogSnapshot newSnapshot() {
        return new TranslogSnapshot(this, this.sizeInBytes());
    }

    protected final BufferedChecksumStreamInput checksummedStream(ByteBuffer reusableBuffer, long position, int opSize, BufferedChecksumStreamInput reuse) throws IOException {
        ByteBuffer buffer = reusableBuffer.capacity() >= opSize ? reusableBuffer : ByteBuffer.allocate(opSize);
        buffer.clear();
        buffer.limit(opSize);
        this.readBytes(buffer, position);
        buffer.flip();
        return new BufferedChecksumStreamInput(new ByteBufferStreamInput(buffer), this.path.toString(), reuse);
    }

    protected Translog.Operation read(BufferedChecksumStreamInput inStream) throws IOException {
        Translog.Operation op = Translog.readOperation(inStream);
        if (op.primaryTerm() > this.getPrimaryTerm() && this.getPrimaryTerm() != 0L) {
            throw new TranslogCorruptedException(this.path.toString(), "operation's term is newer than translog header term; operation term[" + op.primaryTerm() + "], translog header term [" + this.getPrimaryTerm() + "]");
        }
        return op;
    }

    protected abstract void readBytes(ByteBuffer var1, long var2) throws IOException;

    public String toString() {
        return "translog [" + this.generation + "][" + String.valueOf(this.path) + "]";
    }

    @Override
    public int compareTo(BaseTranslogReader o) {
        return Long.compare(this.getGeneration(), o.getGeneration());
    }

    public Path path() {
        return this.path;
    }

    public long getLastModifiedTime() throws IOException {
        return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
    }

    Translog.Operation read(Translog.Location location) throws IOException {
        assert (location.generation == this.generation) : "generation mismatch expected: " + this.generation + " got: " + location.generation;
        ByteBuffer buffer = ByteBuffer.allocate(location.size);
        return this.read(this.checksummedStream(buffer, location.translogLocation, location.size, null));
    }
}

