/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardRelocatedException;

public final class RunUnderPrimaryPermit {
    public static void run(CancellableThreads.Interruptible runnable, String reason, IndexShard primary, CancellableThreads cancellableThreads, Logger logger) {
        cancellableThreads.execute(() -> {
            final CompletableFuture permit = new CompletableFuture();
            ActionListener<Releasable> onAcquired = new ActionListener<Releasable>(){

                @Override
                public void onResponse(Releasable releasable) {
                    if (!permit.complete(releasable)) {
                        releasable.close();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    permit.completeExceptionally(e);
                }
            };
            primary.acquirePrimaryOperationPermit(onAcquired, "same", reason);
            try (Releasable ignored = (Releasable)FutureUtils.get(permit);){
                if (primary.isRelocatedPrimary()) {
                    throw new IndexShardRelocatedException(primary.shardId());
                }
                runnable.run();
            }
            finally {
                permit.whenComplete((r, e) -> {
                    if (r != null) {
                        r.close();
                    }
                    if (e != null) {
                        logger.trace("suppressing exception on completion (it was already bubbled up or the operation was aborted)", e);
                    }
                });
            }
        });
    }
}

