/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.RequestUtils;
import org.opensearch.core.common.Strings;
import org.opensearch.index.IngestionShardConsumer;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.indices.pollingingest.IngestionErrorStrategy;
import org.opensearch.indices.pollingingest.IngestionUtils;
import org.opensearch.indices.pollingingest.MessageProcessorRunnable;
import org.opensearch.indices.pollingingest.ShardUpdateMessage;

public class PartitionedBlockingQueueContainer {
    private static final Logger logger = LogManager.getLogger(PartitionedBlockingQueueContainer.class);
    private final int numPartitions;
    private final Map<Integer, BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>>> partitionToQueueMap;
    private final Map<Integer, MessageProcessorRunnable> partitionToMessageProcessorMap;
    private final Map<Integer, ExecutorService> partitionToProcessorExecutorMap;

    public PartitionedBlockingQueueContainer(int numPartitions, int shardId, IngestionEngine ingestionEngine, IngestionErrorStrategy errorStrategy, int blockingQueueSize) {
        assert (numPartitions > 0) : "Number of processor threads / partitions must be greater than 0";
        this.partitionToQueueMap = new ConcurrentHashMap<Integer, BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>>>();
        this.partitionToMessageProcessorMap = new ConcurrentHashMap<Integer, MessageProcessorRunnable>();
        this.partitionToProcessorExecutorMap = new ConcurrentHashMap<Integer, ExecutorService>();
        this.numPartitions = numPartitions;
        logger.info("Initializing processors for shard {} using {} partitions", (Object)shardId, (Object)numPartitions);
        String processorThreadNamePrefix = String.format(Locale.ROOT, "stream-poller-processor-shard-%d-%d", shardId, System.currentTimeMillis());
        for (int partition = 0; partition < numPartitions; ++partition) {
            String processorThreadName = String.format(Locale.ROOT, "%s-partition-%d", processorThreadNamePrefix, partition);
            ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, String.format(Locale.ROOT, processorThreadName, new Object[0])));
            this.partitionToProcessorExecutorMap.put(partition, executorService);
            this.partitionToQueueMap.put(partition, new ArrayBlockingQueue(blockingQueueSize));
            MessageProcessorRunnable messageProcessorRunnable = new MessageProcessorRunnable(this.partitionToQueueMap.get(partition), ingestionEngine, errorStrategy);
            this.partitionToMessageProcessorMap.put(partition, messageProcessorRunnable);
        }
    }

    PartitionedBlockingQueueContainer(MessageProcessorRunnable messageProcessorRunnable, int shardId) {
        this.partitionToQueueMap = new ConcurrentHashMap<Integer, BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>>>();
        this.partitionToMessageProcessorMap = new ConcurrentHashMap<Integer, MessageProcessorRunnable>();
        this.partitionToProcessorExecutorMap = new ConcurrentHashMap<Integer, ExecutorService>();
        this.numPartitions = 1;
        this.partitionToQueueMap.put(0, messageProcessorRunnable.getBlockingQueue());
        this.partitionToMessageProcessorMap.put(0, messageProcessorRunnable);
        ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, String.format(Locale.ROOT, String.format(Locale.ROOT, "stream-poller-processor-shard-%d-%d-partition-0", shardId, System.currentTimeMillis()), new Object[0])));
        this.partitionToProcessorExecutorMap.put(0, executorService);
    }

    public void startProcessorThreads() {
        for (int partition = 0; partition < this.numPartitions; ++partition) {
            ExecutorService executorService = this.partitionToProcessorExecutorMap.get(partition);
            MessageProcessorRunnable messageProcessorRunnable = this.partitionToMessageProcessorMap.get(partition);
            executorService.submit(messageProcessorRunnable);
        }
    }

    public void add(IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message> readResult) throws InterruptedException {
        String id;
        Map<String, Object> payloadMap = IngestionUtils.getParsedPayloadMap((byte[])readResult.getMessage().getPayload());
        long autoGeneratedIdTimestamp = -1L;
        if (payloadMap.containsKey("_id")) {
            id = (String)payloadMap.get("_id");
        } else {
            id = RequestUtils.generateID();
            payloadMap.put("_id", id);
            autoGeneratedIdTimestamp = System.currentTimeMillis();
        }
        ShardUpdateMessage<IngestionShardPointer, Message> updateMessage = new ShardUpdateMessage<IngestionShardPointer, Message>(readResult.getPointer(), readResult.getMessage(), payloadMap, autoGeneratedIdTimestamp);
        int partition = this.getPartitionFromID(id);
        this.partitionToQueueMap.get(partition).put(updateMessage);
    }

    public void close() {
        this.partitionToMessageProcessorMap.values().forEach(MessageProcessorRunnable::close);
        this.partitionToProcessorExecutorMap.values().forEach(ExecutorService::shutdown);
        this.partitionToQueueMap.clear();
        this.partitionToMessageProcessorMap.clear();
        this.partitionToProcessorExecutorMap.clear();
    }

    public MessageProcessorRunnable.MessageProcessorMetrics getMessageProcessorMetrics() {
        return this.partitionToMessageProcessorMap.values().stream().map(MessageProcessorRunnable::getMessageProcessorMetrics).reduce(MessageProcessorRunnable.MessageProcessorMetrics::combine).orElseGet(MessageProcessorRunnable.MessageProcessorMetrics::create);
    }

    public void updateErrorStrategy(IngestionErrorStrategy errorStrategy) {
        this.partitionToMessageProcessorMap.values().forEach(messageProcessor -> messageProcessor.setErrorStrategy(errorStrategy));
    }

    public List<IngestionShardPointer> getCurrentShardPointers() {
        return this.partitionToMessageProcessorMap.values().stream().map(MessageProcessorRunnable::getCurrentShardPointer).toList();
    }

    private int getPartitionFromID(String id) {
        if (Strings.isEmpty(id)) {
            return 0;
        }
        return Math.floorMod(id.hashCode(), this.numPartitions);
    }

    Map<Integer, MessageProcessorRunnable> getPartitionToMessageProcessorMap() {
        return this.partitionToMessageProcessorMap;
    }

    Map<Integer, ExecutorService> getPartitionToProcessorExecutorMap() {
        return this.partitionToProcessorExecutorMap;
    }

    Map<Integer, BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>>> getPartitionToQueueMap() {
        return this.partitionToQueueMap;
    }
}

