/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class PollingIngestStats
implements Writeable,
ToXContentFragment {
    private final MessageProcessorStats messageProcessorStats;
    private final ConsumerStats consumerStats;

    public PollingIngestStats(MessageProcessorStats messageProcessorStats, ConsumerStats consumerStats) {
        this.messageProcessorStats = messageProcessorStats;
        this.consumerStats = consumerStats;
    }

    public PollingIngestStats(StreamInput in) throws IOException {
        long totalProcessedCount = in.readLong();
        long totalInvalidMessageCount = in.readLong();
        long totalProcessorVersionConflictsCount = in.readLong();
        long totalProcessorFailedCount = in.readLong();
        long totalProcessorFailuresDroppedCount = in.readLong();
        long totalProcessorThreadInterruptCount = in.readLong();
        this.messageProcessorStats = new MessageProcessorStats(totalProcessedCount, totalInvalidMessageCount, totalProcessorVersionConflictsCount, totalProcessorFailedCount, totalProcessorFailuresDroppedCount, totalProcessorThreadInterruptCount);
        long totalPolledCount = in.readLong();
        long lagInMillis = in.readLong();
        long totalConsumerErrorCount = in.readLong();
        long totalPollerMessageFailureCount = in.readLong();
        long totalPollerMessageDroppedCount = in.readLong();
        long totalDuplicateMessageSkippedCount = in.readLong();
        this.consumerStats = new ConsumerStats(totalPolledCount, lagInMillis, totalConsumerErrorCount, totalPollerMessageFailureCount, totalPollerMessageDroppedCount, totalDuplicateMessageSkippedCount);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.messageProcessorStats.totalProcessedCount);
        out.writeLong(this.messageProcessorStats.totalInvalidMessageCount);
        out.writeLong(this.messageProcessorStats.totalVersionConflictsCount);
        out.writeLong(this.messageProcessorStats.totalFailedCount);
        out.writeLong(this.messageProcessorStats.totalFailuresDroppedCount);
        out.writeLong(this.messageProcessorStats.totalProcessorThreadInterruptCount);
        out.writeLong(this.consumerStats.totalPolledCount);
        out.writeLong(this.consumerStats.lagInMillis);
        out.writeLong(this.consumerStats.totalConsumerErrorCount);
        out.writeLong(this.consumerStats.totalPollerMessageFailureCount);
        out.writeLong(this.consumerStats.totalPollerMessageDroppedCount);
        out.writeLong(this.consumerStats.totalDuplicateMessageSkippedCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("polling_ingest_stats");
        builder.startObject("message_processor_stats");
        builder.field("total_processed_count", this.messageProcessorStats.totalProcessedCount);
        builder.field("total_invalid_message_count", this.messageProcessorStats.totalInvalidMessageCount);
        builder.field("total_version_conflicts_count", this.messageProcessorStats.totalVersionConflictsCount);
        builder.field("total_failed_count", this.messageProcessorStats.totalFailedCount);
        builder.field("total_failures_dropped_count", this.messageProcessorStats.totalFailuresDroppedCount);
        builder.field("total_processor_thread_interrupt_count", this.messageProcessorStats.totalProcessorThreadInterruptCount);
        builder.endObject();
        builder.startObject("consumer_stats");
        builder.field("total_polled_count", this.consumerStats.totalPolledCount);
        builder.field("total_consumer_error_count", this.consumerStats.totalConsumerErrorCount);
        builder.field("total_poller_message_failure_count", this.consumerStats.totalPollerMessageFailureCount);
        builder.field("total_poller_message_dropped_count", this.consumerStats.totalPollerMessageDroppedCount);
        builder.field("total_duplicate_message_skipped_count", this.consumerStats.totalDuplicateMessageSkippedCount);
        builder.field("lag_in_millis", this.consumerStats.lagInMillis);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public MessageProcessorStats getMessageProcessorStats() {
        return this.messageProcessorStats;
    }

    public ConsumerStats getConsumerStats() {
        return this.consumerStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingIngestStats)) {
            return false;
        }
        PollingIngestStats that = (PollingIngestStats)o;
        return Objects.equals(this.messageProcessorStats, that.messageProcessorStats) && Objects.equals(this.consumerStats, that.consumerStats);
    }

    public int hashCode() {
        return Objects.hash(this.messageProcessorStats, this.consumerStats);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public record MessageProcessorStats(long totalProcessedCount, long totalInvalidMessageCount, long totalVersionConflictsCount, long totalFailedCount, long totalFailuresDroppedCount, long totalProcessorThreadInterruptCount) {
    }

    @ExperimentalApi
    public record ConsumerStats(long totalPolledCount, long lagInMillis, long totalConsumerErrorCount, long totalPollerMessageFailureCount, long totalPollerMessageDroppedCount, long totalDuplicateMessageSkippedCount) {
    }

    @ExperimentalApi
    public static class Builder {
        private long totalProcessedCount;
        private long totalInvalidMessageCount;
        private long totalPolledCount;
        private long totalVersionConflictsCount;
        private long totalFailedCount;
        private long totalFailuresDroppedCount;
        private long totalProcessorThreadInterruptCount;
        private long lagInMillis;
        private long totalConsumerErrorCount;
        private long totalPollerMessageFailureCount;
        private long totalPollerMessageDroppedCount;
        private long totalDuplicateMessageSkippedCount;

        public Builder setTotalProcessedCount(long totalProcessedCount) {
            this.totalProcessedCount = totalProcessedCount;
            return this;
        }

        public Builder setTotalPolledCount(long totalPolledCount) {
            this.totalPolledCount = totalPolledCount;
            return this;
        }

        public Builder setTotalInvalidMessageCount(long totalInvalidMessageCount) {
            this.totalInvalidMessageCount = totalInvalidMessageCount;
            return this;
        }

        public Builder setTotalProcessorVersionConflictsCount(long totalVersionConflictsCount) {
            this.totalVersionConflictsCount = totalVersionConflictsCount;
            return this;
        }

        public Builder setTotalProcessorFailedCount(long totalFailedCount) {
            this.totalFailedCount = totalFailedCount;
            return this;
        }

        public Builder setTotalProcessorFailuresDroppedCount(long totalFailuresDroppedCount) {
            this.totalFailuresDroppedCount = totalFailuresDroppedCount;
            return this;
        }

        public Builder setTotalProcessorThreadInterruptCount(long totalProcessorThreadInterruptCount) {
            this.totalProcessorThreadInterruptCount = totalProcessorThreadInterruptCount;
            return this;
        }

        public Builder setLagInMillis(long lagInMillis) {
            this.lagInMillis = lagInMillis;
            return this;
        }

        public Builder setTotalConsumerErrorCount(long totalConsumerErrorCount) {
            this.totalConsumerErrorCount = totalConsumerErrorCount;
            return this;
        }

        public Builder setTotalPollerMessageFailureCount(long totalPollerMessageFailureCount) {
            this.totalPollerMessageFailureCount = totalPollerMessageFailureCount;
            return this;
        }

        public Builder setTotalPollerMessageDroppedCount(long totalPollerMessageDroppedCount) {
            this.totalPollerMessageDroppedCount = totalPollerMessageDroppedCount;
            return this;
        }

        public Builder setTotalDuplicateMessageSkippedCount(long totalDuplicateMessageSkippedCount) {
            this.totalDuplicateMessageSkippedCount = totalDuplicateMessageSkippedCount;
            return this;
        }

        public PollingIngestStats build() {
            MessageProcessorStats messageProcessorStats = new MessageProcessorStats(this.totalProcessedCount, this.totalInvalidMessageCount, this.totalVersionConflictsCount, this.totalFailedCount, this.totalFailuresDroppedCount, this.totalProcessorThreadInterruptCount);
            ConsumerStats consumerStats = new ConsumerStats(this.totalPolledCount, this.lagInMillis, this.totalConsumerErrorCount, this.totalPollerMessageFailureCount, this.totalPollerMessageDroppedCount, this.totalDuplicateMessageSkippedCount);
            return new PollingIngestStats(messageProcessorStats, consumerStats);
        }
    }
}

