/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.action.StepListener;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.AbstractSegmentReplicationTarget;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;

public class SegmentReplicationTarget
extends AbstractSegmentReplicationTarget {
    public static final String REPLICATION_PREFIX = "replication.";

    public SegmentReplicationTarget(IndexShard indexShard, ReplicationCheckpoint checkpoint, SegmentReplicationSource source, ReplicationListener listener) {
        super("replication_target", indexShard, checkpoint, source, listener);
    }

    @Override
    protected String getPrefix() {
        return REPLICATION_PREFIX + UUIDs.randomBase64UUID() + ".";
    }

    @Override
    protected void getCheckpointMetadata(StepListener<CheckpointInfoResponse> checkpointInfoListener) {
        this.source.getCheckpointMetadata(this.getId(), this.checkpoint, checkpointInfoListener);
    }

    @Override
    protected void updateCheckpoint(ReplicationCheckpoint checkpoint, BiConsumer<ReplicationCheckpoint, IndexShard> checkpointUpdater) {
        checkpointUpdater.accept(checkpoint, this.indexShard);
    }

    @Override
    protected void getFilesFromSource(CheckpointInfoResponse checkpointInfo, List<StoreFileMetadata> filesToFetch, StepListener<GetSegmentFilesResponse> getFilesListener) {
        this.source.getSegmentFiles(this.getId(), checkpointInfo.getCheckpoint(), filesToFetch, this.indexShard, this::updateFileRecoveryBytes, getFilesListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalizeReplication(CheckpointInfoResponse checkpointInfoResponse) throws Exception {
        if (checkpointInfoResponse.getInfosBytes() == null) {
            return;
        }
        Store store = null;
        try {
            store = this.store();
            store.incRef();
            this.multiFileWriter.renameAllTempFiles();
            SegmentInfos infos = store.buildSegmentInfos(checkpointInfoResponse.getInfosBytes(), checkpointInfoResponse.getCheckpoint().getSegmentsGen());
            this.indexShard.finalizeReplication(infos);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            try {
                try {
                    store.removeCorruptionMarker();
                }
                finally {
                    Lucene.cleanLuceneIndex(store.directory());
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to clean lucene index", (Throwable)e);
                ex.addSuppressed(e);
            }
            throw new OpenSearchCorruptionException(ex);
        }
        catch (AlreadyClosedException ex) {
            this.logger.warn("Shard is already closed, closing replication");
        }
        catch (CancellableThreads.ExecutionCancelledException ex) {
            assert (this.cancellableThreads.isCancelled()) : "Replication target cancelled but cancellable threads not cancelled";
        }
        catch (Exception ex) {
            throw new ReplicationFailedException(ex);
        }
        finally {
            if (store != null) {
                store.decRef();
            }
        }
    }

    @Override
    public SegmentReplicationTarget retryCopy() {
        return new SegmentReplicationTarget(this.indexShard, this.checkpoint, this.source, this.listener);
    }
}

