/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.node.IoUsageStats;
import org.opensearch.node.NodeResourceUsageStats;
import org.opensearch.node.NodesResourceUsageStats;
import org.opensearch.node.resource.tracker.NodeResourceUsageTracker;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class ResourceUsageCollectorService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static long REFRESH_INTERVAL_IN_MILLIS = 1000L;
    private static final Logger logger = LogManager.getLogger(ResourceUsageCollectorService.class);
    private final ConcurrentMap<String, NodeResourceUsageStats> nodeIdToResourceUsageStats = ConcurrentCollections.newConcurrentMap();
    private ThreadPool threadPool;
    private volatile Scheduler.Cancellable scheduledFuture;
    private NodeResourceUsageTracker nodeResourceUsageTracker;
    private ClusterService clusterService;

    public ResourceUsageCollectorService(NodeResourceUsageTracker nodeResourceUsageTracker, ClusterService clusterService, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.nodeResourceUsageTracker = nodeResourceUsageTracker;
        this.clusterService = clusterService;
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.removeNodeResourceUsageStats(removedNode.getId());
            }
        }
    }

    void removeNodeResourceUsageStats(String nodeId) {
        this.nodeIdToResourceUsageStats.remove(nodeId);
    }

    public void collectNodeResourceUsageStats(String nodeId, long timestamp, double memoryUtilizationPercent, double cpuUtilizationPercent, IoUsageStats ioUsageStats) {
        this.nodeIdToResourceUsageStats.compute(nodeId, (id, resourceUsageStats) -> {
            if (resourceUsageStats == null) {
                return new NodeResourceUsageStats(nodeId, timestamp, memoryUtilizationPercent, cpuUtilizationPercent, ioUsageStats);
            }
            resourceUsageStats.cpuUtilizationPercent = cpuUtilizationPercent;
            resourceUsageStats.memoryUtilizationPercent = memoryUtilizationPercent;
            resourceUsageStats.setIoUsageStats(ioUsageStats);
            resourceUsageStats.timestamp = timestamp;
            return resourceUsageStats;
        });
    }

    public Map<String, NodeResourceUsageStats> getAllNodeStatistics() {
        HashMap<String, NodeResourceUsageStats> nodeStats = new HashMap<String, NodeResourceUsageStats>(this.nodeIdToResourceUsageStats.size());
        this.nodeIdToResourceUsageStats.forEach((nodeId, resourceUsageStats) -> nodeStats.put((String)nodeId, new NodeResourceUsageStats((NodeResourceUsageStats)resourceUsageStats)));
        return nodeStats;
    }

    public Optional<NodeResourceUsageStats> getNodeStatistics(String nodeId) {
        return Optional.ofNullable((NodeResourceUsageStats)this.nodeIdToResourceUsageStats.get(nodeId)).map(resourceUsageStats -> new NodeResourceUsageStats((NodeResourceUsageStats)resourceUsageStats));
    }

    public NodesResourceUsageStats stats() {
        return new NodesResourceUsageStats(this.getAllNodeStatistics());
    }

    private void collectLocalNodeResourceUsageStats() {
        if (this.nodeResourceUsageTracker.isReady() && this.clusterService.state() != null) {
            this.collectNodeResourceUsageStats(this.clusterService.state().nodes().getLocalNodeId(), System.currentTimeMillis(), this.nodeResourceUsageTracker.getMemoryUtilizationPercent(), this.nodeResourceUsageTracker.getCpuUtilizationPercent(), this.nodeResourceUsageTracker.getIoUsageStats());
        }
    }

    @Override
    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.collectLocalNodeResourceUsageStats();
            }
            catch (Exception e) {
                logger.warn("failure in ResourceUsageCollectorService", (Throwable)e);
            }
        }, new TimeValue(REFRESH_INTERVAL_IN_MILLIS), "generic");
    }

    @Override
    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    @Override
    protected void doClose() {
    }
}

