/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.opensearch.ExceptionsHelper;
import org.opensearch.Version;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.StepListener;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.RepositoryCleanupInProgress;
import org.opensearch.cluster.SnapshotDeletionsInProgress;
import org.opensearch.cluster.SnapshotsInProgress;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Numbers;
import org.opensearch.common.Priority;
import org.opensearch.common.Randomness;
import org.opensearch.common.SetOnce;
import org.opensearch.common.UUIDs;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.EncryptedBlobStore;
import org.opensearch.common.blobstore.fs.FsBlobContainer;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;
import org.opensearch.common.blobstore.transfer.stream.RateLimitingOffsetRangeInputStream;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.DeflateCompressor;
import org.opensearch.common.io.Streams;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.MemorySizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.compress.CompressorRegistry;
import org.opensearch.core.compress.NotXContentException;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.index.snapshots.IndexShardSnapshotFailedException;
import org.opensearch.core.util.BytesRefUtils;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.snapshots.IndexShardRestoreFailedException;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.opensearch.index.snapshots.blobstore.IndexShardSnapshot;
import org.opensearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.opensearch.index.snapshots.blobstore.RemoteStoreShardShallowCopySnapshot;
import org.opensearch.index.snapshots.blobstore.SlicedInputStream;
import org.opensearch.index.snapshots.blobstore.SnapshotFiles;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectoryFactory;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.store.lockmanager.FileLockInfo;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManagerFactory;
import org.opensearch.index.translog.RemoteFsTimestampAwareTranslog;
import org.opensearch.index.translog.RemoteFsTranslog;
import org.opensearch.index.translog.transfer.FileTransferTracker;
import org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.node.remotestore.RemoteStorePinnedTimestampService;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.IndexMetaDataGenerations;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryCleanupResult;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.repositories.RepositoryOperation;
import org.opensearch.repositories.RepositoryShardId;
import org.opensearch.repositories.RepositoryStats;
import org.opensearch.repositories.RepositoryVerificationException;
import org.opensearch.repositories.ShardGenerations;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.opensearch.repositories.blobstore.ConfigBlobStoreFormat;
import org.opensearch.repositories.blobstore.FileRestoreContext;
import org.opensearch.repositories.blobstore.RemoteStoreShardCleanupTask;
import org.opensearch.snapshots.AbortedSnapshotException;
import org.opensearch.snapshots.SnapshotException;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.snapshots.SnapshotShardPaths;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.threadpool.ThreadPool;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String SHALLOW_SNAPSHOT_PREFIX = "shallow-snap-";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    public static final String SHALLOW_SNAPSHOT_NAME_FORMAT = "shallow-snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    public static final String INDICES_DIR = "indices";
    public static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final String SNAPSHOT_REPOSITORY_DATA_CACHET_THRESHOLD_SETTING_NAME = "snapshot.repository_data.cache.threshold";
    public static final double SNAPSHOT_REPOSITORY_DATA_CACHE_THRESHOLD_DEFAULT_PERCENTAGE = 0.01;
    public static final long CACHE_MIN_THRESHOLD = ByteSizeUnit.KB.toBytes(500L);
    public static final long CACHE_MAX_THRESHOLD = BlobStoreRepository.calculateMaxSnapshotRepositoryDataCacheThreshold();
    public static final long CACHE_DEFAULT_THRESHOLD = BlobStoreRepository.calculateDefaultSnapshotRepositoryDataCacheThreshold();
    public static final String MAX_SNAPSHOT_BYTES_PER_SEC = "max_snapshot_bytes_per_sec";
    public static final Setting<ByteSizeValue> SNAPSHOT_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.NodeScope);
    public static final String MAX_RESTORE_BYTES_PER_SEC = "max_restore_bytes_per_sec";
    public static final Setting<ByteSizeValue> RESTORE_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_restore_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.NodeScope);
    public static final String MAX_REMOTE_UPLOAD_BYTES_PER_SEC = "max_remote_upload_bytes_per_sec";
    public static final Setting<ByteSizeValue> MAX_REMOTE_UPLOAD_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_remote_upload_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.NodeScope);
    public static final String MAX_REMOTE_LOW_PRIORITY_UPLOAD_BYTES_PER_SEC = "max_remote_low_priority_upload_bytes_per_sec";
    public static final Setting<ByteSizeValue> MAX_REMOTE_LOW_PRIORITY_UPLOAD_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_remote_low_priority_upload_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.NodeScope);
    public static final String MAX_REMOTE_DOWNLOAD_BYTES_PER_SEC = "max_remote_download_bytes_per_sec";
    public static final Setting<ByteSizeValue> MAX_REMOTE_DOWNLOAD_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_remote_download_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.NodeScope);
    public static final String MAX_REMOTE_LOW_PRIORITY_DOWNLOAD_BYTES_PER_SEC = "max_remote_low_priority_download_bytes_per_sec";
    public static final Setting<ByteSizeValue> MAX_REMOTE_LOW_PRIORITY_DOWNLOAD_BYTES_PER_SEC_SETTING = Setting.byteSizeSetting("max_remote_low_priority_download_bytes_per_sec", ByteSizeValue.ZERO, Setting.Property.NodeScope);
    private static final int MAX_SAFE_ARRAY_SIZE = 0x7FFFFFF7;
    public static final Setting<Boolean> ALLOW_CONCURRENT_MODIFICATION = Setting.boolSetting("allow_concurrent_modifications", false, Setting.Property.Deprecated);
    private static final Logger staticLogger = LogManager.getLogger(BlobStoreRepository.class);
    public static final Setting<Boolean> CACHE_REPOSITORY_DATA = Setting.boolSetting("cache_repository_data", true, Setting.Property.Deprecated);
    public static final Setting<ByteSizeValue> SNAPSHOT_REPOSITORY_DATA_CACHE_THRESHOLD = new Setting<ByteSizeValue>("snapshot.repository_data.cache.threshold", CACHE_DEFAULT_THRESHOLD + "b", s -> {
        ByteSizeValue userDefinedLimit = MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, SNAPSHOT_REPOSITORY_DATA_CACHET_THRESHOLD_SETTING_NAME);
        long userDefinedLimitBytes = userDefinedLimit.getBytes();
        if (userDefinedLimitBytes > CACHE_MAX_THRESHOLD) {
            throw new IllegalArgumentException("[snapshot.repository_data.cache.threshold] cannot be larger than [" + CACHE_MAX_THRESHOLD + "] bytes.");
        }
        if (userDefinedLimitBytes < CACHE_MIN_THRESHOLD) {
            throw new IllegalArgumentException("[snapshot.repository_data.cache.threshold] cannot be smaller than [" + CACHE_MIN_THRESHOLD + "] bytes.");
        }
        return userDefinedLimit;
    }, Setting.Property.NodeScope);
    private static final Set<String> RELOADABLE_SETTINGS = Set.of("max_restore_bytes_per_sec", "max_snapshot_bytes_per_sec", "max_remote_upload_bytes_per_sec", "max_remote_low_priority_upload_bytes_per_sec", "max_remote_download_bytes_per_sec");
    public static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting("io_buffer_size", ByteSizeValue.parseBytesSizeValue("128kb", "io_buffer_size"), ByteSizeValue.parseBytesSizeValue("8kb", "buffer_size"), ByteSizeValue.parseBytesSizeValue("16mb", "io_buffer_size"), Setting.Property.NodeScope);
    public static final Setting<Boolean> REMOTE_STORE_INDEX_SHALLOW_COPY = Setting.boolSetting("remote_store_index_shallow_copy", false, new Setting.Property[0]);
    public static final Setting<Boolean> SHALLOW_SNAPSHOT_V2 = Setting.boolSetting("shallow_snapshot_v2", false, new Setting.Property[0]);
    public static final Setting<RemoteStoreEnums.PathType> SHARD_PATH_TYPE = new Setting<RemoteStoreEnums.PathType>("shard_path_type", RemoteStoreEnums.PathType.HASHED_PREFIX.toString(), RemoteStoreEnums.PathType::parseString, new Setting.Property[0]);
    public static final Setting<Integer> MAX_SNAPSHOT_SHARD_BLOB_DELETE_BATCH_SIZE = Setting.intSetting("max_snapshot_shard_blob_delete_batch_size", 1000, Setting.Property.NodeScope);
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", false, Setting.Property.NodeScope);
    public static final Setting<Compressor> COMPRESSION_TYPE_SETTING = new Setting<Compressor>("compression_type", DeflateCompressor.NAME.toLowerCase(Locale.ROOT), s -> CompressorRegistry.getCompressor(s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
    public static final Setting<Boolean> SUPPORT_URL_REPO = Setting.boolSetting("support_url_repo", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting("readonly", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> SYSTEM_REPOSITORY_SETTING = Setting.boolSetting("system_repository", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> PREFIX_MODE_VERIFICATION_SETTING = Setting.boolSetting("prefix_mode_verification", false, Setting.Property.NodeScope);
    public static final Setting<String> SNAPSHOT_SHARD_PATH_PREFIX_SETTING = Setting.simpleString("cluster.snapshot.shard.path.prefix", "", Setting.Property.NodeScope, Setting.Property.Final);
    protected volatile boolean supportURLRepo;
    private volatile int maxShardBlobDeleteBatch;
    private volatile Compressor compressor;
    private volatile boolean cacheRepositoryData;
    private volatile RateLimiter snapshotRateLimiter;
    private volatile RateLimiter restoreRateLimiter;
    private volatile RateLimiter remoteUploadRateLimiter;
    private volatile RateLimiter remoteUploadLowPriorityRateLimiter;
    private volatile RateLimiter remoteDownloadRateLimiter;
    private volatile RateLimiter remoteDownloadLowPriorityRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteDownloadRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteUploadRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteUploadLowPriorityRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric remoteDownloadLowPriorityRateLimitingTimeInNanos = new CounterMetric();
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat<Metadata>("metadata", "meta-%s.dat", Metadata::fromXContent);
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat<IndexMetadata>("index-metadata", "meta-%s.dat", IndexMetadata::fromXContent);
    private static final String SNAPSHOT_CODEC = "snapshot";
    public static final ChecksumBlobStoreFormat<SnapshotInfo> SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<SnapshotInfo>("snapshot", "snap-%s.dat", SnapshotInfo::fromXContentInternal);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> INDEX_SHARD_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>("snapshot", "snap-%s.dat", BlobStoreIndexShardSnapshot::fromXContent);
    public static final ChecksumBlobStoreFormat<RemoteStoreShardShallowCopySnapshot> REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT = new ChecksumBlobStoreFormat<RemoteStoreShardShallowCopySnapshot>("snapshot", "shallow-snap-%s.dat", RemoteStoreShardShallowCopySnapshot::fromXContent);
    public static final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> INDEX_SHARD_SNAPSHOTS_FORMAT = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>("snapshots", "index-%s", BlobStoreIndexShardSnapshots::fromXContent);
    public static final ConfigBlobStoreFormat<SnapshotShardPaths> SNAPSHOT_SHARD_PATHS_FORMAT = new ConfigBlobStoreFormat("snapshot_path_%s");
    private volatile boolean readOnly;
    private final boolean isSystemRepository;
    private final boolean prefixModeVerification;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobContainer> rootBlobContainer = new SetOnce();
    private final SetOnce<BlobContainer> snapshotShardPathBlobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    protected final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final RemoteStoreSettings remoteStoreSettings;
    private final NamedXContentRegistry namedXContentRegistry;
    private final String snapshotShardPathPrefix;
    protected final long repositoryDataCacheThreshold;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    protected volatile int bufferSize;
    private volatile boolean closed;
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);
    private final AtomicReference<SoftReference<Tuple<Long, BytesReference>>> latestKnownRepositoryData = new AtomicReference<SoftReference<Object>>(new SoftReference<Object>(null));

    public static long calculateDefaultSnapshotRepositoryDataCacheThreshold() {
        return Math.max(ByteSizeUnit.KB.toBytes(500L), CACHE_MAX_THRESHOLD / 2L);
    }

    public static long calculateMaxSnapshotRepositoryDataCacheThreshold() {
        long jvmHeapSize = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
        long defaultThresholdOfHeap = (long)((double)jvmHeapSize * 0.01);
        long defaultAbsoluteThreshold = ByteSizeUnit.KB.toBytes(500L);
        long maxThreshold = BlobStoreRepository.calculateMaxWithinIntLimit(defaultThresholdOfHeap, defaultAbsoluteThreshold);
        return maxThreshold;
    }

    protected static long calculateMaxWithinIntLimit(long defaultThresholdOfHeap, long defaultAbsoluteThreshold) {
        return Math.min(Math.max(defaultThresholdOfHeap, defaultAbsoluteThreshold), 0x7FFFFFF7L);
    }

    protected BlobStoreRepository(RepositoryMetadata repositoryMetadata, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        this.readRepositoryMetadata(repositoryMetadata);
        this.isSystemRepository = SYSTEM_REPOSITORY_SETTING.get(this.metadata.settings());
        this.prefixModeVerification = PREFIX_MODE_VERIFICATION_SETTING.get(this.metadata.settings());
        this.namedXContentRegistry = namedXContentRegistry;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        this.remoteStoreSettings = new RemoteStoreSettings(clusterService.getSettings(), clusterService.getClusterSettings());
        this.snapshotShardPathPrefix = SNAPSHOT_SHARD_PATH_PREFIX_SETTING.get(clusterService.getSettings());
        this.repositoryDataCacheThreshold = SNAPSHOT_REPOSITORY_DATA_CACHE_THRESHOLD.get(clusterService.getSettings()).getBytes();
    }

    @Override
    public void reload(RepositoryMetadata repositoryMetadata) {
        this.readRepositoryMetadata(repositoryMetadata);
    }

    private void readRepositoryMetadata(RepositoryMetadata repositoryMetadata) {
        this.metadata = repositoryMetadata;
        this.supportURLRepo = SUPPORT_URL_REPO.get(this.metadata.settings());
        this.snapshotRateLimiter = this.getRateLimiter(SNAPSHOT_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.restoreRateLimiter = this.getRateLimiter(RESTORE_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.remoteUploadRateLimiter = this.getRateLimiter(MAX_REMOTE_UPLOAD_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.remoteUploadLowPriorityRateLimiter = this.getRateLimiter(MAX_REMOTE_LOW_PRIORITY_UPLOAD_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.remoteDownloadRateLimiter = this.getRateLimiter(MAX_REMOTE_DOWNLOAD_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.remoteDownloadLowPriorityRateLimiter = this.getRateLimiter(MAX_REMOTE_LOW_PRIORITY_DOWNLOAD_BYTES_PER_SEC_SETTING, this.metadata.settings());
        this.readOnly = READONLY_SETTING.get(this.metadata.settings());
        this.cacheRepositoryData = CACHE_REPOSITORY_DATA.get(this.metadata.settings());
        this.bufferSize = Math.toIntExact(BUFFER_SIZE_SETTING.get(this.metadata.settings()).getBytes());
        this.maxShardBlobDeleteBatch = MAX_SNAPSHOT_SHARD_BLOB_DELETE_BATCH_SIZE.get(this.metadata.settings());
        this.compressor = COMPRESS_SETTING.get(this.metadata.settings()) != false ? COMPRESSION_TYPE_SETTING.get(this.metadata.settings()) : CompressorRegistry.none();
    }

    @Override
    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + String.valueOf(chunkSize) + "]");
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = this.blobStore.get();
        }
        if (store != null) {
            try {
                this.closed = true;
                store.close();
            }
            catch (Exception t) {
                logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    @Override
    public void executeConsistentStateUpdate(final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, final Consumer<Exception> onFailure) {
        if (this.closed) {
            onFailure.accept(new RepositoryException(this.metadata.name(), "the repository has been changed, try again"));
            return;
        }
        final RepositoryMetadata repositoryMetadataStart = this.metadata;
        this.getRepositoryData(ActionListener.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.clusterService.submitStateUpdateTask(source, new ClusterStateUpdateTask(this, updateTask.priority()){
                private boolean executedTask;
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                    super(priority);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    if (repositoryMetadataStart.equals(this.this$0.getRepoMetadata(currentState))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(source, e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(source, oldState, newState);
                    } else {
                        this.this$0.executeConsistentStateUpdate(createUpdateTask, source, onFailure);
                    }
                }

                @Override
                public TimeValue timeout() {
                    return updateTask.timeout();
                }

                @Override
                public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                    return updateTask.getClusterManagerThrottlingKey();
                }
            });
        }, onFailure));
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository"));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(listener, () -> {
            BlobStoreIndexShardSnapshots existingSnapshots;
            String newGen;
            String existingShardGen;
            long startTime = this.threadPool.absoluteTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            if (shardGeneration == null) {
                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.buildBlobStoreIndexShardSnapshots(shardContainer.listBlobsByPrefix("index-").keySet(), shardContainer);
                existingShardGen = String.valueOf(tuple.v2());
                newGen = String.valueOf(tuple.v2() + 1L);
                existingSnapshots = tuple.v1();
            } else {
                newGen = UUIDs.randomBase64UUID();
                existingSnapshots = this.buildBlobStoreIndexShardSnapshots(Collections.emptySet(), shardContainer, shardGeneration).v1();
                existingShardGen = shardGeneration;
            }
            SnapshotFiles existingTargetFiles = null;
            SnapshotFiles sourceFiles = null;
            for (SnapshotFiles existingSnapshot : existingSnapshots) {
                String snapshotName = existingSnapshot.snapshot();
                if (snapshotName.equals(target.getName())) {
                    existingTargetFiles = existingSnapshot;
                } else if (snapshotName.equals(source.getName())) {
                    sourceFiles = existingSnapshot;
                }
                if (sourceFiles == null || existingTargetFiles == null) continue;
                break;
            }
            if (sourceFiles == null) {
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + String.valueOf(shardId) + "] for snapshot [" + String.valueOf(target) + "]. The source snapshot [" + String.valueOf(source) + "] was not found in the shard metadata.");
            }
            if (existingTargetFiles != null) {
                if (existingTargetFiles.isSame(sourceFiles)) {
                    return existingShardGen;
                }
                throw new RepositoryException(this.metadata.name(), "Can't create clone of [" + String.valueOf(shardId) + "] for snapshot [" + String.valueOf(target) + "]. A snapshot by that name already exists for this shard.");
            }
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(shardContainer, source);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot sourceMeta = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            logger.trace("[{}] [{}] writing shard snapshot file for clone", (Object)shardId, (Object)target);
            INDEX_SHARD_SNAPSHOT_FORMAT.write(sourceMeta.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compressor);
            INDEX_SHARD_SNAPSHOTS_FORMAT.write(existingSnapshots.withClone(source.getName(), target.getName()), shardContainer, newGen, this.compressor);
            return newGen;
        }));
    }

    @Override
    public void cloneRemoteStoreIndexShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, @Nullable String shardGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot clone shard snapshot on a readonly repository"));
            return;
        }
        IndexId index = shardId.index();
        int shardNum = shardId.shardId();
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(listener, () -> {
            long startTime = this.threadPool.relativeTimeInMillis();
            BlobContainer shardContainer = this.shardContainer(index, shardNum);
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(shardContainer, source);
            assert (indexShardSnapshot instanceof RemoteStoreShardShallowCopySnapshot) : "indexShardSnapshot should be an instance of RemoteStoreShardShallowCopySnapshot";
            RemoteStoreShardShallowCopySnapshot remStoreBasedShardMetadata = (RemoteStoreShardShallowCopySnapshot)indexShardSnapshot;
            String indexUUID = remStoreBasedShardMetadata.getIndexUUID();
            String remoteStoreRepository = remStoreBasedShardMetadata.getRemoteStoreRepository();
            RemoteStoreLockManager remoteStoreMetadataLockManger = remoteStoreLockManagerFactory.newLockManager(remoteStoreRepository, indexUUID, String.valueOf(shardId.shardId()), remStoreBasedShardMetadata.getRemoteStorePathStrategy());
            remoteStoreMetadataLockManger.cloneLock(FileLockInfo.getLockInfoBuilder().withAcquirerId(source.getUUID()).build(), FileLockInfo.getLockInfoBuilder().withAcquirerId(target.getUUID()).build());
            REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.write(remStoreBasedShardMetadata.asClone(target.getName(), startTime, this.threadPool.absoluteTimeInMillis() - startTime), shardContainer, target.getUUID(), this.compressor);
            return shardGeneration;
        }));
    }

    @Override
    public void updateState(ClusterState state) {
        this.metadata = this.getRepoMetadata(state);
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean wasBestEffortConsistency = this.bestEffortConsistency;
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || this.metadata.generation() == -2L || ALLOW_CONCURRENT_MODIFICATION.get(this.metadata.settings()) != false;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
            long bestGenerationFromCS = this.bestGeneration(snapshotsInProgress.entries());
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries());
            }
            if (bestGenerationFromCS == -1L) {
                bestGenerationFromCS = this.bestGeneration(state.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY).entries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, finalBestGen));
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (wasBestEffortConsistency || this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                logger.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    BlobContainer getBlobContainer() {
        return this.blobContainer.get();
    }

    BlobContainer getRootBlobContainer() {
        return this.rootBlobContainer.get();
    }

    public SetOnce<BlobContainer> getSnapshotShardPathBlobContainer() {
        return this.snapshotShardPathBlobContainer;
    }

    protected BlobStore getBlobStore() {
        return this.blobStore.get();
    }

    boolean getPrefixModeVerification() {
        return this.prefixModeVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set(blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer rootBlobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer rootBlobContainer = this.rootBlobContainer.get();
        if (rootBlobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                rootBlobContainer = this.rootBlobContainer.get();
                if (rootBlobContainer == null) {
                    rootBlobContainer = this.blobStore().blobContainer(BlobPath.cleanPath());
                    this.rootBlobContainer.set(rootBlobContainer);
                }
            }
        }
        return rootBlobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer snapshotShardPathBlobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer snapshotShardPathBlobContainer = this.snapshotShardPathBlobContainer.get();
        if (snapshotShardPathBlobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                snapshotShardPathBlobContainer = this.snapshotShardPathBlobContainer.get();
                if (snapshotShardPathBlobContainer == null) {
                    snapshotShardPathBlobContainer = this.blobStore().blobContainer(this.basePath().add("snapshot_shard_paths"));
                    this.snapshotShardPathBlobContainer.set(snapshotShardPathBlobContainer);
                }
            }
        }
        return snapshotShardPathBlobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        BlobStore store = this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                        if (this.metadata.cryptoMetadata() != null) {
                            store = new EncryptedBlobStore(store, this.metadata.cryptoMetadata());
                        }
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
                    }
                    this.blobStore.set(store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public abstract BlobPath basePath();

    protected final boolean isCompress() {
        return this.compressor != CompressorRegistry.none();
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    public NamedXContentRegistry getNamedXContentRegistry() {
        return this.namedXContentRegistry;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public RepositoryStats stats() {
        BlobStore store = this.blobStore.get();
        if (store == null) {
            return RepositoryStats.EMPTY_STATS;
        }
        if (store.extendedStats() != null && !store.extendedStats().isEmpty()) {
            return new RepositoryStats(store.extendedStats(), true);
        }
        return new RepositoryStats(store.stats());
    }

    @Override
    public void deleteSnapshotsInternal(final Collection<SnapshotId> snapshotIds, final long repositoryStateId, final Version repositoryMetaVersion, final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, final RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, final RemoteStorePinnedTimestampService remoteStorePinnedTimestampService, final Map<SnapshotId, Long> snapshotIdsPinnedTimestampMap, final boolean isShallowSnapshotV2, final ActionListener<RepositoryData> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            this.threadPool.executor(SNAPSHOT_CODEC).execute(new AbstractRunnable(this){
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected void doRun() throws Exception {
                    Map<String, BlobMetadata> rootBlobs = this.this$0.blobContainer().listBlobs();
                    RepositoryData repositoryData = this.this$0.safeRepositoryData(repositoryStateId, rootBlobs);
                    Map<String, BlobContainer> foundIndices = this.this$0.blobStore().blobContainer(this.this$0.indicesPath()).children();
                    this.this$0.doDeleteShardSnapshots(snapshotIds, repositoryStateId, foundIndices, rootBlobs, repositoryData, repositoryMetaVersion, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, remoteStorePinnedTimestampService, snapshotIdsPinnedTimestampMap, isShallowSnapshotV2, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "failed to delete snapshots " + String.valueOf(snapshotIds), e));
                }
            });
        }
    }

    @Override
    public void deleteSnapshotsWithPinnedTimestamp(Map<SnapshotId, Long> snapshotIdPinnedTimestampMap, long repositoryStateId, Version repositoryMetaVersion, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, RemoteStorePinnedTimestampService remoteStorePinnedTimestampService, ActionListener<RepositoryData> listener) {
        this.deleteSnapshotsInternal(snapshotIdPinnedTimestampMap.keySet(), repositoryStateId, repositoryMetaVersion, null, remoteSegmentStoreDirectoryFactory, remoteStorePinnedTimestampService, snapshotIdPinnedTimestampMap, true, listener);
    }

    @Override
    public void deleteSnapshotsAndReleaseLockFiles(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<RepositoryData> listener) {
        this.deleteSnapshotsInternal(snapshotIds, repositoryStateId, repositoryMetaVersion, remoteStoreLockManagerFactory, null, null, Collections.emptyMap(), false, listener);
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        this.deleteSnapshotsInternal(snapshotIds, repositoryStateId, repositoryMetaVersion, null, null, null, Collections.emptyMap(), false, listener);
    }

    private RepositoryData safeRepositoryData(long repositoryStateId, Map<String, BlobMetadata> rootBlobs) throws IOException {
        Tuple<Long, BytesReference> cached;
        long genToLoad;
        long generation = this.latestGeneration(rootBlobs.keySet());
        if (this.bestEffortConsistency) {
            genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, repositoryStateId));
            cached = null;
        } else {
            genToLoad = this.latestKnownRepoGen.get();
            SoftReference<Tuple<Long, BytesReference>> softRef = this.latestKnownRepositoryData.get();
            Tuple<Long, BytesReference> tuple = cached = softRef != null ? softRef.get() : null;
        }
        if (genToLoad > generation) {
            logger.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + genToLoad + "]");
        }
        if (cached != null && cached.v1() == genToLoad) {
            return this.repositoryDataFromCachedEntry(cached);
        }
        return this.getRepositoryData(genToLoad);
    }

    private void doDeleteShardSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData repositoryData, Version repoMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, RemoteStorePinnedTimestampService remoteStorePinnedTimestampService, Map<SnapshotId, Long> snapshotIdPinnedTimestampMap, boolean isShallowSnapshotV2, ActionListener<RepositoryData> listener) {
        StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeShardMetaDataAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
        this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotIds, repositoryData, true, remoteStoreLockManagerFactory, writeShardMetaDataAndComputeDeletesStep);
        StepListener<RepositoryData> writeUpdatedRepoDataStep = new StepListener<RepositoryData>();
        writeShardMetaDataAndComputeDeletesStep.whenComplete(deleteResults -> {
            ShardGenerations.Builder builder = ShardGenerations.builder();
            for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
            }
            RepositoryData updatedRepoData = repositoryData.removeSnapshots(snapshotIds, builder.build());
            this.writeIndexGen(updatedRepoData, repositoryStateId, repoMetaVersion, Function.identity(), Priority.NORMAL, ActionListener.wrap(writeUpdatedRepoDataStep::onResponse, listener::onFailure));
        }, listener::onFailure);
        StepListener<RepositoryData> pinnedTimestampListener = new StepListener<RepositoryData>();
        writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
            if (snapshotIdPinnedTimestampMap == null || snapshotIdPinnedTimestampMap.isEmpty()) {
                pinnedTimestampListener.onResponse((RepositoryData)updatedRepoData);
            } else {
                this.removeSnapshotsPinnedTimestamp(snapshotIdPinnedTimestampMap, this, (RepositoryData)updatedRepoData, remoteStorePinnedTimestampService, (ActionListener<RepositoryData>)pinnedTimestampListener);
            }
        }, listener::onFailure);
        pinnedTimestampListener.whenComplete(updatedRepoData -> {
            GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse((RepositoryData)updatedRepoData)), 2);
            Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap = repositoryData.getIndices().values().stream().collect(Collectors.toMap(IndexId::getId, indexId -> new SnapshotShardPaths.ShardInfo((IndexId)indexId, repositoryData.shardGenerations().getGens((IndexId)indexId).size())));
            this.cleanupUnlinkedRootAndIndicesBlobs(snapshotIds, foundIndices, rootBlobs, (RepositoryData)updatedRepoData, repositoryData, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, (ActionListener<Void>)afterCleanupsListener, idToShardInfoMap);
            if (isShallowSnapshotV2) {
                this.cleanUpRemoteStoreFilesForDeletedIndicesV2(repositoryData, snapshotIds, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), remoteSegmentStoreDirectoryFactory, afterCleanupsListener);
            } else {
                this.asyncCleanupUnlinkedShardLevelBlobs(repositoryData, snapshotIds, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), remoteStoreLockManagerFactory, afterCleanupsListener);
            }
        }, listener::onFailure);
    }

    private void cleanUpRemoteStoreFilesForDeletedIndicesV2(RepositoryData repositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> result, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, ActionListener<Void> afterCleanupsListener) {
        try {
            HashSet<String> uniqueIndexIds = new HashSet<String>();
            for (ShardSnapshotMetaDeleteResult shardSnapshotMetaDeleteResult : result) {
                uniqueIndexIds.add(shardSnapshotMetaDeleteResult.indexId.getId());
            }
            for (String indexId : uniqueIndexIds) {
                this.cleanRemoteStoreDirectoryIfNeeded(snapshotIds, indexId, repositoryData, remoteSegmentStoreDirectoryFactory, false);
            }
            afterCleanupsListener.onResponse(null);
        }
        catch (Exception e) {
            logger.warn("Exception during cleanup of remote directory files for snapshot v2", (Throwable)e);
            afterCleanupsListener.onFailure(e);
        }
    }

    private void removeSnapshotsPinnedTimestamp(Map<SnapshotId, Long> snapshotsWithPinnedTimestamp, Repository repository, RepositoryData repositoryData, RemoteStorePinnedTimestampService remoteStorePinnedTimestampService, ActionListener<RepositoryData> pinnedTimestampListener) {
        GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(ignored -> pinnedTimestampListener.onResponse(repositoryData), pinnedTimestampListener::onFailure), snapshotsWithPinnedTimestamp.size());
        snapshotsWithPinnedTimestamp.forEach((snapshotId, pinnedTimestamp) -> this.removeSnapshotPinnedTimestamp(remoteStorePinnedTimestampService, (SnapshotId)snapshotId, repository.getMetadata().name(), (long)pinnedTimestamp, groupedListener));
    }

    private void removeSnapshotPinnedTimestamp(final RemoteStorePinnedTimestampService remoteStorePinnedTimestampService, final SnapshotId snapshotId, String repository, final long timestampToUnpin, final ActionListener<RepositoryData> listener) {
        remoteStorePinnedTimestampService.unpinTimestamp(timestampToUnpin, SnapshotsService.getPinningEntity(repository, snapshotId.getUUID()), new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                logger.info("Timestamp {} unpinned successfully for snapshot {}", (Object)timestampToUnpin, (Object)snapshotId.getName());
                try {
                    remoteStorePinnedTimestampService.forceSyncPinnedTimestamps();
                    logger.debug("Successfully synced pinned timestamp state");
                }
                catch (Exception e) {
                    logger.warn("Exception while updating pinning timestamp state, snapshot deletion will continue", (Throwable)e);
                }
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("Failed to unpin timestamp {} for snapshot {} with exception {}", (Object)timestampToUnpin, (Object)snapshotId.getName(), (Object)e);
                listener.onFailure(e);
            }
        });
    }

    private void cleanupUnlinkedRootAndIndicesBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData updatedRepoData, RepositoryData oldRepoData, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, ActionListener<Void> listener, Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap) {
        this.cleanupStaleBlobs(deletedSnapshots, foundIndices, rootBlobs, updatedRepoData, oldRepoData, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, ActionListener.map(listener, ignored -> null), idToShardInfoMap);
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<Void> listener) {
        List<Tuple<BlobPath, String>> filesToDelete = this.resolveFilesToDelete(oldRepositoryData, snapshotIds, deleteResults);
        long startTimeNs = System.nanoTime();
        Randomness.shuffle(filesToDelete);
        logger.debug("[{}] shuffled the filesToDelete with timeElapsedNs={}", (Object)this.metadata.name(), (Object)(System.nanoTime() - startTimeNs));
        if (filesToDelete.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        try {
            AtomicInteger counter = new AtomicInteger();
            Collection<List<Tuple>> subList = filesToDelete.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / this.maxShardBlobDeleteBatch)).values();
            LinkedBlockingQueue<List<Tuple<BlobPath, String>>> staleFilesToDeleteInBatch = new LinkedBlockingQueue<List<Tuple<BlobPath, String>>>(subList);
            GroupedActionListener<Void> groupedListener = new GroupedActionListener<Void>(ActionListener.wrap(r -> listener.onResponse(null), listener::onFailure), staleFilesToDeleteInBatch.size());
            int workers = Math.min(this.threadPool.info("snapshot_deletion").getMax(), staleFilesToDeleteInBatch.size());
            for (int i = 0; i < workers; ++i) {
                this.executeStaleShardDelete(staleFilesToDeleteInBatch, remoteStoreLockManagerFactory, groupedListener);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale shard blobs", snapshotIds), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static void remoteDirectoryCleanupAsync(RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory, ThreadPool threadpool, String remoteStoreRepoForIndex, String indexUUID, ShardId shardId, String threadPoolName, RemoteStorePathStrategy pathStrategy, boolean forceClean) {
        threadpool.executor(threadPoolName).execute(new RemoteStoreShardCleanupTask(() -> RemoteSegmentStoreDirectory.remoteDirectoryCleanup(remoteDirectoryFactory, remoteStoreRepoForIndex, indexUUID, shardId, pathStrategy, forceClean), indexUUID, shardId));
    }

    protected void releaseRemoteStoreLockAndCleanup(String shardId, String shallowSnapshotUUID, BlobContainer shardContainer, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) throws IOException {
        if (remoteStoreLockManagerFactory == null) {
            return;
        }
        RemoteStoreShardShallowCopySnapshot remoteStoreShardShallowCopySnapshot = REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.read(shardContainer, shallowSnapshotUUID, this.namedXContentRegistry);
        String indexUUID = remoteStoreShardShallowCopySnapshot.getIndexUUID();
        String remoteStoreRepoForIndex = remoteStoreShardShallowCopySnapshot.getRemoteStoreRepository();
        RemoteStoreLockManager remoteStoreMetadataLockManager = remoteStoreLockManagerFactory.newLockManager(remoteStoreRepoForIndex, indexUUID, shardId, remoteStoreShardShallowCopySnapshot.getRemoteStorePathStrategy());
        remoteStoreMetadataLockManager.release(FileLockInfo.getLockInfoBuilder().withAcquirerId(shallowSnapshotUUID).build());
        logger.debug("Successfully released lock for shard {} of index with uuid {}", (Object)shardId, (Object)indexUUID);
        if (!BlobStoreRepository.isIndexPresent(this.clusterService, indexUUID)) {
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(remoteStoreLockManagerFactory.getRepositoriesService(), this.threadPool, this.remoteStoreSettings.getSegmentsPathFixedPrefix());
            BlobStoreRepository.remoteDirectoryCleanupAsync(remoteDirectoryFactory, this.threadPool, remoteStoreRepoForIndex, indexUUID, new ShardId("_unknown_", indexUUID, Integer.parseInt(shardId)), "remote_purge", remoteStoreShardShallowCopySnapshot.getRemoteStorePathStrategy(), false);
        }
    }

    private void executeStaleShardDelete(BlockingQueue<List<Tuple<BlobPath, String>>> staleFilesToDeleteInBatch, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, GroupedActionListener<Void> listener) throws InterruptedException {
        List<Tuple<BlobPath, String>> filesToDelete = staleFilesToDeleteInBatch.poll(0L, TimeUnit.MILLISECONDS);
        if (filesToDelete == null) {
            return;
        }
        this.threadPool.executor("snapshot_deletion").execute(ActionRunnable.wrap(listener, l -> {
            try {
                ArrayList<String> eligibleFilesToDelete = new ArrayList<String>();
                for (Tuple fileToDelete : filesToDelete) {
                    BlobPath blobPath = (BlobPath)fileToDelete.v1();
                    String blobName = (String)fileToDelete.v2();
                    boolean deleteBlob = false;
                    if (blobName.startsWith(SHALLOW_SNAPSHOT_PREFIX)) {
                        String snapshotUUID = BlobStoreRepository.extractShallowSnapshotUUID(blobName).orElseThrow();
                        String[] parts = blobPath.toArray();
                        int partLength = parts.length;
                        String indexId = parts[partLength - 2];
                        String shardId = parts[partLength - 1];
                        BlobContainer shardContainer = this.blobStore().blobContainer(blobPath);
                        try {
                            this.releaseRemoteStoreLockAndCleanup(shardId, snapshotUUID, shardContainer, remoteStoreLockManagerFactory);
                            deleteBlob = true;
                        }
                        catch (Exception e) {
                            logger.error("Failed to release lock or cleanup shard for indexID {}, shardID {} and snapshot {}", (Object)indexId, (Object)shardId, (Object)snapshotUUID);
                        }
                    } else {
                        deleteBlob = true;
                    }
                    if (!deleteBlob) continue;
                    eligibleFilesToDelete.add(blobPath.buildAsString() + blobName);
                }
                this.deleteFromContainer(this.rootBlobContainer(), eligibleFilesToDelete);
                l.onResponse(null);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] Failed to delete following blobs during snapshot delete : {}", (Object)this.metadata.name(), (Object)filesToDelete), (Throwable)e);
                l.onFailure(e);
            }
            this.executeStaleShardDelete(staleFilesToDeleteInBatch, remoteStoreLockManagerFactory, listener);
        }));
    }

    private void writeUpdatedShardMetaDataAndComputeDeletes(final Collection<SnapshotId> snapshotIds, final RepositoryData oldRepositoryData, final boolean useUUIDs, final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        ExecutorService executor = this.threadPool.executor("snapshot_deletion");
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        GroupedActionListener deleteIndexMetadataListener = new GroupedActionListener(ActionListener.map(onAllShardsCompleted, res -> res.stream().flatMap(Collection::stream).collect(Collectors.toList())), indices.size());
        for (final IndexId indexId : indices) {
            final Set survivingSnapshots = oldRepositoryData.getSnapshots(indexId).stream().filter(id -> !snapshotIds.contains(id)).collect(Collectors.toSet());
            StepListener shardCountListener = new StepListener();
            Collection indexMetaGenerations = snapshotIds.stream().map(id -> oldRepositoryData.indexMetaDataGenerations().indexMetaBlobId((SnapshotId)id, indexId)).collect(Collectors.toSet());
            GroupedActionListener allShardCountsListener = new GroupedActionListener(shardCountListener, indexMetaGenerations.size());
            BlobContainer indexContainer = this.indexContainer(indexId);
            for (String indexMetaGeneration : indexMetaGenerations) {
                executor.execute(ActionRunnable.supply(allShardCountsListener, () -> {
                    try {
                        return INDEX_METADATA_FORMAT.read(indexContainer, indexMetaGeneration, this.namedXContentRegistry).getNumberOfShards();
                    }
                    catch (Exception ex) {
                        logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)indexMetaGeneration, (Object)indexId.getName()), (Throwable)ex);
                        return null;
                    }
                }));
            }
            shardCountListener.whenComplete(counts -> {
                int shardCount = counts.stream().mapToInt(i -> i).max().orElse(0);
                if (shardCount == 0) {
                    deleteIndexMetadataListener.onResponse(null);
                    return;
                }
                final GroupedActionListener allShardsListener = new GroupedActionListener(deleteIndexMetadataListener, shardCount);
                int shardId = 0;
                while (shardId < shardCount) {
                    final int finalShardId = shardId++;
                    executor.execute(new AbstractRunnable(this){
                        final /* synthetic */ BlobStoreRepository this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        protected void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            long newGen;
                            BlobContainer shardContainer = this.this$0.shardContainer(indexId, finalShardId);
                            Set<String> blobs = shardContainer.listBlobs().keySet();
                            if (blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toSet()).size() > 0) {
                                if (useUUIDs) {
                                    newGen = -1L;
                                    blobStoreIndexShardSnapshots = this.this$0.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, finalShardId)).v1();
                                } else {
                                    Tuple<BlobStoreIndexShardSnapshots, Long> tuple = this.this$0.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                    newGen = tuple.v2() + 1L;
                                    blobStoreIndexShardSnapshots = tuple.v1();
                                }
                            } else {
                                newGen = -1L;
                                blobStoreIndexShardSnapshots = BlobStoreIndexShardSnapshots.EMPTY;
                            }
                            allShardsListener.onResponse(this.this$0.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, finalShardId, snapshotIds, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen, remoteStoreLockManagerFactory));
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            logger.warn(() -> new ParameterizedMessage("{} failed to delete shard data for shard [{}][{}]", new Object[]{snapshotIds, indexId.getName(), finalShardId}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }, deleteIndexMetadataListener::onFailure);
        }
    }

    private List<Tuple<BlobPath, String>> resolveFilesToDelete(RepositoryData oldRepositoryData, Collection<SnapshotId> snapshotIds, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        Map<IndexId, Collection<String>> indexMetaGenerations = oldRepositoryData.indexMetaDataToRemoveAfterRemovingSnapshots(snapshotIds);
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            BlobPath shardPath = this.shardPath(shardResult.indexId, shardResult.shardId);
            return shardResult.blobsToDelete.stream().map(blob -> Tuple.tuple(shardPath, blob));
        }), indexMetaGenerations.entrySet().stream().flatMap(entry -> {
            BlobPath indexPath = this.indexPath((IndexId)entry.getKey());
            return ((Collection)entry.getValue()).stream().map(id -> Tuple.tuple(indexPath, INDEX_METADATA_FORMAT.blobName((String)id)));
        })).collect(Collectors.toList());
    }

    private void cleanupStaleBlobs(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData newRepoData, RepositoryData oldRepoData, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, ActionListener<DeleteResult> listener, Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap) {
        GroupedActionListener<DeleteResult> groupedListener = new GroupedActionListener<DeleteResult>(ActionListener.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse(deleteResult);
        }, listener::onFailure), 2);
        ExecutorService executor = this.threadPool.executor("snapshot_deletion");
        List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(newRepoData, rootBlobs.keySet());
        if (staleRootBlobs.isEmpty()) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            executor.execute(ActionRunnable.supply(groupedListener, () -> {
                List<String> deletedBlobs = this.cleanupStaleRootFiles(newRepoData.getGenId() - 1L, deletedSnapshots, staleRootBlobs);
                return new DeleteResult(deletedBlobs.size(), deletedBlobs.stream().mapToLong(name -> ((BlobMetadata)rootBlobs.get(name)).length()).sum());
            }));
        }
        Set<String> survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        if (foundIndices.keySet().equals(survivingIndexIds)) {
            groupedListener.onResponse(DeleteResult.ZERO);
        } else {
            Map<String, BlobMetadata> snapshotShardPaths = this.getSnapshotShardPaths();
            this.cleanupStaleIndices(deletedSnapshots, foundIndices, survivingIndexIds, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, oldRepoData, groupedListener, snapshotShardPaths, idToShardInfoMap);
        }
    }

    private Map<String, BlobMetadata> getSnapshotShardPaths() {
        try {
            return this.snapshotShardPathBlobContainer().listBlobs();
        }
        catch (IOException ex) {
            logger.warn((Message)new ParameterizedMessage("Repository [{}] Failed to get the snapshot shard paths", (Object)this.metadata.name()), (Throwable)ex);
            return Collections.emptyMap();
        }
    }

    public void cleanup(long repositoryStateId, Version repositoryMetaVersion, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, ActionListener<RepositoryCleanupResult> listener) {
        try {
            if (this.isReadOnly()) {
                throw new RepositoryException(this.metadata.name(), "cannot run cleanup on readonly repository");
            }
            Map<String, BlobMetadata> rootBlobs = this.blobContainer().listBlobs();
            RepositoryData repositoryData = this.safeRepositoryData(repositoryStateId, rootBlobs);
            Map<String, BlobContainer> foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
            Set survivingIndexIds = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
            List<String> staleRootBlobs = BlobStoreRepository.staleRootBlobs(repositoryData, rootBlobs.keySet());
            if (survivingIndexIds.equals(foundIndices.keySet()) && staleRootBlobs.isEmpty()) {
                listener.onResponse(new RepositoryCleanupResult(DeleteResult.ZERO));
            } else {
                this.writeIndexGen(repositoryData, repositoryStateId, repositoryMetaVersion, Function.identity(), Priority.NORMAL, ActionListener.wrap(v -> this.cleanupStaleBlobs(Collections.emptyList(), foundIndices, rootBlobs, repositoryData, repositoryData, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, ActionListener.map(listener, RepositoryCleanupResult::new), Collections.emptyMap()), listener::onFailure));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (SNAPSHOT_FORMAT.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (GLOBAL_METADATA_FORMAT.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            if (blob.startsWith("index-")) {
                return repositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(long previousGeneration, Collection<SnapshotId> deletedSnapshots, List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            if (logger.isInfoEnabled()) {
                Set blobNamesToIgnore = deletedSnapshots.stream().flatMap(snapshotId -> Stream.of(GLOBAL_METADATA_FORMAT.blobName(snapshotId.getUUID()), SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()), "index-" + previousGeneration)).collect(Collectors.toSet());
                List blobsToLog = blobsToDelete.stream().filter(b -> !blobNamesToIgnore.contains(b)).collect(Collectors.toList());
                if (!blobsToLog.isEmpty()) {
                    logger.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToLog);
                }
            }
            this.deleteFromContainer(this.blobContainer(), blobsToDelete);
            return blobsToDelete;
        }
        catch (IOException e) {
            logger.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of root level blobs", (Object)this.metadata.name()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    void cleanupStaleIndices(Collection<SnapshotId> deletedSnapshots, Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, RepositoryData oldRepoData, GroupedActionListener<DeleteResult> listener, Map<String, BlobMetadata> snapshotShardPaths, Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap) {
        GroupedActionListener<DeleteResult> groupedListener = new GroupedActionListener<DeleteResult>(ActionListener.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse(deleteResult);
        }, listener::onFailure), foundIndices.size() - survivingIndexIds.size());
        try {
            LinkedBlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete = new LinkedBlockingQueue<Map.Entry<String, BlobContainer>>();
            for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
                if (survivingIndexIds.contains(indexEntry.getKey())) continue;
                staleIndicesToDelete.put(indexEntry);
            }
            int workers = Math.min(this.threadPool.info("snapshot_deletion").getMax(), foundIndices.size() - survivingIndexIds.size());
            for (int i = 0; i < workers; ++i) {
                this.executeOneStaleIndexDelete(deletedSnapshots, staleIndicesToDelete, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, oldRepoData, groupedListener, snapshotShardPaths, idToShardInfoMap);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale indices", (Object)this.metadata.name()), (Throwable)e);
        }
    }

    private static boolean isIndexPresent(ClusterService clusterService, String indexUUID) {
        for (IndexMetadata indexMetadata : clusterService.state().metadata().getIndices().values()) {
            if (!indexUUID.equals(indexMetadata.getIndexUUID())) continue;
            return true;
        }
        return false;
    }

    private void executeOneStaleIndexDelete(Collection<SnapshotId> deletedSnapshots, BlockingQueue<Map.Entry<String, BlobContainer>> staleIndicesToDelete, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, RepositoryData oldRepoData, GroupedActionListener<DeleteResult> listener, Map<String, BlobMetadata> snapshotShardPaths, Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap) throws InterruptedException {
        Map.Entry<String, BlobContainer> indexEntry = staleIndicesToDelete.poll(0L, TimeUnit.MILLISECONDS);
        if (indexEntry == null) {
            return;
        }
        String indexSnId = indexEntry.getKey();
        this.threadPool.executor("snapshot_deletion").execute(ActionRunnable.supply(listener, () -> {
            try {
                logger.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)this.metadata.name(), (Object)indexSnId);
                List<String> matchingShardPaths = this.findMatchingShardPaths(indexSnId, snapshotShardPaths);
                Optional<String> highestGenShardPaths = this.findHighestGenerationShardPaths(matchingShardPaths);
                SnapshotShardPaths.ShardInfo shardInfo = this.getShardInfo(highestGenShardPaths, idToShardInfoMap, indexSnId);
                if (remoteStoreLockManagerFactory != null) {
                    this.cleanupRemoteStoreLocks(indexEntry, shardInfo, remoteStoreLockManagerFactory);
                }
                DeleteResult deleteResult = this.deleteShardData(shardInfo);
                deleteResult = deleteResult.add(this.cleanUpStaleSnapshotShardPathsFile(matchingShardPaths, snapshotShardPaths));
                if (remoteSegmentStoreDirectoryFactory != null) {
                    this.cleanRemoteStoreDirectoryIfNeeded(deletedSnapshots, indexSnId, oldRepoData, remoteSegmentStoreDirectoryFactory, true);
                }
                deleteResult = deleteResult.add(this.deleteContainer((BlobContainer)indexEntry.getValue()));
                logger.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
                DeleteResult deleteResult2 = deleteResult;
                return deleteResult2;
            }
            catch (IOException e) {
                logger.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshots in the repository, but failed to clean up their index folders", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
                DeleteResult deleteResult = DeleteResult.ZERO;
                return deleteResult;
            }
            catch (Exception e) {
                assert (false) : e;
                logger.warn((Message)new ParameterizedMessage("[{}] Exception during single stale index delete", (Object)this.metadata.name()), (Throwable)e);
                DeleteResult deleteResult = DeleteResult.ZERO;
                return deleteResult;
            }
            finally {
                this.executeOneStaleIndexDelete(deletedSnapshots, staleIndicesToDelete, remoteStoreLockManagerFactory, remoteSegmentStoreDirectoryFactory, oldRepoData, listener, snapshotShardPaths, idToShardInfoMap);
            }
        }));
    }

    private DeleteResult deleteContainer(BlobContainer container) throws IOException {
        long startTime = System.nanoTime();
        DeleteResult deleteResult = container.delete();
        logger.debug((Message)new ParameterizedMessage("[{}] Deleted {} in {}ns", new Object[]{this.metadata.name(), container.path(), startTime - System.nanoTime()}));
        return deleteResult;
    }

    private void cleanRemoteStoreDirectoryIfNeeded(Collection<SnapshotId> deletedSnapshots, String indexSnId, RepositoryData oldRepoData, RemoteSegmentStoreDirectoryFactory remoteSegmentStoreDirectoryFactory, boolean forceClean) {
        assert (indexSnId != null);
        IndexId indexId = null;
        List<Object> snapshotIds = Collections.emptyList();
        try {
            for (Map.Entry<IndexId, List<SnapshotId>> entry : oldRepoData.getIndexSnapshots().entrySet()) {
                indexId = entry.getKey();
                if (indexId == null || !indexId.getId().equals(indexSnId)) continue;
                snapshotIds = entry.getValue();
                break;
            }
            if (snapshotIds.isEmpty()) {
                logger.info("No snapshots found for indexSnId: {}", (Object)indexSnId);
                return;
            }
            for (SnapshotId snapshotId : snapshotIds) {
                try {
                    IndexMetadata prevIndexMetadata;
                    if (!deletedSnapshots.contains(snapshotId) || (prevIndexMetadata = this.getSnapshotIndexMetaData(oldRepoData, snapshotId, indexId)) == null || BlobStoreRepository.isIndexPresent(this.clusterService, prevIndexMetadata.getIndexUUID())) continue;
                    String remoteStoreRepository = IndexMetadata.INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING.get(prevIndexMetadata.getSettings());
                    assert (remoteStoreRepository != null);
                    String remoteTranslogRepositoryName = IndexMetadata.INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING.get(prevIndexMetadata.getSettings());
                    assert (remoteTranslogRepositoryName != null);
                    Repository remoteTranslogRepository = remoteSegmentStoreDirectoryFactory.getRepositoriesService().get().repository(remoteTranslogRepositoryName);
                    RemoteStorePathStrategy remoteStorePathStrategy = RemoteStoreUtils.determineRemoteStorePathStrategy(prevIndexMetadata);
                    for (int shardId = 0; shardId < prevIndexMetadata.getNumberOfShards(); ++shardId) {
                        ShardId shard = new ShardId("_unknown_", prevIndexMetadata.getIndexUUID(), shardId);
                        BlobStoreRepository.remoteDirectoryCleanupAsync(remoteSegmentStoreDirectoryFactory, this.threadPool, remoteStoreRepository, prevIndexMetadata.getIndexUUID(), shard, "remote_purge", remoteStorePathStrategy, forceClean);
                        this.remoteTranslogCleanupAsync(remoteTranslogRepository, shard, remoteStorePathStrategy, prevIndexMetadata, forceClean);
                    }
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("Exception during cleanup of remote directory for snapshot [{}] deleted index [{}]", (Object)snapshotId, (Object)indexSnId), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Message)new ParameterizedMessage("Exception during the remote directory cleanup for indecSnId [{}]", (Object)indexSnId), (Throwable)e);
        }
    }

    private void remoteTranslogCleanupAsync(Repository remoteTranslogRepository, ShardId shardId, RemoteStorePathStrategy remoteStorePathStrategy, IndexMetadata prevIndexMetadata, boolean forceClean) {
        assert (remoteTranslogRepository instanceof BlobStoreRepository);
        boolean indexMetadataEnabled = RemoteStoreUtils.determineTranslogMetadataEnabled(prevIndexMetadata);
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = new RemoteTranslogTransferTracker(shardId, 1000);
        FileTransferTracker fileTransferTracker = new FileTransferTracker(shardId, remoteTranslogTransferTracker);
        TranslogTransferManager translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager((BlobStoreRepository)remoteTranslogRepository, this.threadPool, shardId, fileTransferTracker, remoteTranslogTransferTracker, remoteStorePathStrategy, this.remoteStoreSettings, indexMetadataEnabled);
        try {
            RemoteFsTimestampAwareTranslog.cleanupOfDeletedIndex(translogTransferManager, forceClean);
        }
        catch (IOException e) {
            logger.error("Exception while cleaning up remote translog for shard: " + String.valueOf(shardId), (Throwable)e);
        }
    }

    private List<String> findMatchingShardPaths(String indexId, Map<String, BlobMetadata> snapshotShardPaths) {
        return snapshotShardPaths.keySet().stream().filter(s -> s.startsWith(indexId) || s.startsWith("snapshot_path_" + indexId)).collect(Collectors.toList());
    }

    private Optional<String> findHighestGenerationShardPaths(List<String> matchingShardPaths) {
        if (matchingShardPaths.isEmpty()) {
            return Optional.empty();
        }
        int maxGen = Integer.MIN_VALUE;
        String maxGenShardPath = null;
        for (String shardPath : matchingShardPaths) {
            String[] parts = shardPath.split("\\.");
            int shardCount = Integer.parseInt(parts[parts.length - 3]);
            if (shardCount <= maxGen) continue;
            maxGen = shardCount;
            maxGenShardPath = shardPath;
        }
        assert (maxGenShardPath != null) : "Valid maxGenShardPath should be present";
        return Optional.of(maxGenShardPath);
    }

    private void cleanupRemoteStoreLocks(Map.Entry<String, BlobContainer> indexEntry, SnapshotShardPaths.ShardInfo shardInfo, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) throws IOException {
        if (shardInfo == null) {
            this.releaseRemoteStoreLocksAndCleanup(indexEntry.getValue().children(), remoteStoreLockManagerFactory);
        } else {
            HashMap<String, BlobContainer> shardContainers = new HashMap<String, BlobContainer>(shardInfo.getShardCount());
            for (int i = 0; i < shardInfo.getShardCount(); ++i) {
                shardContainers.put(String.valueOf(i), this.shardContainer(shardInfo.getIndexId(), i));
            }
            this.releaseRemoteStoreLocksAndCleanup(shardContainers, remoteStoreLockManagerFactory);
        }
    }

    void releaseRemoteStoreLocksAndCleanup(Map<String, BlobContainer> shardBlobs, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) throws IOException {
        for (Map.Entry<String, BlobContainer> shardBlob : shardBlobs.entrySet()) {
            for (String blob : shardBlob.getValue().listBlobs().keySet()) {
                Optional<String> snapshotUUID = BlobStoreRepository.extractShallowSnapshotUUID(blob);
                if (!snapshotUUID.isPresent()) continue;
                this.releaseRemoteStoreLockAndCleanup(shardBlob.getKey(), snapshotUUID.get(), shardBlob.getValue(), remoteStoreLockManagerFactory);
            }
        }
    }

    private DeleteResult deleteShardData(SnapshotShardPaths.ShardInfo shardInfo) throws IOException, ExecutionException, InterruptedException {
        if (shardInfo == null) {
            return DeleteResult.ZERO;
        }
        DeleteResult deleteResult = DeleteResult.ZERO;
        for (int i = 0; i < shardInfo.getShardCount(); ++i) {
            deleteResult = deleteResult.add(this.deleteContainer(this.shardContainer(shardInfo.getIndexId(), i)));
        }
        return deleteResult;
    }

    private SnapshotShardPaths.ShardInfo getShardInfo(Optional<String> highestGenShardPaths, Map<String, SnapshotShardPaths.ShardInfo> idToShardInfoMap, String indexId) {
        SnapshotShardPaths.ShardInfo shardInfoFromPath = highestGenShardPaths.map(SnapshotShardPaths::parseShardPath).orElse(null);
        SnapshotShardPaths.ShardInfo shardInfoFromMap = idToShardInfoMap.get(indexId);
        if (shardInfoFromPath == null) {
            return shardInfoFromMap;
        }
        if (shardInfoFromMap == null) {
            return shardInfoFromPath;
        }
        return shardInfoFromPath.getShardCount() >= shardInfoFromMap.getShardCount() ? shardInfoFromPath : shardInfoFromMap;
    }

    private DeleteResult cleanUpStaleSnapshotShardPathsFile(List<String> matchingShardPaths, Map<String, BlobMetadata> snapshotShardPaths) throws IOException {
        this.deleteFromContainer(this.snapshotShardPathBlobContainer(), matchingShardPaths);
        long totalBytes = matchingShardPaths.stream().mapToLong(s -> ((BlobMetadata)snapshotShardPaths.get(s)).length()).sum();
        return new DeleteResult(matchingShardPaths.size(), totalBytes);
    }

    @Override
    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, Function<ClusterState, ClusterState> stateTransformer, ActionListener<RepositoryData> listener) {
        this.finalizeSnapshot(shardGenerations, repositoryStateId, clusterMetadata, snapshotInfo, repositoryMetaVersion, stateTransformer, Priority.NORMAL, listener);
    }

    @Override
    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, Function<ClusterState, ClusterState> stateTransformer, Priority repositoryUpdatePriority, ActionListener<RepositoryData> listener) {
        assert (repositoryStateId > -2L) : "Must finalize based on a valid repository generation but received [" + repositoryStateId + "]";
        Collection<IndexId> indices = shardGenerations.indices();
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        Consumer<Exception> onUpdateFailure = e -> listener.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e));
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        StepListener<RepositoryData> repoDataListener = new StepListener<RepositoryData>();
        this.getRepositoryData(repoDataListener);
        repoDataListener.whenComplete(existingRepositoryData -> {
            ConcurrentMap indexMetas = ConcurrentCollections.newConcurrentMap();
            ConcurrentMap indexMetaIdentifiers = ConcurrentCollections.newConcurrentMap();
            GroupedActionListener allMetaListener = new GroupedActionListener(ActionListener.wrap(v -> {
                RepositoryData updatedRepositoryData = existingRepositoryData.addSnapshot(snapshotId, snapshotInfo.state(), Version.CURRENT, shardGenerations, indexMetas, indexMetaIdentifiers);
                Set<String> updatedIndexIds = this.writeNewIndexShardPaths((RepositoryData)existingRepositoryData, updatedRepositoryData, snapshotId);
                this.cleanupRedundantSnapshotShardPaths(updatedIndexIds);
                this.writeIndexGen(updatedRepositoryData, repositoryStateId, repositoryMetaVersion, stateTransformer, repositoryUpdatePriority, ActionListener.wrap(newRepoData -> this.cleanupOldShardGens((RepositoryData)existingRepositoryData, updatedRepositoryData, (RepositoryData)newRepoData, listener), onUpdateFailure));
            }, onUpdateFailure), 2 + indices.size());
            executor.execute(ActionRunnable.run(allMetaListener, () -> GLOBAL_METADATA_FORMAT.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), this.compressor)));
            for (IndexId index : indices) {
                executor.execute(ActionRunnable.run(allMetaListener, () -> {
                    IndexMetadata indexMetaData = clusterMetadata.index(index.getName());
                    String identifiers = IndexMetaDataGenerations.buildUniqueIdentifier(indexMetaData);
                    String metaUUID = existingRepositoryData.indexMetaDataGenerations().getIndexMetaBlobId(identifiers);
                    if (metaUUID == null) {
                        metaUUID = UUIDs.base64UUID();
                        INDEX_METADATA_FORMAT.write(indexMetaData, this.indexContainer(index), metaUUID, this.compressor);
                        indexMetaIdentifiers.put(identifiers, metaUUID);
                    }
                    indexMetas.put(index, identifiers);
                }));
            }
            executor.execute(ActionRunnable.run(allMetaListener, () -> SNAPSHOT_FORMAT.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), this.compressor)));
        }, onUpdateFailure);
    }

    private void cleanupRedundantSnapshotShardPaths(Set<String> updatedShardPathsIndexIds) {
        try {
            Set updatedIndexIds = updatedShardPathsIndexIds.stream().map(s -> SnapshotShardPaths.getIndexId(s.split("\\.")[0])).collect(Collectors.toSet());
            logger.debug((Message)new ParameterizedMessage("updatedIndexIds={}", updatedIndexIds));
            Set<String> indexIdShardPaths = this.getSnapshotShardPaths().keySet();
            logger.debug((Message)new ParameterizedMessage("indexIdShardPaths={}", indexIdShardPaths));
            List<String> staleShardPaths = indexIdShardPaths.stream().filter(s -> !updatedShardPathsIndexIds.contains(s)).filter(s -> {
                String indexId = SnapshotShardPaths.getIndexId(s.split("\\.")[0]);
                return updatedIndexIds.contains(indexId);
            }).collect(Collectors.toList());
            logger.debug((Message)new ParameterizedMessage("staleShardPaths={}", staleShardPaths));
            this.deleteFromContainer(this.snapshotShardPathBlobContainer(), staleShardPaths);
        }
        catch (Exception e) {
            logger.warn((Message)new ParameterizedMessage("Repository [{}] Exception during snapshot stale index deletion for updatedIndexIds {}", (Object)this.metadata.name(), updatedShardPathsIndexIds), (Throwable)e);
        }
    }

    private Set<String> writeNewIndexShardPaths(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData, SnapshotId snapshotId) {
        HashSet<String> updatedIndexIds = new HashSet<String>();
        HashSet<IndexId> indicesToUpdate = new HashSet<IndexId>(updatedRepositoryData.getIndices().values());
        for (IndexId indexId : indicesToUpdate) {
            String shardPathsBlobName;
            if (indexId.getShardPathType() == RemoteStoreEnums.PathType.FIXED.getCode()) continue;
            int oldShardCount = existingRepositoryData.shardGenerations().getGens(indexId).size();
            int newShardCount = updatedRepositoryData.shardGenerations().getGens(indexId).size();
            if (newShardCount <= oldShardCount || !Objects.nonNull(shardPathsBlobName = this.writeIndexShardPaths(indexId, snapshotId, newShardCount))) continue;
            updatedIndexIds.add(shardPathsBlobName);
        }
        return updatedIndexIds;
    }

    String writeIndexShardPaths(IndexId indexId, SnapshotId snapshotId, int shardCount) {
        try {
            List<String> paths = this.getShardPaths(indexId, shardCount);
            int pathType = indexId.getShardPathType();
            int pathHashAlgorithm = RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1.getCode();
            String name = String.join((CharSequence)".", indexId.getId(), indexId.getName(), String.valueOf(shardCount), String.valueOf(pathType), String.valueOf(pathHashAlgorithm));
            SnapshotShardPaths shardPaths = new SnapshotShardPaths(paths, indexId.getId(), indexId.getName(), shardCount, RemoteStoreEnums.PathType.fromCode(pathType), RemoteStoreEnums.PathHashAlgorithm.fromCode(pathHashAlgorithm));
            SNAPSHOT_SHARD_PATHS_FORMAT.write(shardPaths, this.snapshotShardPathBlobContainer(), name);
            this.logShardPathsOperationSuccess(indexId, snapshotId);
            return "snapshot_path_" + name;
        }
        catch (IOException e) {
            this.logShardPathsOperationWarning(indexId, snapshotId, e);
            return null;
        }
    }

    private List<String> getShardPaths(IndexId indexId, int shardCount) {
        ArrayList<String> paths = new ArrayList<String>();
        for (int shardId = 0; shardId < shardCount; ++shardId) {
            BlobPath shardPath = this.shardPath(indexId, shardId);
            paths.add(shardPath.buildAsString());
        }
        return paths;
    }

    private void logShardPathsOperationSuccess(IndexId indexId, SnapshotId snapshotId) {
        logger.trace(() -> new ParameterizedMessage("Repository [{}] successfully wrote shard paths for index [{}] in snapshot [{}]", new Object[]{this.metadata.name(), indexId.getName(), snapshotId.getName()}));
    }

    private void logShardPathsOperationWarning(IndexId indexId, SnapshotId snapshotId, @Nullable Exception e) {
        logger.warn(() -> new ParameterizedMessage("Repository [{}] Failed to write shard paths for index [{}] in snapshot [{}]", new Object[]{this.metadata.name(), indexId.getName(), snapshotId.getName()}), (Throwable)e);
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData, RepositoryData newRepositoryData, ActionListener<RepositoryData> listener) {
        ArrayList toDelete = new ArrayList();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardPath((IndexId)indexId, (int)shardId).buildAsString() + "index-" + oldGen)));
        if (toDelete.isEmpty()) {
            listener.onResponse(newRepositoryData);
            return;
        }
        try {
            AtomicInteger counter = new AtomicInteger();
            Collection<List<String>> subList = toDelete.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / this.maxShardBlobDeleteBatch)).values();
            LinkedBlockingQueue<List<String>> staleFilesToDeleteInBatch = new LinkedBlockingQueue<List<String>>(subList);
            logger.info("[{}] cleanupOldShardGens toDeleteSize={} groupSize={}", (Object)this.metadata.name(), (Object)toDelete.size(), (Object)staleFilesToDeleteInBatch.size());
            GroupedActionListener<Void> groupedListener = new GroupedActionListener<Void>(ActionListener.wrap(r -> {
                logger.info("[{}] completed cleanupOldShardGens", (Object)this.metadata.name());
                listener.onResponse(newRepositoryData);
            }, ex -> {
                logger.error((Message)new ParameterizedMessage("[{}] exception in cleanupOldShardGens", (Object)this.metadata.name()), (Throwable)ex);
                listener.onResponse(newRepositoryData);
            }), staleFilesToDeleteInBatch.size());
            int workers = Math.min(this.threadPool.info("snapshot_deletion").getMax(), staleFilesToDeleteInBatch.size());
            for (int i = 0; i < workers; ++i) {
                this.executeOldShardGensCleanup(staleFilesToDeleteInBatch, groupedListener);
            }
        }
        catch (Exception e) {
            logger.warn((Message)new ParameterizedMessage(" [{}] Failed to clean up old shard generation blobs", (Object)this.metadata.name()), (Throwable)e);
            listener.onResponse(newRepositoryData);
        }
    }

    private void executeOldShardGensCleanup(BlockingQueue<List<String>> staleFilesToDeleteInBatch, GroupedActionListener<Void> listener) throws InterruptedException {
        List<String> filesToDelete = staleFilesToDeleteInBatch.poll(0L, TimeUnit.MILLISECONDS);
        if (filesToDelete != null) {
            this.threadPool.executor("snapshot_deletion").execute(ActionRunnable.wrap(listener, l -> {
                try {
                    this.deleteFromContainer(this.rootBlobContainer(), filesToDelete);
                    l.onResponse(null);
                }
                catch (Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] Failed to delete following blobs during cleanupOldFiles : {}", (Object)this.metadata.name(), (Object)filesToDelete), (Throwable)e);
                    l.onFailure(e);
                }
                this.executeOldShardGensCleanup(staleFilesToDeleteInBatch, listener);
            }));
        }
    }

    @Override
    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return SNAPSHOT_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException | NotXContentException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex);
        }
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return GLOBAL_METADATA_FORMAT.read(this.blobContainer(), snapshotId.getUUID(), this.namedXContentRegistry);
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex);
        }
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        try {
            return INDEX_METADATA_FORMAT.read(this.indexContainer(index), repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, index), this.namedXContentRegistry);
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)e);
        }
    }

    private void deleteFromContainer(BlobContainer container, List<String> blobs) throws IOException {
        logger.trace(() -> new ParameterizedMessage("[{}] Deleting {} from [{}]", new Object[]{this.metadata.name(), blobs, container.path()}));
        long startTime = System.nanoTime();
        container.deleteBlobsIgnoringIfNotExists(blobs);
        logger.debug(() -> new ParameterizedMessage("[{}] Deletion {} from [{}] took {}ns", new Object[]{this.metadata.name(), blobs, container.path(), System.nanoTime() - startTime}));
    }

    private BlobPath indicesPath() {
        return this.basePath().add(INDICES_DIR);
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indexPath(indexId));
    }

    private BlobPath indexPath(IndexId indexId) {
        return this.indicesPath().add(indexId.getId());
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.shardContainer(indexId, shardId.getId());
    }

    public BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.shardPath(indexId, shardId));
    }

    private BlobPath shardPath(IndexId indexId, int shardId) {
        RemoteStoreEnums.PathType pathType = RemoteStoreEnums.PathType.fromCode(indexId.getShardPathType());
        RemoteStorePathStrategy.SnapshotShardPathInput shardPathInput = ((RemoteStorePathStrategy.SnapshotShardPathInput.Builder)((RemoteStorePathStrategy.SnapshotShardPathInput.Builder)((RemoteStorePathStrategy.SnapshotShardPathInput.Builder)new RemoteStorePathStrategy.SnapshotShardPathInput.Builder().basePath(this.basePath())).indexUUID(indexId.getId())).shardId(String.valueOf(shardId)).fixedPrefix(this.snapshotShardPathPrefix)).build();
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = pathType != RemoteStoreEnums.PathType.FIXED ? RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1 : null;
        return pathType.path(shardPathInput, pathHashAlgorithm);
    }

    private RateLimiter getRateLimiter(Setting<ByteSizeValue> bytesPerSecSetting, Settings settings) {
        ByteSizeValue maxByteSize = bytesPerSecSetting.get(settings);
        if (maxByteSize.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxByteSize.getMbFrac());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRemoteUploadThrottleTimeInNanos() {
        return this.remoteUploadRateLimitingTimeInNanos.count();
    }

    @Override
    public long getLowPriorityRemoteUploadThrottleTimeInNanos() {
        return this.remoteUploadLowPriorityRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRemoteDownloadThrottleTimeInNanos() {
        return this.remoteDownloadRateLimitingTimeInNanos.count();
    }

    @Override
    public long getLowPriorityRemoteDownloadThrottleTimeInNanos() {
        return this.remoteDownloadLowPriorityRateLimitingTimeInNanos.count();
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains("[snapshot_deletion]") || Thread.currentThread().getName().contains("[snapshot]") || Thread.currentThread().getName().contains("[generic]")) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to be the snapshot_deletion or snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.testContainer(seed);
            BytesArray bytes = new BytesArray(testBytes);
            if (!this.isSystemRepository) {
                try (StreamInput stream = bytes.streamInput();){
                    testContainer.writeBlobAtomic("master.dat", stream, bytes.length(), true);
                }
            }
            return seed;
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + String.valueOf(this.basePath()) + " is not accessible on cluster-manager node", exp);
        }
    }

    private BlobContainer testContainer(String seed) {
        BlobPath testBlobPath;
        if (this.prefixModeVerification && (!this.clusterService.isStateInitialised() || this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(Version.V_2_17_0))) {
            RemoteStorePathStrategy.PathInput pathInput = ((RemoteStorePathStrategy.PathInput.Builder)((RemoteStorePathStrategy.PathInput.Builder)RemoteStorePathStrategy.PathInput.builder().basePath(this.basePath())).indexUUID(seed)).build();
            testBlobPath = RemoteStoreEnums.PathType.HASHED_PREFIX.path(pathInput, RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1);
        } else {
            testBlobPath = this.basePath();
        }
        assert (Objects.nonNull(testBlobPath));
        return this.blobStore().blobContainer(testBlobPath.add(BlobStoreRepository.testBlobPrefix(seed)));
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                this.testContainer(seed).delete();
            }
            catch (Exception exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + String.valueOf(this.basePath()), exp);
            }
        }
    }

    @Override
    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        Tuple<Long, BytesReference> cached;
        if (this.latestKnownRepoGen.get() == -3L) {
            listener.onFailure(this.corruptedStateException(null));
            return;
        }
        SoftReference<Tuple<Long, BytesReference>> softRef = this.latestKnownRepositoryData.get();
        Tuple<Long, BytesReference> tuple = cached = softRef != null ? softRef.get() : null;
        if (!this.bestEffortConsistency && cached != null && cached.v1().longValue() == this.latestKnownRepoGen.get()) {
            try {
                listener.onResponse(this.repositoryDataFromCachedEntry(cached));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return;
        }
        this.threadPool.generic().execute(ActionRunnable.wrap(listener, this::doGetRepositoryData));
    }

    private void doGetRepositoryData(ActionListener<RepositoryData> listener) {
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (IOException ioe) {
                    listener.onFailure(new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", ioe));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, generation));
                if (genToLoad > generation) {
                    logger.info("Determined repository generation [" + generation + "] from repository contents but correct generation must be at least [" + genToLoad + "]");
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                RepositoryData loaded;
                Tuple<Long, BytesReference> cached;
                SoftReference<Tuple<Long, BytesReference>> softRef = this.latestKnownRepositoryData.get();
                Tuple<Long, BytesReference> tuple = cached = softRef != null ? softRef.get() : null;
                if (!this.bestEffortConsistency && cached != null && cached.v1() == genToLoad) {
                    loaded = this.repositoryDataFromCachedEntry(cached);
                } else {
                    loaded = this.getRepositoryData(genToLoad);
                    Version minNodeVersion = this.clusterService.state().nodes().getMinNodeVersion();
                    this.cacheRepositoryData(BytesReference.bytes(loaded.snapshotsToXContent(XContentFactory.jsonBuilder(), Version.CURRENT, minNodeVersion)), genToLoad);
                }
                listener.onResponse(loaded);
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    logger.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && ExceptionsHelper.unwrap(e, NoSuchFileException.class) != null) {
                    this.markRepoCorrupted(genToLoad, e, ActionListener.wrap(v -> listener.onFailure(this.corruptedStateException(e)), listener::onFailure));
                } else {
                    listener.onFailure(e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e));
                return;
            }
            break;
        }
    }

    private void cacheRepositoryData(BytesReference updated, long generation) {
        if (this.cacheRepositoryData && !this.bestEffortConsistency) {
            BytesReference serialized;
            try {
                serialized = CompressorRegistry.defaultCompressor().compress(updated);
                int len = serialized.length();
                long cacheWarningThreshold = Math.min(this.repositoryDataCacheThreshold * 10L, 0x7FFFFFF7L);
                if ((long)len > this.repositoryDataCacheThreshold) {
                    logger.debug("Not caching repository data of size [{}] for repository [{}] because it is larger than [{}] bytes in serialized size", (Object)len, (Object)this.metadata.name(), (Object)this.repositoryDataCacheThreshold);
                    if ((long)len > cacheWarningThreshold) {
                        logger.warn("Your repository metadata blob for repository [{}] is larger than [{}] bytes. Consider moving to a fresh repository for new snapshots or deleting unneeded snapshots from your repository to ensure stable repository behavior going forward.", (Object)this.metadata.name(), (Object)cacheWarningThreshold);
                    }
                    this.latestKnownRepositoryData.set(null);
                    return;
                }
            }
            catch (IOException e) {
                assert (false) : new AssertionError("Impossible, no IO happens here", e);
                logger.warn("Failed to serialize repository data", (Throwable)e);
                return;
            }
            this.latestKnownRepositoryData.updateAndGet(knownRef -> {
                Tuple known;
                Tuple tuple = known = knownRef != null ? (Tuple)knownRef.get() : null;
                if (known != null && (Long)known.v1() > generation) {
                    return knownRef;
                }
                return new SoftReference<Tuple<Long, BytesReference>>(new Tuple<Long, BytesReference>(generation, serialized));
            });
        }
    }

    private RepositoryData repositoryDataFromCachedEntry(Tuple<Long, BytesReference> cacheEntry) throws IOException {
        try (InputStream input = CompressorRegistry.defaultCompressor().threadLocalInputStream(cacheEntry.v2().streamInput());){
            RepositoryData repositoryData = RepositoryData.snapshotsFromXContent(MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, input), cacheEntry.v1());
            return repositoryData;
        }
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause) {
        return new RepositoryException(this.metadata.name(), "Could not read repository data because the contents of the repository do not match its expected state. This is likely the result of either concurrently modifying the contents of the repository by a process other than this cluster or an issue with the repository's underlying storage. The repository has been disabled to prevent corrupting its contents. To re-enable it and continue using it please remove the repository from the cluster and add it again to make the cluster recover the known state of the repository from its physical contents.", cause);
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        this.clusterService.submitStateUpdateTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(this){
            final /* synthetic */ BlobStoreRepository this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetadata state = (RepositoriesMetadata)currentState.metadata().custom("repositories");
                RepositoryMetadata repoState = state.repository(this.this$0.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + String.valueOf(repoState) + "]");
                }
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("repositories", state.withUpdatedGeneration(this.this$0.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed marking repository state as corrupted", ExceptionsHelper.useOrSuppress(e, originalException)));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + indexGen;
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                logger.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    private static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSystemRepository() {
        return this.isSystemRepository;
    }

    protected void writeIndexGen(RepositoryData repositoryData, final long expectedGen, Version version, final Function<ClusterState, ClusterState> stateFilter, Priority repositoryUpdatePriority, final ActionListener<RepositoryData> listener) {
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]"));
            return;
        }
        final StepListener<Long> setPendingStep = new StepListener<Long>();
        this.clusterService.submitStateUpdateTask("set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]", new ClusterStateUpdateTask(this, repositoryUpdatePriority){
            private long newGen;
            final /* synthetic */ BlobStoreRepository this$0;
            {
                this.this$0 = this$0;
                super(priority);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetadata meta = this.this$0.getRepoMetadata(currentState);
                String repoName = this.this$0.metadata.name();
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || this.this$0.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    logger.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + String.valueOf(meta) + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = this.this$0.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > this.this$0.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + this.this$0.latestKnownRepoGen.get() + "]";
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                setPendingStep.onResponse(this.newGen);
            }
        });
        StepListener<RepositoryData> filterRepositoryDataStep = new StepListener<RepositoryData>();
        setPendingStep.whenComplete(newGen -> this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            final List snapshotIdsWithoutVersion = repositoryData.getSnapshotIds().stream().filter(snapshotId -> repositoryData.getVersion((SnapshotId)snapshotId) == null).collect(Collectors.toList());
            if (!snapshotIdsWithoutVersion.isEmpty()) {
                ConcurrentHashMap updatedVersionMap = new ConcurrentHashMap();
                GroupedActionListener loadAllVersionsListener = new GroupedActionListener(ActionListener.runAfter(new ActionListener<Collection<Void>>(){

                    @Override
                    public void onResponse(Collection<Void> voids) {
                        logger.info("Successfully loaded all snapshot's version information for {} from snapshot metadata", (Object)AllocationService.firstListElementsToCommaDelimitedString(snapshotIdsWithoutVersion, SnapshotId::toString, logger.isDebugEnabled()));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Failure when trying to load missing version information from snapshot metadata", (Throwable)e);
                    }
                }, () -> filterRepositoryDataStep.onResponse(repositoryData.withVersions(updatedVersionMap))), snapshotIdsWithoutVersion.size());
                for (SnapshotId snapshotId2 : snapshotIdsWithoutVersion) {
                    this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.run(loadAllVersionsListener, () -> updatedVersionMap.put(snapshotId2, this.getSnapshotInfo(snapshotId2).version())));
                }
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        })), listener::onFailure);
        filterRepositoryDataStep.whenComplete(filteredRepositoryData -> {
            final long newGen = (Long)setPendingStep.result();
            final RepositoryData newRepositoryData = filteredRepositoryData.withGenId(newGen);
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            if (!this.ensureSafeGenerationExists(expectedGen, listener::onFailure)) {
                return;
            }
            String indexBlob = "index-" + Long.toString(newGen);
            logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            Version minNodeVersion = this.clusterService.state().nodes().getMinNodeVersion();
            final BytesReference serializedRepoData = BytesReference.bytes(newRepositoryData.snapshotsToXContent(XContentFactory.jsonBuilder(), version, minNodeVersion));
            this.writeAtomic(this.blobContainer(), indexBlob, serializedRepoData, true);
            this.maybeWriteIndexLatest(newGen);
            this.clusterService.submitStateUpdateTask("set safe repository generation [" + this.metadata.name() + "][" + newGen + "]", new ClusterStateUpdateTask(this, repositoryUpdatePriority){
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                    super(priority);
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetadata meta = this.this$0.getRepoMetadata(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + String.valueOf(meta) + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    return this.this$0.updateRepositoryGenerationsIfNecessary((ClusterState)stateFilter.apply(ClusterState.builder(currentState).metadata(Metadata.builder(currentState.getMetadata()).putCustom("repositories", ((RepositoriesMetadata)currentState.metadata().custom("repositories")).withUpdatedGeneration(this.this$0.metadata.name(), newGen, newGen))).build()), expectedGen, newGen);
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(new RepositoryException(this.this$0.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    this.this$0.cacheRepositoryData(serializedRepoData, newGen);
                    this.this$0.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC).execute(ActionRunnable.supply(listener, () -> {
                        List<String> oldIndexN = LongStream.range(Math.max(Math.max(expectedGen - 1L, 0L), newGen - 1000L), newGen).mapToObj(gen -> "index-" + gen).collect(Collectors.toList());
                        try {
                            this.this$0.deleteFromContainer(this.this$0.blobContainer(), oldIndexN);
                        }
                        catch (IOException e) {
                            logger.warn(() -> new ParameterizedMessage("Failed to clean up old index blobs {}", (Object)oldIndexN), (Throwable)e);
                        }
                        return newRepositoryData;
                    }));
                }
            });
        }, listener::onFailure);
    }

    private void maybeWriteIndexLatest(long newGen) {
        if (this.supportURLRepo) {
            logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
            try {
                this.writeAtomic(this.blobContainer(), INDEX_LATEST_BLOB, new BytesArray(Numbers.longToBytes(newGen)), false);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("Failed to write index.latest blob. If you do not intend to use this repository as the basis for a URL repository you may turn off attempting to write the index.latest blob by setting repository setting [{}] to [false]", (Object)SUPPORT_URL_REPO.getKey()), (Throwable)e);
            }
        }
    }

    private boolean ensureSafeGenerationExists(long safeGeneration, final Consumer<Exception> onFailure) throws IOException {
        logger.debug("Ensure generation [{}] that is the basis for this write exists in [{}]", (Object)safeGeneration, (Object)this.metadata.name());
        if (safeGeneration != -1L && !this.blobContainer().blobExists("index-" + safeGeneration)) {
            final RepositoryException exception = new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + safeGeneration + "] but it was not found in the repository");
            this.markRepoCorrupted(safeGeneration, exception, new ActionListener<Void>(){

                @Override
                public void onResponse(Void aVoid) {
                    onFailure.accept(exception);
                }

                @Override
                public void onFailure(Exception e) {
                    onFailure.accept(e);
                }
            });
            return false;
        }
        return true;
    }

    private ClusterState updateRepositoryGenerationsIfNecessary(ClusterState state, long oldGen, long newGen) {
        String repoName = this.metadata.name();
        boolean changedSnapshots = false;
        ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
        for (SnapshotsInProgress.Entry entry : state.custom("snapshots", SnapshotsInProgress.EMPTY).entries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                snapshotEntries.add(entry.withRepoGen(newGen));
                changedSnapshots = true;
                continue;
            }
            snapshotEntries.add(entry);
        }
        SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? SnapshotsInProgress.of(snapshotEntries) : null;
        boolean changedDeletions = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> deletionEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
            if (entry.repository().equals(repoName) && entry.repositoryStateId() == oldGen) {
                deletionEntries.add(entry.withRepoGen(newGen));
                changedDeletions = true;
                continue;
            }
            deletionEntries.add(entry);
        }
        SnapshotDeletionsInProgress updatedDeletionsInProgress = changedDeletions ? SnapshotDeletionsInProgress.of(deletionEntries) : null;
        return SnapshotsService.updateWithSnapshots(state, updatedSnapshotsInProgress, updatedDeletionsInProgress);
    }

    private RepositoryMetadata getRepoMetadata(ClusterState state) {
        RepositoryMetadata repositoryMetadata = ((RepositoriesMetadata)state.getMetadata().custom("repositories")).repository(this.metadata.name());
        assert (repositoryMetadata != null);
        return repositoryMetadata;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        return BytesRefUtils.bytesToLong(Streams.readFully(this.blobContainer().readBlob(INDEX_LATEST_BLOB)).toBytesRef());
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                logger.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(BlobContainer container, String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to {} atomically", new Object[]{this.metadata.name(), blobName, container.path()}));
            container.writeBlobAtomic(blobName, stream, bytesRef.length(), failIfAlreadyExists);
        }
    }

    @Override
    public void snapshotRemoteStoreIndexShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, long primaryTerm, long startTime, ActionListener<String> listener) {
        this.snapshotRemoteStoreIndexShard(store, snapshotId, indexId, snapshotIndexCommit, shardStateIdentifier, snapshotStatus, primaryTerm, snapshotIndexCommit.getGeneration(), startTime, null, listener);
    }

    @Override
    public void snapshotRemoteStoreIndexShard(Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, long primaryTerm, long commitGeneration, long startTime, Map<String, Long> indexFilesToFileLengthMap, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository"));
            return;
        }
        ShardId shardId = store.shardId();
        try {
            ArrayList<String> fileNames;
            String generation = snapshotStatus.generation();
            logger.info("[{}] [{}] shallow copy snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            long indexTotalFileSize = 0L;
            if (snapshotIndexCommit != null) {
                fileNames = new ArrayList<String>(snapshotIndexCommit.getFileNames());
                Store.MetadataSnapshot commitSnapshotMetadata = store.getMetadata(snapshotIndexCommit);
                for (String fileName : fileNames) {
                    indexTotalFileSize += commitSnapshotMetadata.get(fileName).length();
                }
            } else {
                fileNames = new ArrayList<String>(indexFilesToFileLengthMap.keySet());
                indexTotalFileSize = indexFilesToFileLengthMap.values().stream().mapToLong(Long::longValue).sum();
            }
            int indexTotalNumberOfFiles = fileNames.size();
            snapshotStatus.moveToStarted(startTime, 0, indexTotalNumberOfFiles, 0L, indexTotalFileSize);
            IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(commitGeneration);
            logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
            try {
                RemoteStorePathStrategy pathStrategy = store.indexSettings().getRemoteStorePathStrategy();
                REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.write(new RemoteStoreShardShallowCopySnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), primaryTerm, commitGeneration, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), indexTotalNumberOfFiles, indexTotalFileSize, store.indexSettings().getUUID(), store.indexSettings().getRemoteStoreRepository(), this.basePath().toString(), fileNames, pathStrategy.getType(), pathStrategy.getHashAlgorithm()), shardContainer, snapshotId.getUUID(), this.compressor);
            }
            catch (IOException e) {
                throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point for snapshot " + snapshotId.getName() + "(" + snapshotId.getUUID() + ")", e);
            }
            snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), generation);
            listener.onResponse(generation);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void snapshotShard(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, Map<String, Object> userMetadata, ActionListener<String> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot snapshot shard on a readonly repository"));
            return;
        }
        ShardId shardId = store.shardId();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            List indexCommitPointFiles;
            Set<Object> blobs;
            String generation = snapshotStatus.generation();
            logger.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, String> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = tuple.v1();
            String fileListGeneration = tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            List filesFromSegmentInfos = Optional.ofNullable(shardStateIdentifier).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            if (store.indexSettings().isRemoteSnapshot()) {
                indexCommitPointFiles = List.of();
            } else if (filesFromSegmentInfos == null) {
                Collection<String> fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList();
                try (Iterator ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    try {
                        logger.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                    }
                }
                ignored = fileNames.iterator();
                while (ignored.hasNext()) {
                    String fileName = (String)ignored.next();
                    if (snapshotStatus.isAborted()) {
                        logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                        throw new AbortedSnapshotException();
                    }
                    logger.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetadata md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            if (!fileInfo.isSame(md)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                        }
                        assert (needsWrite || BlobStoreRepository.assertFileContentsMatchHash(snapshotFileInfo, store));
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesFromSegmentInfos) {
                    ++indexTotalNumberOfFiles;
                    indexTotalFileSize += fileInfo.length();
                }
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            newSnapshotsList.add(new SnapshotFiles(snapshotId.getName(), indexCommitPointFiles, shardStateIdentifier));
            for (SnapshotFiles point : snapshots) {
                newSnapshotsList.add(point);
            }
            BlobStoreIndexShardSnapshots updatedBlobStoreIndexShardSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            String indexGeneration = UUIDs.randomBase64UUID();
            try {
                INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedBlobStoreIndexShardSnapshots, shardContainer, indexGeneration, this.compressor);
            }
            catch (IOException e) {
                throw new IndexShardSnapshotFailedException(shardId, "Failed to write shard level snapshot metadata for [" + String.valueOf(snapshotId) + "] to [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(indexGeneration) + "]", e);
            }
            StepListener<Collection<Void>> allFilesUploadedListener = new StepListener<Collection<Void>>();
            allFilesUploadedListener.whenComplete(v -> {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                try {
                    INDEX_SHARD_SNAPSHOT_FORMAT.write(new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize()), shardContainer, snapshotId.getUUID(), this.compressor);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), indexGeneration);
                listener.onResponse(indexGeneration);
            }, listener::onFailure);
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, filesListener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void executeOneFileSnapshot(Store store, SnapshotId snapshotId, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot, Executor executor, ActionListener<Void> listener) throws InterruptedException {
        ShardId shardId = store.shardId();
        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
        if (snapshotFileInfo == null) {
            listener.onResponse(null);
        } else {
            executor.execute(ActionRunnable.wrap(listener, l -> {
                try (Releasable ignored = BlobStoreRepository.incrementStoreRef(store, snapshotStatus, shardId);){
                    this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                    this.executeOneFileSnapshot(store, snapshotId, indexId, snapshotStatus, filesToSnapshot, executor, (ActionListener<Void>)l);
                }
            }));
        }
    }

    private static Releasable incrementStoreRef(Store store, IndexShardSnapshotStatus snapshotStatus, ShardId shardId) {
        if (!store.tryIncRef()) {
            if (snapshotStatus.isAborted()) {
                throw new AbortedSnapshotException();
            }
            assert (false) : "Store should not be closed concurrently unless snapshot is aborted";
            throw new IndexShardSnapshotFailedException(shardId, "Store got closed concurrently");
        }
        return store::decRef;
    }

    private static boolean assertFileContentsMatchHash(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
            byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
            indexInput.readBytes(tmp, 0, tmp.length);
            assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @Override
    public void restoreShard(final Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = ActionListener.delegateResponse(listener, (l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + String.valueOf(snapshotId) + "]", (Throwable)e)));
        final ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        executor.execute(ActionRunnable.wrap(restoreListener, l -> {
            IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(container, snapshotId);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot snapshot = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this, this.metadata.name(), shardId, snapshotId, recoveryState){
                final /* synthetic */ BlobStoreRepository this$0;
                {
                    this.this$0 = this$0;
                    super(repositoryName, shardId, snapshotId, recoveryState);
                }

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store2, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int workers = Math.min(this.this$0.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, ActionListener.map(listener, v -> null));
                        for (int i = 0; i < workers; ++i) {
                            try {
                                this.executeOneFileRestore(files, allFilesListener);
                                continue;
                            }
                            catch (Exception e) {
                                allFilesListener.onFailure(e);
                            }
                        }
                    }
                }

                private void executeOneFileRestore(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, ActionListener<Void> allFilesListener) throws InterruptedException {
                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover = files.poll(0L, TimeUnit.MILLISECONDS);
                    if (fileToRecover == null) {
                        allFilesListener.onResponse(null);
                    } else {
                        executor.execute(ActionRunnable.wrap(allFilesListener, filesListener -> {
                            store.incRef();
                            try {
                                this.restoreFile(fileToRecover, store);
                            }
                            finally {
                                store.decRef();
                            }
                            this.executeOneFileRestore(files, (ActionListener<Void>)filesListener);
                        }));
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, final Store store2) throws IOException {
                    this.ensureNotClosing(store2);
                    logger.trace(() -> new ParameterizedMessage("[{}] restoring [{}] to [{}]", new Object[]{this.this$0.metadata.name(), fileInfo, store2}));
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store2.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = this.this$0.maybeRateLimitRestores(new SlicedInputStream(this, fileInfo.numberOfParts()){
                                    final /* synthetic */ 10 this$1;
                                    {
                                        this.this$1 = this$1;
                                        super(numSlices);
                                    }

                                    @Override
                                    protected InputStream openSlice(int slice) throws IOException {
                                        this.this$1.ensureNotClosing(store2);
                                        return container.readBlob(fileInfo.partName(slice));
                                    }
                                });){
                                    int length;
                                    byte[] buffer = new byte[Math.toIntExact(Math.min((long)this.this$0.bufferSize, fileInfo.length()))];
                                    while ((length = stream.read(buffer)) > 0) {
                                        this.ensureNotClosing(store2);
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store2.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store2.markStoreCorrupted(ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                logger.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store2.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store2.deleteQuiet(fileInfo.physicalName());
                    return;
                }

                void ensureNotClosing(Store store2) throws AlreadyClosedException {
                    assert (store2.refCount() > 0);
                    if (store2.isClosing()) {
                        throw new AlreadyClosedException("store is closing");
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return ActionListener.delegateResponse(new GroupedActionListener(listener, workers), (l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static void mayBeLogRateLimits(BlobStoreTransferContext context, RateLimiter rateLimiter, long time) {
        logger.debug(() -> new ParameterizedMessage("Rate limited blob store transfer, context [{}], for duration [{} ms] for configured rate [{} MBps]", new Object[]{context, TimeValue.timeValueNanos(time).millis(), rateLimiter.getMBPerSec()}));
    }

    private static InputStream maybeRateLimit(InputStream stream, Supplier<RateLimiter> rateLimiterSupplier, CounterMetric metric, BlobStoreTransferContext context) {
        return new RateLimitingInputStream(stream, rateLimiterSupplier, t -> {
            BlobStoreRepository.mayBeLogRateLimits(context, (RateLimiter)rateLimiterSupplier.get(), t);
            metric.inc(t);
        });
    }

    private static OffsetRangeInputStream maybeRateLimitRemoteTransfers(OffsetRangeInputStream offsetRangeInputStream, Supplier<RateLimiter> rateLimiterSupplier, CounterMetric metric, BlobStoreTransferContext context) {
        return new RateLimitingOffsetRangeInputStream(offsetRangeInputStream, rateLimiterSupplier, t -> {
            BlobStoreRepository.mayBeLogRateLimits(context, (RateLimiter)rateLimiterSupplier.get(), t);
            metric.inc(t);
        });
    }

    public InputStream maybeRateLimitRestores(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(stream, () -> this.restoreRateLimiter, this.restoreRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT_RESTORE), this.recoverySettings::recoveryRateLimiter, this.restoreRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT_RESTORE);
    }

    public OffsetRangeInputStream maybeRateLimitRemoteUploadTransfers(OffsetRangeInputStream offsetRangeInputStream) {
        return BlobStoreRepository.maybeRateLimitRemoteTransfers(offsetRangeInputStream, () -> this.remoteUploadRateLimiter, this.remoteUploadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_UPLOAD);
    }

    public OffsetRangeInputStream maybeRateLimitLowPriorityRemoteUploadTransfers(OffsetRangeInputStream offsetRangeInputStream) {
        return BlobStoreRepository.maybeRateLimitRemoteTransfers(BlobStoreRepository.maybeRateLimitRemoteTransfers(offsetRangeInputStream, () -> this.remoteUploadRateLimiter, this.remoteUploadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_UPLOAD), () -> this.remoteUploadLowPriorityRateLimiter, this.remoteUploadLowPriorityRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_UPLOAD);
    }

    public InputStream maybeRateLimitRemoteDownloadTransfers(InputStream inputStream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(inputStream, () -> this.remoteDownloadRateLimiter, this.remoteDownloadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD), this.recoverySettings::recoveryRateLimiter, this.remoteDownloadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD);
    }

    public InputStream maybeRateLimitLowPriorityDownloadTransfers(InputStream inputStream) {
        return BlobStoreRepository.maybeRateLimit(BlobStoreRepository.maybeRateLimit(inputStream, () -> this.remoteDownloadLowPriorityRateLimiter, this.remoteDownloadLowPriorityRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD), this.recoverySettings::recoveryRateLimiter, this.remoteDownloadRateLimitingTimeInNanos, BlobStoreTransferContext.REMOTE_DOWNLOAD);
    }

    public InputStream maybeRateLimitSnapshots(InputStream stream) {
        return BlobStoreRepository.maybeRateLimit(stream, () -> this.snapshotRateLimiter, this.snapshotRateLimitingTimeInNanos, BlobStoreTransferContext.SNAPSHOT);
    }

    public RateLimiter snapshotRateLimiter() {
        return this.snapshotRateLimiter;
    }

    public RateLimiter restoreRateLimiter() {
        return this.restoreRateLimiter;
    }

    public RateLimiter remoteUploadRateLimiter() {
        return this.remoteUploadRateLimiter;
    }

    public RateLimiter remoteUploadLowPriorityRateLimiter() {
        return this.remoteUploadLowPriorityRateLimiter;
    }

    public RateLimiter remoteDownloadRateLimiter() {
        return this.remoteDownloadRateLimiter;
    }

    @Override
    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        return Arrays.asList(SYSTEM_REPOSITORY_SETTING, READONLY_SETTING, REMOTE_STORE_INDEX_SHALLOW_COPY);
    }

    @Override
    public RemoteStoreShardShallowCopySnapshot getRemoteStoreShallowCopyShardMetadata(SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId) {
        BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        IndexShardSnapshot indexShardSnapshot = this.loadShardSnapshot(container, snapshotId);
        assert (indexShardSnapshot instanceof RemoteStoreShardShallowCopySnapshot) : "indexShardSnapshot should be an instance of RemoteStoreShardShallowCopySnapshot";
        return (RemoteStoreShardShallowCopySnapshot)indexShardSnapshot;
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        IndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return snapshot.getIndexShardSnapshotStatus();
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotInfo snapshotInfo, IndexId indexId, ShardId shardId) {
        IndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotInfo);
        return snapshot.getIndexShardSnapshotStatus();
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        if (!this.isSystemRepository) {
            this.assertSnapshotOrGenericThread();
        }
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + String.valueOf(this.basePath()) + " is not accessible on node " + String.valueOf(localNode), e);
            }
        }
        BlobContainer testBlobContainer = this.testContainer(seed);
        try {
            BytesArray bytes = new BytesArray(seed);
            try (StreamInput stream = bytes.streamInput();){
                testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", stream, bytes.length(), true);
            }
        }
        catch (Exception exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + String.valueOf(this.blobStore()) + "] is not accessible on the node [" + String.valueOf(localNode) + "]", exp);
        }
        if (!this.isSystemRepository) {
            try (InputStream masterDat = testBlobContainer.readBlob("master.dat");){
                String seedRead = Streams.readFully(masterDat).utf8ToString();
                if (!seedRead.equals(seed)) {
                    throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
                }
            }
            catch (NoSuchFileException e) {
                throw new RepositoryVerificationException(this.metadata.name(), "a file written by cluster-manager to the store [" + String.valueOf(this.blobStore()) + "] cannot be accessed on the node [" + String.valueOf(localNode) + "]. This might indicate that the store [" + String.valueOf(this.blobStore()) + "] is not shared between this node and the cluster-manager node or that permissions on the store don't allow reading files written by the cluster-manager node", e);
            }
            catch (Exception e) {
                throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
            }
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + String.valueOf(this.blobStore.get()) + "]]";
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, int snapshotShardId, Collection<SnapshotId> snapshotIds, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, long indexGeneration, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        String writtenGeneration = null;
        try {
            BlobStoreIndexShardSnapshots updatedSnapshots;
            if (survivingSnapshots.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, "_deleted", blobs);
            }
            if (newSnapshotsList.size() > 0) {
                updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
                if (indexGeneration < 0L) {
                    writtenGeneration = UUIDs.randomBase64UUID();
                    INDEX_SHARD_SNAPSHOTS_FORMAT.write(updatedSnapshots, shardContainer, writtenGeneration, this.compressor);
                } else {
                    writtenGeneration = String.valueOf(indexGeneration);
                    this.writeShardIndexBlobAtomic(shardContainer, indexGeneration, updatedSnapshots);
                }
            } else {
                updatedSnapshots = BlobStoreIndexShardSnapshots.EMPTY;
                writtenGeneration = "_deleted";
            }
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId, writtenGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots, remoteStoreLockManagerFactory));
        }
        catch (IOException e) {
            throw new RepositoryException(this.metadata.name(), "Failed to finalize snapshot deletion " + String.valueOf(snapshotIds) + " with shard index [" + INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(writtenGeneration) + "]", e);
        }
    }

    private void writeShardIndexBlobAtomic(BlobContainer shardContainer, long indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots) throws IOException {
        assert (indexGeneration >= 0L) : "Shard generation must not be negative but saw [" + indexGeneration + "]";
        logger.trace(() -> new ParameterizedMessage("[{}] Writing shard index [{}] to [{}]", new Object[]{this.metadata.name(), indexGeneration, shardContainer.path()}));
        String blobName = INDEX_SHARD_SNAPSHOTS_FORMAT.blobName(String.valueOf(indexGeneration));
        this.writeAtomic(shardContainer, blobName, INDEX_SHARD_SNAPSHOTS_FORMAT.serialize(updatedSnapshots, blobName, this.compressor, ChecksumBlobStoreFormat.SNAPSHOT_ONLY_FORMAT_PARAMS), true);
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots, RemoteStoreLockManagerFactory remoteStoreLockManagerFactory) {
        return blobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat") && !survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length())) || remoteStoreLockManagerFactory != null && BlobStoreRepository.extractShallowSnapshotUUID(blob).map(snapshotUUID -> !survivingSnapshotUUIDs.contains(snapshotUUID)).orElse(false) != false || blob.startsWith(UPLOADED_DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).collect(Collectors.toList());
    }

    public IndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            if (shardContainer.blobExists(INDEX_SHARD_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                return INDEX_SHARD_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
            }
            if (shardContainer.blobExists(REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                return REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
            }
            throw new SnapshotMissingException(this.metadata.name(), snapshotId.getName());
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + String.valueOf(shardContainer.path()) + "]", (Throwable)ex);
        }
    }

    public IndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotInfo snapshotInfo) {
        try {
            SnapshotId snapshotId = snapshotInfo.snapshotId();
            if (snapshotInfo.getPinnedTimestamp() != 0L) {
                return () -> IndexShardSnapshotStatus.newDone(0L, 0L, 0, 0, 0L, 0L, "1");
            }
            if (Boolean.TRUE.equals(snapshotInfo.isRemoteStoreIndexShallowCopyEnabled())) {
                if (shardContainer.blobExists(REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                    return REMOTE_STORE_SHARD_SHALLOW_COPY_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
                }
                throw new SnapshotMissingException(this.metadata.name(), snapshotId.getName());
            }
            if (shardContainer.blobExists(INDEX_SHARD_SNAPSHOT_FORMAT.blobName(snapshotId.getUUID()))) {
                return INDEX_SHARD_SNAPSHOT_FORMAT.read(shardContainer, snapshotId.getUUID(), this.namedXContentRegistry);
            }
            throw new SnapshotMissingException(this.metadata.name(), snapshotId.getName());
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotInfo.snapshotId(), "failed to read shard snapshot file for [" + String.valueOf(shardContainer.path()) + "]", (Throwable)ex);
        }
    }

    private Tuple<BlobStoreIndexShardSnapshots, String> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable String generation) throws IOException {
        if (generation != null) {
            if (generation.equals("_new")) {
                return new Tuple<BlobStoreIndexShardSnapshots, String>(BlobStoreIndexShardSnapshots.EMPTY, "_new");
            }
            return new Tuple<BlobStoreIndexShardSnapshots, String>(INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, generation, this.namedXContentRegistry), generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple<BlobStoreIndexShardSnapshots, String>(legacyIndex.v1(), String.valueOf(legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = INDEX_SHARD_SNAPSHOTS_FORMAT.read(shardContainer, Long.toString(latest), this.namedXContentRegistry);
            return new Tuple<BlobStoreIndexShardSnapshots, Long>(shardSnapshots, latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            logger.warn("Could not find a readable index-N file in a non-empty shard snapshot directory [" + String.valueOf(shardContainer.path()) + "]");
        }
        return new Tuple<BlobStoreIndexShardSnapshots, Long>(BlobStoreIndexShardSnapshots.EMPTY, latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.DEFAULT, fileInfo.metadata());){
            for (int i = 0; i < fileInfo.numberOfParts(); ++i) {
                long partBytes = fileInfo.partBytes(i);
                FilterInputStream inputStream = new FilterInputStream(this, this.maybeRateLimitSnapshots(new InputStreamIndexInput(indexInput, partBytes))){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new AbortedSnapshotException();
                        }
                    }
                };
                String partName = fileInfo.partName(i);
                logger.trace(() -> new ParameterizedMessage("[{}] Writing [{}] to [{}]", new Object[]{this.metadata.name(), partName, shardContainer.path()}));
                shardContainer.writeBlob(partName, inputStream, partBytes, false);
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                logger.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    private static Optional<String> extractShallowSnapshotUUID(String blobName) {
        if (blobName.startsWith(SHALLOW_SNAPSHOT_PREFIX)) {
            return Optional.of(blobName.substring(SHALLOW_SNAPSHOT_PREFIX.length(), blobName.length() - ".dat".length()));
        }
        return Optional.empty();
    }

    @Override
    public boolean isReloadableSettings(RepositoryMetadata newRepositoryMetadata) {
        if (!(this.metadata.name().equals(newRepositoryMetadata.name()) && this.metadata.type().equals(newRepositoryMetadata.type()) && Objects.equals(this.metadata.cryptoMetadata(), newRepositoryMetadata.cryptoMetadata()))) {
            return false;
        }
        Settings newSettings = newRepositoryMetadata.settings();
        if (RELOADABLE_SETTINGS.containsAll(newSettings.keySet())) {
            return true;
        }
        Settings currentSettings = this.metadata.settings();
        Set allKeys = Stream.concat(newSettings.keySet().stream(), currentSettings.keySet().stream()).filter(key -> !RELOADABLE_SETTINGS.contains(key)).collect(Collectors.toSet());
        return allKeys.stream().allMatch(key -> this.isSettingEqual(newSettings, currentSettings, (String)key));
    }

    private boolean isSettingEqual(Settings s1, Settings s2, String key) {
        return Objects.equals(s1.get(key), s2.get(key));
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final String newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, String newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }

    static enum BlobStoreTransferContext {
        REMOTE_UPLOAD("remote_upload"),
        REMOTE_DOWNLOAD("remote_download"),
        SNAPSHOT("snapshot"),
        SNAPSHOT_RESTORE("snapshot_restore");

        private final String name;

        private BlobStoreTransferContext(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

