/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.common.lucene.store.IndexOutputOutputStream;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.compress.CompressorRegistry;
import org.opensearch.gateway.CorruptStateException;

public class ChecksumWritableBlobStoreFormat<T extends Writeable> {
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final CheckedFunction<StreamInput, T, IOException> reader;

    public ChecksumWritableBlobStoreFormat(String codec, CheckedFunction<StreamInput, T, IOException> reader) {
        this.codec = codec;
        this.reader = reader;
    }

    public BytesReference serialize(T obj, String blobName, Compressor compressor) throws IOException {
        return this.serialize((out, unSerializedObj) -> unSerializedObj.writeTo(out), obj, blobName, compressor);
    }

    public BytesReference serialize(Writeable.Writer<T> writer, T obj, String blobName, Compressor compressor) throws IOException {
        try (BytesStreamOutput outputStream = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, outputStream, 4096);){
                CodecUtil.writeHeader(indexOutput, this.codec, 1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(this, indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };
                     OutputStreamStreamOutput stream = new OutputStreamStreamOutput(compressor.threadLocalOutputStream(indexOutputOutputStream));){
                    stream.setVersion(Version.CURRENT);
                    writer.write(stream, obj);
                }
                CodecUtil.writeFooter(indexOutput);
            }
            BytesReference bytesReference = outputStream.bytes();
            return bytesReference;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            IndexInput indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile(indexInput);
            CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            BytesReference bytesReference = bytes.slice((int)filePointer, (int)contentSize);
            Compressor compressor = CompressorRegistry.compressorForWritable(bytesReference);
            try (InputStreamStreamInput in = new InputStreamStreamInput(compressor.threadLocalInputStream(bytesReference.streamInput()));){
                Writeable writeable = (Writeable)this.reader.apply(in);
                return (T)writeable;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }
}

