/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.admin.indices.open.OpenIndexAction;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.tasks.LoggingTaskListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestOpenIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestOpenIndexAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_open"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_open")));
    }

    @Override
    public String getName() {
        return "open_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        OpenIndexRequest openIndexRequest = new OpenIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        openIndexRequest.timeout(request.paramAsTime("timeout", openIndexRequest.timeout()));
        openIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", openIndexRequest.clusterManagerNodeTimeout()));
        RestOpenIndexAction.parseDeprecatedMasterTimeoutParameter(openIndexRequest, request, deprecationLogger, this.getName());
        openIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, openIndexRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            openIndexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.admin().indices().open(openIndexRequest, new RestToXContentListener<OpenIndexResponse>((RestChannel)channel));
        }
        openIndexRequest.setShouldStoreResult(true);
        openIndexRequest.timeout(request.paramAsTime("task_execution_timeout", AcknowledgedRequest.DEFAULT_TASK_EXECUTION_TIMEOUT));
        ActionRequestValidationException validationException = openIndexRequest.validate();
        if (validationException != null) {
            throw validationException;
        }
        return this.sendTask(client.getLocalNodeId(), client.executeLocally(OpenIndexAction.INSTANCE, openIndexRequest, LoggingTaskListener.instance()));
    }
}

