/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.script.ScriptType;
import org.opensearch.script.mustache.RenderSearchTemplateAction;
import org.opensearch.script.mustache.SearchTemplateRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_render/template"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template"), new RestHandler.Route(RestRequest.Method.GET, "/_render/template/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template/{id}")));
    }

    @Override
    public String getName() {
        return "render_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest renderRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            renderRequest = SearchTemplateRequest.fromXContent(parser);
        }
        renderRequest.setSimulate(true);
        String id = request.param("id");
        if (id != null) {
            renderRequest.setScriptType(ScriptType.STORED);
            renderRequest.setScript(id);
        }
        return channel -> client.execute(RenderSearchTemplateAction.INSTANCE, renderRequest, new RestToXContentListener((RestChannel)channel));
    }
}

