/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.Nullable;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

class DateRangeHistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Range valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding.Prepared preparedRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final LongKeyedBucketOrds bucketOrds;

    DateRangeHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, Rounding.Prepared preparedRounding, BucketOrder order, boolean keyed, long minDocCount, @Nullable LongBounds extendedBounds, @Nullable LongBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.rounding = rounding;
        this.preparedRounding = preparedRounding;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Range)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        if (this.valuesSource.rangeType() != RangeType.DATE) {
            throw new IllegalArgumentException("Expected date range type but found range type [" + this.valuesSource.rangeType().name + "]");
        }
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ DateRangeHistogramAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values2);
            }

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    assert (valuesCount == 1) : "Value count for ranges should always be 1";
                    long previousKey = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef encodedRanges = values.nextValue();
                        List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(encodedRanges);
                        long previousFrom = Long.MIN_VALUE;
                        for (RangeFieldMapper.Range range : ranges) {
                            Long from = (Long)range.getFrom();
                            assert (from >= previousFrom) : "Start of range not >= previous start";
                            Long to = (Long)range.getTo();
                            long effectiveFrom = this.this$0.hardBounds != null && this.this$0.hardBounds.getMin() != null ? Long.max(from, this.this$0.hardBounds.getMin()) : from;
                            long effectiveTo = this.this$0.hardBounds != null && this.this$0.hardBounds.getMax() != null ? Long.min(to, this.this$0.hardBounds.getMax()) : to;
                            long startKey = this.this$0.preparedRounding.round(effectiveFrom);
                            long endKey = this.this$0.preparedRounding.round(effectiveTo);
                            long key = Long.max(startKey, previousKey);
                            while (key <= endKey) {
                                if (key != previousKey) {
                                    long bucketOrd = this.this$0.bucketOrds.add(owningBucketOrd, key);
                                    if (bucketOrd < 0L) {
                                        bucketOrd = -1L - bucketOrd;
                                        this.this$0.collectExistingBucket(sub, doc, bucketOrd);
                                    } else {
                                        this.this$0.collectBucket(sub, doc, bucketOrd);
                                    }
                                }
                                key = this.this$0.preparedRounding.nextRoundingValue(key);
                            }
                            if (endKey <= previousKey) continue;
                            previousKey = endKey;
                        }
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalDateHistogram.Bucket(bucketValue, docCount, this.keyed, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            this.checkCancelled();
            CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
            InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding.withoutOffset(), this.buildEmptySubAggregations(), this.extendedBounds) : null;
            return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.rounding.offset(), emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
    }
}

