/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalGeoCentroid;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

final class GeoCentroidAggregator
extends MetricsAggregator {
    private final ValuesSource.GeoPoint valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private LongArray counts;

    GeoCentroidAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        ValuesSource.GeoPoint geoPoint = this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.lonSum = bigArrays.newDoubleArray(1L, true);
            this.lonCompensations = bigArrays.newDoubleArray(1L, true);
            this.latSum = bigArrays.newDoubleArray(1L, true);
            this.latCompensations = bigArrays.newDoubleArray(1L, true);
            this.counts = bigArrays.newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ GeoCentroidAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub, values2);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                this.this$0.latSum = bigArrays.grow(this.this$0.latSum, bucket + 1L);
                this.this$0.lonSum = bigArrays.grow(this.this$0.lonSum, bucket + 1L);
                this.this$0.lonCompensations = bigArrays.grow(this.this$0.lonCompensations, bucket + 1L);
                this.this$0.latCompensations = bigArrays.grow(this.this$0.latCompensations, bucket + 1L);
                this.this$0.counts = bigArrays.grow(this.this$0.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    this.this$0.counts.increment(bucket, valueCount);
                    double sumLat = this.this$0.latSum.get(bucket);
                    double compensationLat = this.this$0.latCompensations.get(bucket);
                    double sumLon = this.this$0.lonSum.get(bucket);
                    double compensationLon = this.this$0.lonCompensations.get(bucket);
                    compensatedSumLat.reset(sumLat, compensationLat);
                    compensatedSumLon.reset(sumLon, compensationLon);
                    for (int i = 0; i < valueCount; ++i) {
                        GeoPoint value = values.nextValue();
                        compensatedSumLat.add(value.getLat());
                        compensatedSumLon.add(value.getLon());
                    }
                    this.this$0.lonSum.set(bucket, compensatedSumLon.value());
                    this.this$0.lonCompensations.set(bucket, compensatedSumLon.delta());
                    this.this$0.latSum.set(bucket, compensatedSumLat.value());
                    this.this$0.latCompensations.set(bucket, compensatedSumLat.delta());
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        GeoPoint bucketCentroid = bucketCount > 0L ? new GeoPoint(this.latSum.get(bucket) / (double)bucketCount, this.lonSum.get(bucket) / (double)bucketCount) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts);
    }
}

