/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.metrics.HDRPercentileRanksAggregator;
import org.opensearch.search.aggregations.metrics.HDRPercentilesAggregator;
import org.opensearch.search.aggregations.metrics.PercentilesMethod;
import org.opensearch.search.aggregations.metrics.TDigestPercentileRanksAggregator;
import org.opensearch.search.aggregations.metrics.TDigestPercentilesAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public abstract class PercentilesConfig
implements ToXContent,
Writeable {
    private final PercentilesMethod method;

    PercentilesConfig(PercentilesMethod method) {
        this.method = method;
    }

    public static PercentilesConfig fromStream(StreamInput in) throws IOException {
        PercentilesMethod method = PercentilesMethod.readFromStream(in);
        return method.configFromStream(in);
    }

    @Deprecated
    public static PercentilesConfig fromLegacy(PercentilesMethod method, double compression, int numberOfSignificantDigits) {
        if (method.equals(PercentilesMethod.TDIGEST)) {
            return new TDigest(compression);
        }
        if (method.equals(PercentilesMethod.HDR)) {
            return new Hdr(numberOfSignificantDigits);
        }
        throw new IllegalArgumentException("Unsupported percentiles algorithm [" + String.valueOf(method) + "]");
    }

    public PercentilesMethod getMethod() {
        return this.method;
    }

    public abstract Aggregator createPercentilesAggregator(String var1, ValuesSource var2, SearchContext var3, Aggregator var4, double[] var5, boolean var6, DocValueFormat var7, Map<String, Object> var8) throws IOException;

    abstract Aggregator createPercentileRanksAggregator(String var1, ValuesSource var2, SearchContext var3, Aggregator var4, double[] var5, boolean var6, DocValueFormat var7, Map<String, Object> var8) throws IOException;

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PercentilesConfig other = (PercentilesConfig)obj;
        return this.method.equals(other.getMethod());
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public static class TDigest
    extends PercentilesConfig {
        static final double DEFAULT_COMPRESSION = 100.0;
        private double compression;

        public TDigest() {
            this(100.0);
        }

        public TDigest(double compression) {
            super(PercentilesMethod.TDIGEST);
            this.setCompression(compression);
        }

        TDigest(StreamInput in) throws IOException {
            this(in.readDouble());
        }

        public void setCompression(double compression) {
            if (compression < 0.0) {
                throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "]");
            }
            this.compression = compression;
        }

        public double getCompression() {
            return this.compression;
        }

        @Override
        public Aggregator createPercentilesAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new TDigestPercentilesAggregator(name, valuesSource, context, parent, values, this.compression, keyed, formatter, metadata);
        }

        @Override
        Aggregator createPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new TDigestPercentileRanksAggregator(name, valuesSource, context, parent, values, this.compression, keyed, formatter, metadata);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.compression);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.getMethod().toString());
            builder.field(PercentilesMethod.COMPRESSION_FIELD.getPreferredName(), this.compression);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            TDigest other = (TDigest)obj;
            return this.compression == other.getCompression();
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.compression);
        }
    }

    public static class Hdr
    extends PercentilesConfig {
        static final int DEFAULT_NUMBER_SIG_FIGS = 3;
        private int numberOfSignificantValueDigits;

        public Hdr() {
            this(3);
        }

        public Hdr(int numberOfSignificantValueDigits) {
            super(PercentilesMethod.HDR);
            this.setNumberOfSignificantValueDigits(numberOfSignificantValueDigits);
        }

        Hdr(StreamInput in) throws IOException {
            this(in.readVInt());
        }

        public void setNumberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
            if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
                throw new IllegalArgumentException("[numberOfSignificantValueDigits] must be between 0 and 5");
            }
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        }

        public int getNumberOfSignificantValueDigits() {
            return this.numberOfSignificantValueDigits;
        }

        @Override
        public Aggregator createPercentilesAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new HDRPercentilesAggregator(name, valuesSource, context, parent, values, this.numberOfSignificantValueDigits, keyed, formatter, metadata);
        }

        @Override
        Aggregator createPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new HDRPercentileRanksAggregator(name, valuesSource, context, parent, values, this.numberOfSignificantValueDigits, keyed, formatter, metadata);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.numberOfSignificantValueDigits);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.getMethod().toString());
            builder.field(PercentilesMethod.NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Hdr other = (Hdr)obj;
            return this.numberOfSignificantValueDigits == other.getNumberOfSignificantValueDigits();
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.numberOfSignificantValueDigits);
        }
    }
}

