/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import java.io.IOException;
import java.util.Iterator;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class TDigestState
extends AVLTreeDigest {
    private final double compression;

    public TDigestState(double compression) {
        super(compression);
        this.compression = compression;
    }

    public double compression() {
        return this.compression;
    }

    public static void write(TDigestState state, StreamOutput out) throws IOException {
        out.writeDouble(state.compression);
        out.writeVInt(state.centroidCount());
        for (Centroid centroid : state.centroids()) {
            out.writeDouble(centroid.mean());
            out.writeVLong(centroid.count());
        }
    }

    public static TDigestState read(StreamInput in) throws IOException {
        double compression = in.readDouble();
        TDigestState state = new TDigestState(compression);
        int n = in.readVInt();
        for (int i = 0; i < n; ++i) {
            state.add(in.readDouble(), in.readVInt());
        }
        return state;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TDigestState)) {
            return false;
        }
        TDigestState that = (TDigestState)((Object)obj);
        if (this.compression != that.compression) {
            return false;
        }
        Iterator thisCentroids = this.centroids().iterator();
        Iterator thatCentroids = that.centroids().iterator();
        while (thisCentroids.hasNext()) {
            if (!thatCentroids.hasNext()) {
                return false;
            }
            Centroid thisNext = (Centroid)thisCentroids.next();
            Centroid thatNext = (Centroid)thatCentroids.next();
            if (thisNext.mean() == thatNext.mean() && thisNext.count() == thatNext.count()) continue;
            return false;
        }
        return !thatCentroids.hasNext();
    }

    public int hashCode() {
        int h = ((Object)((Object)this)).getClass().hashCode();
        h = 31 * h + Double.hashCode(this.compression);
        for (Centroid centroid : this.centroids()) {
            h = 31 * h + Double.hashCode(centroid.mean());
            h = 31 * h + centroid.count();
        }
        return h;
    }
}

